/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types.reflect;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import polyglot.ext.jl5.types.AnnotationElementValue;
import polyglot.ext.jl5.types.EnumInstance;
import polyglot.ext.jl5.types.JL5ClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.reflect.JL5ClassFileLazyClassInitializer;
import polyglot.types.Type;
import polyglot.types.reflect.Attribute;
import polyglot.types.reflect.ClassFile;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class Annotations
extends Attribute {
    protected DataInputStream in;
    protected ClassFile cls;
    protected Position position;
    protected Annotation[] annotations;

    Annotations(ClassFile clazz, DataInputStream in, int nameIndex, int length) throws IOException {
        super(nameIndex, length);
        this.cls = clazz;
        int numAnnotations = in.readUnsignedShort();
        this.annotations = new Annotation[numAnnotations];
        for (int i = 0; i < numAnnotations; ++i) {
            this.annotations[i] = new Annotation(clazz, in);
        }
    }

    public Map<Type, Map<String, AnnotationElementValue>> toAnnotationElems(JL5ClassFileLazyClassInitializer init, JL5TypeSystem ts) {
        Position pos = init.position();
        LinkedHashMap<Type, Map<String, AnnotationElementValue>> m = new LinkedHashMap<Type, Map<String, AnnotationElementValue>>();
        for (Annotation a : this.annotations) {
            String typeString = (String)this.cls.getConstants()[a.typeIndex].value();
            Type type = init.typeForString(typeString);
            m.put(type, a.createAnnotationElementValues(init, ts, pos));
        }
        return m;
    }

    class ElementValueArray
    implements ElementValue {
        ElementValue[] vals;

        public ElementValueArray(ElementValue[] vals) {
            this.vals = vals;
        }

        @Override
        public AnnotationElementValue toAnnotationElementValue(JL5ClassFileLazyClassInitializer init, JL5TypeSystem ts, Position pos) {
            ArrayList<AnnotationElementValue> l = new ArrayList<AnnotationElementValue>();
            for (ElementValue v : this.vals) {
                l.add(v.toAnnotationElementValue(init, ts, pos));
            }
            return ts.AnnotationElementValueArray(pos, l);
        }
    }

    class ElementValueClassConstant
    implements ElementValue {
        int classInfo;

        public ElementValueClassConstant(int classInfo) {
            this.classInfo = classInfo;
        }

        @Override
        public AnnotationElementValue toAnnotationElementValue(JL5ClassFileLazyClassInitializer init, JL5TypeSystem ts, Position pos) {
            return ts.AnnotationElementValueConstant(pos, ts.Class(), init.typeForString((String)Annotations.this.cls.getConstants()[this.classInfo].value()));
        }
    }

    class ElementValueEnumConstant
    implements ElementValue {
        int typeIndex;
        int constNameIndex;

        public ElementValueEnumConstant(int typeIndex, int constNameIndex) {
            this.typeIndex = typeIndex;
            this.constNameIndex = constNameIndex;
        }

        @Override
        public AnnotationElementValue toAnnotationElementValue(JL5ClassFileLazyClassInitializer init, JL5TypeSystem ts, Position pos) {
            String typeName = (String)Annotations.this.cls.getConstants()[this.typeIndex].value();
            String constName = (String)Annotations.this.cls.getConstants()[this.constNameIndex].value();
            Type type = init.typeForString(typeName);
            if (!type.isClass()) {
                throw new InternalCompilerError("Type " + type + " (" + typeName + ") is not a class.");
            }
            JL5ClassType ct = (JL5ClassType)type;
            EnumInstance ei = ct.enumConstantNamed(constName);
            if (ei == null) {
                System.err.println("Class is " + ct);
                System.err.println("   " + ct.fields());
                System.err.println("   XXX" + ct.enumConstants());
                System.err.println("   " + ct.enumConstantNamed("METHOD"));
                throw new InternalCompilerError("No enum constant named " + constName + " in " + type);
            }
            return ts.AnnotationElementValueConstant(pos, type, ei);
        }
    }

    class ElementValueConstant
    implements ElementValue {
        char type;
        int constValueIndex;

        public ElementValueConstant(char type, int constValueIndex) {
            this.type = type;
            this.constValueIndex = constValueIndex;
        }

        @Override
        public AnnotationElementValue toAnnotationElementValue(JL5ClassFileLazyClassInitializer init, JL5TypeSystem ts, Position pos) {
            return ts.AnnotationElementValueConstant(pos, init.typeForString(String.valueOf(this.type)), Annotations.this.cls.getConstants()[this.constValueIndex].value());
        }
    }

    static interface ElementValue {
        public AnnotationElementValue toAnnotationElementValue(JL5ClassFileLazyClassInitializer var1, JL5TypeSystem var2, Position var3);
    }

    class Annotation
    implements ElementValue {
        int typeIndex;
        Map<String, ElementValue> elementValuePairs;
        private ClassFile cls;

        public Annotation(ClassFile clazz, DataInputStream in) throws IOException {
            this.cls = clazz;
            this.typeIndex = in.readUnsignedShort();
            int numElementValuePairs = in.readUnsignedShort();
            this.elementValuePairs = new LinkedHashMap<String, ElementValue>();
            for (int i = 0; i < numElementValuePairs; ++i) {
                int elementNameIndex = in.readUnsignedShort();
                ElementValue val = this.readElementValue(clazz, in);
                String elementName = (String)clazz.getConstants()[elementNameIndex].value();
                this.elementValuePairs.put(elementName, val);
            }
        }

        public Map<String, AnnotationElementValue> createAnnotationElementValues(JL5ClassFileLazyClassInitializer init, JL5TypeSystem ts, Position pos) {
            LinkedHashMap<String, AnnotationElementValue> m = new LinkedHashMap<String, AnnotationElementValue>();
            for (String key : this.elementValuePairs.keySet()) {
                m.put(key, this.elementValuePairs.get(key).toAnnotationElementValue(init, ts, pos));
            }
            return m;
        }

        private ElementValue readElementValue(ClassFile clazz, DataInputStream in) throws IOException {
            char tag = (char)in.readUnsignedByte();
            switch (tag) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': 
                case 's': {
                    int constValueIndex = in.readUnsignedShort();
                    return new ElementValueConstant(Character.toUpperCase(tag), constValueIndex);
                }
                case 'e': {
                    int typeName = in.readUnsignedShort();
                    int constName = in.readUnsignedShort();
                    return new ElementValueEnumConstant(typeName, constName);
                }
                case 'c': {
                    int classInfo = in.readUnsignedShort();
                    return new ElementValueClassConstant(classInfo);
                }
                case '@': {
                    return new Annotation(clazz, in);
                }
                case '[': {
                    int numValues = in.readUnsignedShort();
                    ElementValue[] vals = new ElementValue[numValues];
                    for (int i = 0; i < numValues; ++i) {
                        vals[i] = this.readElementValue(clazz, in);
                    }
                    return new ElementValueArray(vals);
                }
            }
            throw new InternalCompilerError("Don't know how to deal with " + tag);
        }

        @Override
        public AnnotationElementValue toAnnotationElementValue(JL5ClassFileLazyClassInitializer init, JL5TypeSystem ts, Position pos) {
            String typeName = (String)this.cls.getConstants()[this.typeIndex].value();
            Type type = init.typeForString(typeName);
            if (!type.isClass()) {
                throw new InternalCompilerError("Type " + type + " (" + typeName + ") is not a class.");
            }
            return ts.AnnotationElementValueAnnotation(pos, type, this.createAnnotationElementValues(init, ts, pos));
        }
    }
}

