/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types.inference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import polyglot.ext.jl5.types.AnnotationTypeElemInstance;
import polyglot.ext.jl5.types.Annotations;
import polyglot.ext.jl5.types.EnumInstance;
import polyglot.ext.jl5.types.JL5ClassType;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5SubstClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.JL5TypeSystem_c;
import polyglot.ext.jl5.types.RawClass;
import polyglot.ext.jl5.types.WildCardType;
import polyglot.ext.jl5.types.inference.LubType;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.ClassType_c;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.MethodInstance;
import polyglot.types.Package;
import polyglot.types.ReferenceType;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class LubType_c
extends ClassType_c
implements LubType {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected List<ReferenceType> lubElems;
    protected ReferenceType lubCalculated = null;

    public LubType_c(TypeSystem ts, Position pos, List<ReferenceType> lubElems) {
        super(ts, pos);
        this.lubElems = lubElems;
    }

    @Override
    public List<ReferenceType> lubElements() {
        return this.lubElems;
    }

    @Override
    public ReferenceType calculateLub() {
        if (this.lubCalculated == null) {
            this.lubCalculated = this.lub_force();
        }
        return this.lubCalculated;
    }

    @Override
    public ClassType.Kind kind() {
        return LUB;
    }

    private ReferenceType lub(ReferenceType ... a) {
        ArrayList<ReferenceType> l = new ArrayList<ReferenceType>();
        JL5TypeSystem ts = (JL5TypeSystem)this.ts;
        for (ReferenceType t : a) {
            l.add(t);
        }
        return ts.lub(this.position, l);
    }

    private ReferenceType lub_force() {
        JL5TypeSystem ts = (JL5TypeSystem)this.ts;
        LinkedHashSet<ReferenceType> st = new LinkedHashSet<ReferenceType>();
        LinkedHashSet<ReferenceType> est = null;
        for (ReferenceType u : this.lubElems) {
            st.addAll(ts.allAncestorsOf(u));
            ArrayList<ReferenceType> u_supers = new ArrayList<ReferenceType>();
            for (ReferenceType u_super : ts.allAncestorsOf(u)) {
                if (u_super instanceof RawClass) {
                    u_supers.add(((RawClass)u_super).erased());
                    continue;
                }
                u_supers.add(u_super);
            }
            LinkedHashSet<ReferenceType> est_of_u = new LinkedHashSet<ReferenceType>();
            for (ReferenceType super_of_u : u_supers) {
                if (super_of_u instanceof JL5SubstClassType) {
                    JL5SubstClassType g = (JL5SubstClassType)super_of_u;
                    est_of_u.add(g.base());
                    continue;
                }
                est_of_u.add(super_of_u);
            }
            if (est == null) {
                est = new LinkedHashSet<ReferenceType>();
                est.addAll(est_of_u);
                continue;
            }
            est.retainAll(est_of_u);
        }
        LinkedHashSet mec = new LinkedHashSet(est);
        block5: for (ReferenceType e1 : est) {
            for (ReferenceType e2 : est) {
                if (ts.equals(e1, e2) || !ts.isSubtype(e2, e1)) continue;
                mec.remove(e1);
                continue block5;
            }
        }
        ArrayList<ReferenceType> cand = new ArrayList<ReferenceType>();
        for (ReferenceType m : mec) {
            ArrayList<ReferenceType> inv = new ArrayList<ReferenceType>();
            for (ReferenceType t : st) {
                if (!ts.equals(m, t) && (!(t instanceof JL5SubstClassType) || !((JL5SubstClassType)t).base().equals(m)) && (!(t instanceof RawClass) || !((RawClass)t).erased().base().equals(m))) continue;
                inv.add(t);
            }
            cand.add(this.lci(inv));
        }
        try {
            if (ts.checkIntersectionBounds(cand, true)) {
                return ts.intersectionType(this.position, cand);
            }
        }
        catch (SemanticException e) {
            // empty catch block
        }
        return ts.Object();
    }

    private ReferenceType lci(List<ReferenceType> inv) {
        JL5TypeSystem ts = (JL5TypeSystem)this.ts;
        ReferenceType first = inv.get(0);
        if (inv.size() == 1 || first instanceof RawClass || first instanceof JL5ParsedClassType) {
            return first;
        }
        JL5SubstClassType res = (JL5SubstClassType)first;
        for (int i = 1; i < inv.size(); ++i) {
            ReferenceType next = inv.get(i);
            if (next instanceof RawClass || next instanceof JL5ParsedClassType) {
                return next;
            }
            ArrayList<ReferenceType> lcta_args = new ArrayList<ReferenceType>();
            JL5SubstClassType nextp = (JL5SubstClassType)next;
            for (int argi = 0; argi < res.actuals().size(); ++argi) {
                ReferenceType a1 = (ReferenceType)res.actuals().get(argi);
                ReferenceType a2 = (ReferenceType)nextp.actuals().get(argi);
                lcta_args.add(this.lcta(a1, a2));
            }
            try {
                res = (JL5SubstClassType)ts.instantiate(this.position, res.base(), lcta_args);
                continue;
            }
            catch (SemanticException e) {
                throw new InternalCompilerError("Unexpected SemanticException", e);
            }
        }
        return res;
    }

    private ReferenceType lcta(ReferenceType a1, ReferenceType a2) {
        JL5TypeSystem ts = (JL5TypeSystem)this.ts;
        if (a1 instanceof WildCardType) {
            WildCardType a1wc = (WildCardType)a1;
            if (a2 instanceof WildCardType) {
                WildCardType a2wc = (WildCardType)a2;
                if (a1wc.hasLowerBound() && a2wc.hasLowerBound()) {
                    return ts.wildCardType(this.position, null, this.glb(a1wc.lowerBound(), a2wc.lowerBound()));
                }
                if (a1wc.hasLowerBound()) {
                    if (a1wc.lowerBound().equals(a2wc.upperBound())) {
                        return a1wc.lowerBound();
                    }
                    return ts.wildCardType(this.position);
                }
                if (a2wc.hasLowerBound()) {
                    if (a2wc.lowerBound().equals(a1wc.upperBound())) {
                        return a2wc.lowerBound();
                    }
                    return ts.wildCardType(this.position);
                }
                return ts.wildCardType(this.position, ts.lub(this.position, CollectionUtil.list(a1wc.upperBound(), a2wc.upperBound())), null);
            }
            if (a1wc.hasLowerBound()) {
                return ts.wildCardType(this.position, null, this.glb(a1wc.lowerBound(), a2));
            }
            return ts.wildCardType(this.position, this.lub(a1wc.upperBound(), a2), null);
        }
        if (a2 instanceof WildCardType) {
            WildCardType a2wc = (WildCardType)a2;
            if (a2wc.hasLowerBound()) {
                return ts.wildCardType(this.position, null, this.glb(a1, a2wc.lowerBound()));
            }
            return ts.wildCardType(this.position, this.lub(a1, a2wc.upperBound()), null);
        }
        if (ts.equals(a1, a2)) {
            return a1;
        }
        return ts.wildCardType(this.position, ts.lub(this.position, CollectionUtil.list(a1, a2)), null);
    }

    private ReferenceType glb(ReferenceType t1, ReferenceType t2) {
        JL5TypeSystem ts = (JL5TypeSystem)this.ts;
        List<ReferenceType> l = CollectionUtil.list(t1, t2);
        try {
            if (!ts.checkIntersectionBounds(l, true)) {
                return ts.Object();
            }
            return ts.intersectionType(this.position, l);
        }
        catch (SemanticException e) {
            return ts.Object();
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("lub(");
        sb.append(JL5TypeSystem_c.listToString(this.lubElems));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean isCastValidImpl(Type toType) {
        for (Type type : this.lubElements()) {
            if (this.ts.isCastValid(type, toType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public LinkedList<Type> isImplicitCastValidChainImpl(Type toType) {
        for (Type type : this.lubElements()) {
            if (this.ts.isImplicitCastValid(type, toType)) continue;
            return null;
        }
        LinkedList<Type> chain = new LinkedList<Type>();
        chain.add(this);
        chain.add(toType);
        return chain;
    }

    @Override
    public boolean isSubtypeImpl(Type ancestor) {
        for (Type type : this.lubElements()) {
            if (this.ts.isSubtype(type, ancestor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRawClass() {
        return false;
    }

    @Override
    public EnumInstance enumConstantNamed(String name) {
        return null;
    }

    @Override
    public List<EnumInstance> enumConstants() {
        return Collections.emptyList();
    }

    @Override
    public String translateAsReceiver(Resolver resolver) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean inStaticContext() {
        return false;
    }

    @Override
    public void setFlags(Flags flags) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setContainer(ReferenceType container) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Job job() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassType outer() {
        return null;
    }

    @Override
    public String name() {
        return this.toString();
    }

    @Override
    public Package package_() {
        return null;
    }

    @Override
    public Flags flags() {
        return Flags.PUBLIC.set(Flags.FINAL);
    }

    public List<ConstructorInstance> constructors() {
        return Collections.emptyList();
    }

    public List<ClassType> memberClasses() {
        return Collections.emptyList();
    }

    @Override
    public List<? extends MethodInstance> methods() {
        return this.calculateLub().methods();
    }

    @Override
    public List<? extends FieldInstance> fields() {
        return this.calculateLub().fields();
    }

    @Override
    public List<? extends ReferenceType> interfaces() {
        return this.calculateLub().interfaces();
    }

    @Override
    public Set<? extends Type> superclasses() {
        ReferenceType lub = this.calculateLub();
        if (lub instanceof JL5ClassType) {
            JL5ClassType ct = (JL5ClassType)lub;
            return ct.superclasses();
        }
        return Collections.singleton(this.superType());
    }

    @Override
    public Type superType() {
        return this.calculateLub().superType();
    }

    @Override
    public AnnotationTypeElemInstance annotationElemNamed(String name) {
        return null;
    }

    @Override
    public List<AnnotationTypeElemInstance> annotationElems() {
        return Collections.emptyList();
    }

    @Override
    public Annotations annotations() {
        return ((JL5TypeSystem)this.typeSystem()).NoAnnotations();
    }
}

