/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types.inference;

import java.util.ArrayList;
import java.util.List;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5SubstClassType;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.WildCardType;
import polyglot.ext.jl5.types.inference.Constraint;
import polyglot.ext.jl5.types.inference.InferenceSolver;
import polyglot.types.NullType;
import polyglot.types.ReferenceType;

public class EqualConstraint
extends Constraint {
    public EqualConstraint(ReferenceType actual, ReferenceType formal, InferenceSolver solver) {
        super(actual, formal, solver);
    }

    @Override
    public List<Constraint> simplify() {
        ArrayList<Constraint> r;
        block5: {
            block6: {
                TypeVariable actual_tv;
                ReferenceType ub;
                block7: {
                    r = new ArrayList<Constraint>();
                    if (this.actual instanceof NullType) break block5;
                    if (!this.formal.isArray()) break block6;
                    if (!this.actual.isArray() || !this.actual.toArray().base().isReference()) break block7;
                    r.add(new EqualConstraint((ReferenceType)this.actual.toArray().base(), (ReferenceType)this.formal.toArray().base(), this.solver));
                    break block5;
                }
                if (!(this.actual instanceof TypeVariable) || !(ub = (actual_tv = (TypeVariable)this.actual).upperBound()).isArray() || !ub.toArray().base().isReference()) break block5;
                r.add(new EqualConstraint((ReferenceType)ub.toArray().base(), (ReferenceType)this.formal.toArray().base(), this.solver));
                break block5;
            }
            if (this.formal instanceof JL5SubstClassType && this.actual instanceof JL5SubstClassType) {
                JL5SubstClassType formal_pt = (JL5SubstClassType)this.formal;
                JL5SubstClassType actual_pt = (JL5SubstClassType)this.actual;
                if (formal_pt.base().equals(actual_pt.base())) {
                    JL5ParsedClassType g = formal_pt.base();
                    for (TypeVariable tv : g.typeVariables()) {
                        ReferenceType formal_targ = (ReferenceType)formal_pt.subst().substType(tv);
                        ReferenceType actual_targ = (ReferenceType)actual_pt.subst().substType(tv);
                        if (!(formal_targ instanceof WildCardType) && !(actual_targ instanceof WildCardType)) {
                            r.add(new EqualConstraint(actual_targ, formal_targ, this.solver));
                            continue;
                        }
                        if (!(formal_targ instanceof WildCardType) || !(actual_targ instanceof WildCardType)) continue;
                        WildCardType formal_targ_wc = (WildCardType)formal_targ;
                        WildCardType actual_targ_wc = (WildCardType)actual_targ;
                        if (formal_targ_wc.isExtendsConstraint() && actual_targ_wc.isExtendsConstraint()) {
                            r.add(new EqualConstraint(formal_targ_wc.upperBound(), actual_targ_wc.upperBound(), this.solver));
                            continue;
                        }
                        if (!formal_targ_wc.isSuperConstraint() || !actual_targ_wc.isSuperConstraint()) continue;
                        r.add(new EqualConstraint(formal_targ_wc.lowerBound(), actual_targ_wc.lowerBound(), this.solver));
                    }
                }
            }
        }
        return r;
    }

    @Override
    public boolean canSimplify() {
        return !this.solver.isTargetTypeVariable(this.formal);
    }

    public String toString() {
        return this.actual + " = " + this.formal;
    }
}

