/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import polyglot.ext.jl5.types.IntersectionType;
import polyglot.ext.jl5.types.JL5ClassType;
import polyglot.ext.jl5.types.JL5ConstructorInstance;
import polyglot.ext.jl5.types.JL5MethodInstance;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5ProcedureInstance;
import polyglot.ext.jl5.types.JL5Subst;
import polyglot.ext.jl5.types.JL5SubstClassType;
import polyglot.ext.jl5.types.JL5SubstClassType_c;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.RawClass;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.WildCardType;
import polyglot.ext.param.types.ParamTypeSystem;
import polyglot.ext.param.types.Subst_c;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.ReferenceType;
import polyglot.types.Type;
import polyglot.util.InternalCompilerError;
import polyglot.util.SerialVersionUID;

public class JL5Subst_c
extends Subst_c<TypeVariable, ReferenceType>
implements JL5Subst {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private LinkedList<TypeVariable> visitedTypeVars = new LinkedList();

    public JL5Subst_c(ParamTypeSystem<TypeVariable, ReferenceType> ts, Map<TypeVariable, ? extends ReferenceType> subst) {
        super(ts, subst);
    }

    @Override
    public Type substType(Type t) {
        if (t instanceof TypeVariable) {
            return this.substTypeVariable((TypeVariable)t);
        }
        if (t instanceof WildCardType) {
            return this.substWildCardTypeVariable((WildCardType)t);
        }
        if (t instanceof IntersectionType) {
            return this.substIntersectionType((IntersectionType)t);
        }
        return super.substType(t);
    }

    public ReferenceType substTypeVariable(TypeVariable t) {
        if (this.subst.containsKey(t)) {
            return (ReferenceType)this.subst.get(t);
        }
        if (this.visitedTypeVars.contains(t)) {
            return t;
        }
        for (TypeVariable k : this.subst.keySet()) {
            if (!k.equals(t)) continue;
            return (ReferenceType)this.subst.get(k);
        }
        this.visitedTypeVars.addLast(t);
        TypeVariable origT = t;
        t = t.upperBound((ReferenceType)this.substType(t.upperBound()));
        if (this.visitedTypeVars.removeLast() != origT) {
            throw new InternalCompilerError("Unexpected type variable was last on the list");
        }
        return t;
    }

    public Type substWildCardTypeVariable(WildCardType t) {
        WildCardType n = t;
        n = n.upperBound((ReferenceType)this.substType(t.upperBound()));
        n = n.lowerBound((ReferenceType)this.substType(t.lowerBound()));
        return n;
    }

    public Type substIntersectionType(IntersectionType t) {
        List<ReferenceType> s = this.substTypeList(t.bounds());
        t = (IntersectionType)t.copy();
        t.setBounds(s);
        return t;
    }

    @Override
    protected ReferenceType substSubstValue(ReferenceType value) {
        return (ReferenceType)this.substType(value);
    }

    @Override
    protected ClassType substClassTypeImpl(ClassType t) {
        if (!(t instanceof JL5ClassType)) {
            return t;
        }
        if (t instanceof RawClass) {
            return t;
        }
        if (t instanceof JL5SubstClassType) {
            throw new InternalCompilerError("Should have no JL5SubstClassTypes");
        }
        if (t instanceof JL5ParsedClassType) {
            JL5ParsedClassType pct = (JL5ParsedClassType)t;
            JL5TypeSystem ts = (JL5TypeSystem)this.ts;
            List<TypeVariable> typeVars = ts.classAndEnclosingTypeVariables(pct);
            boolean typeVarsRelevant = false;
            for (TypeVariable tv : typeVars) {
                if (!this.substitutions().containsKey(tv)) continue;
                typeVarsRelevant = true;
                break;
            }
            if (!typeVarsRelevant) {
                return pct;
            }
            return new JL5SubstClassType_c(ts, t.position(), pct, this);
        }
        throw new InternalCompilerError("Don't know how to handle class type " + t.getClass());
    }

    @Override
    public <T extends MethodInstance> T substMethod(T mi) {
        JL5MethodInstance mj = (JL5MethodInstance)super.substMethod(mi);
        if (mj.typeParams() != null && !mj.typeParams().isEmpty()) {
            ArrayList<TypeVariable> l = new ArrayList<TypeVariable>(mj.typeParams());
            l.removeAll(this.subst.keySet());
            mj.setTypeParams(l);
        }
        mj.setTypeParams(this.substTypeList(mj.typeParams()));
        JL5MethodInstance result = mj;
        return (T)result;
    }

    @Override
    public <T extends ConstructorInstance> T substConstructor(T ci) {
        JL5ConstructorInstance cj = (JL5ConstructorInstance)super.substConstructor(ci);
        if (cj.typeParams() != null && !cj.typeParams().isEmpty()) {
            ArrayList<TypeVariable> l = new ArrayList<TypeVariable>(cj.typeParams());
            l.removeAll(this.subst.keySet());
            cj.setTypeParams(l);
        }
        cj.setTypeParams(this.substTypeList(cj.typeParams()));
        JL5ConstructorInstance result = cj;
        return (T)result;
    }

    @Override
    protected ReferenceType substContainer(MemberInstance mi) {
        if (mi.flags().isStatic()) {
            return mi.container();
        }
        return super.substContainer(mi);
    }

    @Override
    public JL5ProcedureInstance substProcedure(JL5ProcedureInstance mi) {
        if (mi instanceof MethodInstance) {
            return (JL5ProcedureInstance)((Object)this.substMethod((MethodInstance)((Object)mi)));
        }
        return (JL5ProcedureInstance)((Object)this.substConstructor((ConstructorInstance)((Object)mi)));
    }
}

