/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.util.ArrayList;
import java.util.List;
import polyglot.types.ClassType;
import polyglot.types.ImportTable;
import polyglot.types.MemberInstance;
import polyglot.types.Named;
import polyglot.types.Package;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.util.StringUtil;

public class JL5ImportTable
extends ImportTable {
    protected ArrayList<String> singleStaticImports;
    protected ArrayList<String> staticOnDemandImports;
    public int id = counter++;
    private static int counter = 0;

    public JL5ImportTable(TypeSystem ts, Package pkg, String src) {
        super(ts, pkg, src);
        this.singleStaticImports = new ArrayList();
        this.staticOnDemandImports = new ArrayList();
    }

    public JL5ImportTable(TypeSystem ts, Package pkg) {
        this(ts, pkg, null);
    }

    public void addSingleStaticImport(String member, Position pos) {
        this.singleStaticImports.add(member);
    }

    public void addStaticOnDemandImport(String className, Position pos) {
        this.staticOnDemandImports.add(className);
    }

    public List<String> singleStaticImports() {
        return this.singleStaticImports;
    }

    public List<String> staticOnDemandImports() {
        return this.staticOnDemandImports;
    }

    @Override
    public Named find(String name) throws SemanticException {
        ClassType result = null;
        for (String next : this.singleStaticImports) {
            String className;
            Named nt;
            String id = StringUtil.getShortNameComponent(next);
            if (!name.equals(id) || !((nt = this.ts.forName(className = StringUtil.getPackageComponent(next))) instanceof Type)) continue;
            Type t = (Type)((Object)nt);
            try {
                result = this.ts.findMemberClass(t.toClass(), name);
            }
            catch (SemanticException e) {
                // empty catch block
            }
            if (result == null || !result.flags().isStatic()) continue;
            return result;
        }
        for (String next : this.staticOnDemandImports) {
            Named nt = this.ts.forName(next);
            if (!(nt instanceof Type)) continue;
            Type t = (Type)((Object)nt);
            try {
                result = this.ts.findMemberClass(t.toClass(), name);
            }
            catch (SemanticException e) {
                // empty catch block
            }
            if (result == null || !((ClassType)result).flags().isStatic()) continue;
            return result;
        }
        return super.find(name);
    }

    public List<ReferenceType> findTypesContainingMethodOrField(String name) throws SemanticException {
        ArrayList<ReferenceType> containingTypes = new ArrayList<ReferenceType>();
        for (String next : this.singleStaticImports) {
            ReferenceType t;
            String className;
            Named nt;
            String id = StringUtil.getShortNameComponent(next);
            if (!name.equals(id) || !((nt = this.ts.forName(className = StringUtil.getPackageComponent(next))) instanceof ReferenceType) || !JL5ImportTable.hasStatic((t = (ReferenceType)((Object)nt)).methodsNamed(name)) && !JL5ImportTable.isStatic(t.fieldNamed(name))) continue;
            containingTypes.add(t);
        }
        for (String next : this.staticOnDemandImports) {
            ReferenceType t;
            Named nt = this.ts.forName(next);
            if (!(nt instanceof ReferenceType) || !JL5ImportTable.hasStatic((t = (ReferenceType)((Object)nt)).methodsNamed(name)) && !JL5ImportTable.isStatic(t.fieldNamed(name))) continue;
            containingTypes.add(t);
        }
        return containingTypes;
    }

    private static boolean hasStatic(List<? extends MemberInstance> members) {
        for (MemberInstance memberInstance : members) {
            if (!JL5ImportTable.isStatic(memberInstance)) continue;
            return true;
        }
        return false;
    }

    private static boolean isStatic(MemberInstance mi) {
        return mi != null && mi.flags().isStatic();
    }
}

