/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import polyglot.ast.Lang;
import polyglot.ext.jl5.types.JL5Context;
import polyglot.ext.jl5.types.JL5ImportTable;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.Context_c;
import polyglot.types.FieldInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Named;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.StringUtil;

public class JL5Context_c
extends Context_c
implements JL5Context {
    protected Map<String, TypeVariable> typeVars;
    protected TypeVariable typeVariable;
    protected Type switchType;
    protected ClassType declaringClass;
    protected boolean ctorCall;
    public static final Context_c.Kind TYPE_VAR = new Context_c.Kind("type-var");
    public static final Context_c.Kind SWITCH = new Context_c.Kind("switch");
    public static final Context_c.Kind EXTENDS = new Context_c.Kind("extends");

    public JL5Context_c(Lang lang, TypeSystem ts) {
        super(lang, ts);
    }

    @Override
    public JL5TypeSystem typeSystem() {
        return (JL5TypeSystem)this.ts;
    }

    @Override
    public ClassType findFieldScope(String name) throws SemanticException {
        try {
            return super.findFieldScope(name);
        }
        catch (SemanticException e) {
            VarInstance vi = this.findVariableInStaticImport(name);
            if (vi instanceof FieldInstance) {
                return ((FieldInstance)vi).container().toClass();
            }
            throw e;
        }
    }

    @Override
    public VarInstance findVariableSilent(String name) {
        VarInstance vi = this.findVariableInThisScope(name);
        if (vi == null && this.outer != null) {
            vi = this.outer.findVariableSilent(name);
        }
        if (vi != null) {
            return vi;
        }
        return this.findVariableInStaticImport(name);
    }

    public VarInstance findVariableInStaticImport(String name) {
        block8: {
            try {
                if (this.importTable() == null) break block8;
                VarInstance vi = null;
                JL5ImportTable jit = (JL5ImportTable)this.importTable();
                for (String next : jit.singleStaticImports()) {
                    Named nt;
                    String id = StringUtil.getShortNameComponent(next);
                    if (!name.equals(id) || !((nt = this.ts.forName(StringUtil.getPackageComponent(next))) instanceof Type)) continue;
                    Type t = (Type)((Object)nt);
                    try {
                        vi = this.ts.findField(t.toClass(), name, t.toClass(), true);
                    }
                    catch (SemanticException e) {
                        // empty catch block
                    }
                    if (vi == null || !vi.flags().isStatic()) continue;
                    return vi;
                }
                if (vi != null) break block8;
                for (String next : jit.staticOnDemandImports()) {
                    Named nt = this.ts.forName(next);
                    if (!(nt instanceof Type)) continue;
                    Type t = (Type)((Object)nt);
                    try {
                        vi = this.ts.findField(t.toClass(), name, t.toClass(), true);
                    }
                    catch (SemanticException e) {
                        // empty catch block
                    }
                    if (vi == null || !vi.flags().isStatic()) continue;
                    return vi;
                }
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected Context_c push() {
        JL5Context_c c = (JL5Context_c)super.push();
        c.typeVars = null;
        return c;
    }

    @Override
    public Context pushCTORCall() {
        JL5Context_c v = (JL5Context_c)this.push();
        v.staticContext = true;
        v.ctorCall = true;
        return v;
    }

    @Override
    public JL5Context pushTypeVariable(TypeVariable iType) {
        JL5Context_c v = (JL5Context_c)this.push();
        v.typeVariable = iType;
        v.kind = TYPE_VAR;
        return v;
    }

    @Override
    public TypeVariable findTypeVariableInThisScope(String name) {
        if (this.typeVariable != null && this.typeVariable.name().equals(name)) {
            return this.typeVariable;
        }
        if (this.typeVars != null && this.typeVars.containsKey(name)) {
            return this.typeVars.get(name);
        }
        if (this.outer != null) {
            return ((JL5Context)this.outer).findTypeVariableInThisScope(name);
        }
        return null;
    }

    @Override
    public boolean inTypeVariable() {
        return this.kind == TYPE_VAR;
    }

    @Override
    public boolean inCTORCall() {
        return this.ctorCall;
    }

    @Override
    public String toString() {
        return super.toString() + "; type var: " + this.typeVariable + "; type vars: " + this.typeVars;
    }

    @Override
    public void addTypeVariable(TypeVariable type) {
        if (this.typeVars == null) {
            this.typeVars = new LinkedHashMap<String, TypeVariable>();
        }
        this.typeVars.put(type.name(), type);
    }

    @Override
    public Context pushSwitch(Type type) {
        JL5Context_c c = (JL5Context_c)this.push();
        c.switchType = type;
        c.kind = SWITCH;
        return c;
    }

    @Override
    public Context pushExtendsClause(ClassType declaringClass) {
        JL5Context_c c = (JL5Context_c)this.push();
        c.declaringClass = declaringClass;
        c.kind = EXTENDS;
        return c;
    }

    @Override
    public Type switchType() {
        return this.switchType;
    }

    @Override
    public MethodInstance findMethod(String name, List<? extends Type> argTypes) throws SemanticException {
        try {
            return super.findMethod(name, argTypes);
        }
        catch (SemanticException e) {
            JL5ImportTable it = (JL5ImportTable)this.importTable();
            if (it != null && this.currentClass() != null) {
                for (ReferenceType rt : it.findTypesContainingMethodOrField(name)) {
                    try {
                        return this.ts.findMethod(rt, name, argTypes, this.currentClass(), false);
                    }
                    catch (SemanticException f) {
                    }
                }
            }
            throw e;
        }
    }

    @Override
    public boolean inExtendsClause() {
        return this.kind == EXTENDS;
    }

    @Override
    public ClassType extendsClauseDeclaringClass() {
        return this.declaringClass;
    }
}

