/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import polyglot.ast.Case;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Switch;
import polyglot.ast.SwitchElement;
import polyglot.ext.jl5.ast.J5Lang;
import polyglot.ext.jl5.ast.JL5SwitchOps;
import polyglot.ext.jl5.ast.JL5TermExt;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.SerialVersionUID;
import polyglot.visit.TypeChecker;

public class JL5SwitchExt
extends JL5TermExt
implements JL5SwitchOps {
    private static final long serialVersionUID = SerialVersionUID.generate();

    @Override
    public Switch node() {
        return (Switch)super.node();
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Switch s = this.node();
        Expr expr = s.expr();
        Type type = expr.type();
        if (!((J5Lang)tc.lang()).isAcceptableSwitchType(s, expr.type())) {
            throw new SemanticException("Switch index must be of type char, byte, short, int, Character, Byte, Short, Integer, or an enum type.", s.position());
        }
        ArrayList<SwitchElement> newels = new ArrayList<SwitchElement>(s.elements().size());
        Type switchType = expr.type();
        for (SwitchElement el : s.elements()) {
            if (el instanceof Case) {
                Case c = (Case)el;
                c = ((J5Lang)tc.lang()).resolveCaseLabel(c, tc, switchType);
                Expr cExpr = c.expr();
                if (!(cExpr == null || ts.isImplicitCastValid(cExpr.type(), type) || ts.typeEquals(cExpr.type(), type) || ts.numericConversionValid(type, tc.lang().constantValue(cExpr, tc.lang())))) {
                    throw new SemanticException("Case constant \"" + cExpr + "\" is not assignable to " + type + ".", c.position());
                }
                el = c;
            }
            newels.add(el);
        }
        return s.elements(newels);
    }

    @Override
    public boolean isAcceptableSwitchType(Type type) {
        JL5TypeSystem ts = (JL5TypeSystem)type.typeSystem();
        if (ts.Char().equals(type) || ts.Byte().equals(type) || ts.Short().equals(type) || ts.Int().equals(type)) {
            return true;
        }
        if (ts.wrapperClassOfPrimitive(ts.Char()).equals(type) || ts.wrapperClassOfPrimitive(ts.Byte()).equals(type) || ts.wrapperClassOfPrimitive(ts.Short()).equals(type) || ts.wrapperClassOfPrimitive(ts.Int()).equals(type)) {
            return true;
        }
        return type.isClass() && JL5Flags.isEnum(type.toClass().flags());
    }
}

