/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import polyglot.ast.AmbReceiver;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.EnumConstant;
import polyglot.ext.jl5.ast.JL5ExprExt;
import polyglot.ext.jl5.ast.JL5NodeFactory;
import polyglot.ext.jl5.types.EnumInstance;
import polyglot.ext.jl5.visit.JL5Translator;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.SerialVersionUID;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class JL5FieldExt
extends JL5ExprExt {
    private static final long serialVersionUID = SerialVersionUID.generate();

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Field n = (Field)this.superLang().typeCheck(this.node(), tc);
        if (n.fieldInstance() instanceof EnumInstance && !(n instanceof EnumConstant)) {
            JL5NodeFactory nf = (JL5NodeFactory)tc.nodeFactory();
            Field ec = nf.EnumConstant(n.position(), n.target(), nf.Id(n.id().position(), n.name()));
            ec = (Field)ec.type(n.type());
            n = ec = ec.fieldInstance(n.fieldInstance());
        }
        return n;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        Field n = (Field)this.node();
        w.begin(0);
        if (!n.isTargetImplicit()) {
            if (n.target() instanceof Expr) {
                n.printSubExpr((Expr)n.target(), w, tr);
            } else if (n.target() instanceof TypeNode || n.target() instanceof AmbReceiver) {
                if (tr instanceof JL5Translator) {
                    JL5Translator jltr = (JL5Translator)tr;
                    jltr.printReceiver(n.target(), w);
                } else {
                    this.print(n.target(), w, tr);
                }
            }
            w.write(".");
            w.allowBreak(2, 3, "", 0);
        }
        tr.print(n, n.id(), w);
        w.end();
    }
}

