/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassDeclOps;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.ast.JL5AnnotatedElementExt;
import polyglot.ext.jl5.ast.JL5Ext;
import polyglot.ext.jl5.ast.ParamTypeNode;
import polyglot.ext.jl5.types.AnnotationTypeElemInstance;
import polyglot.ext.jl5.types.Annotations;
import polyglot.ext.jl5.types.JL5Context;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.visit.AnnotationChecker;
import polyglot.ext.jl5.visit.JL5Translator;
import polyglot.ext.param.types.MuPClass;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.Declaration;
import polyglot.types.Flags;
import polyglot.types.ParsedClassType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Copy;
import polyglot.util.ListUtil;
import polyglot.util.SerialVersionUID;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class JL5ClassDeclExt
extends JL5AnnotatedElementExt
implements ClassDeclOps {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected List<ParamTypeNode> paramTypes = new ArrayList<ParamTypeNode>();

    public JL5ClassDeclExt() {
        this(null, null);
    }

    public JL5ClassDeclExt(List<ParamTypeNode> paramTypes, List<AnnotationElem> annotations) {
        super(annotations);
        this.paramTypes = ListUtil.copy(paramTypes, true);
    }

    @Override
    public ClassDecl node() {
        return (ClassDecl)super.node();
    }

    public List<ParamTypeNode> paramTypes() {
        return this.paramTypes;
    }

    public Node paramTypes(List<ParamTypeNode> types) {
        return this.paramTypes(this.node(), types);
    }

    protected <N extends Node> N paramTypes(N n, List<ParamTypeNode> types) {
        JL5ClassDeclExt ext = (JL5ClassDeclExt)JL5Ext.ext(n);
        if (CollectionUtil.equals(ext.paramTypes, types)) {
            return n;
        }
        if (n == this.node) {
            n = Copy.Util.copy(n);
            ext = (JL5ClassDeclExt)JL5Ext.ext(n);
        }
        ext.paramTypes = ListUtil.copy(types, true);
        return n;
    }

    @Override
    public Node annotationCheck(AnnotationChecker annoCheck) throws SemanticException {
        super.annotationCheck(annoCheck);
        ClassDecl n = this.node();
        if (JL5Flags.isAnnotation(n.flags())) {
            JL5ParsedClassType ct = (JL5ParsedClassType)n.type();
            ClassType annot = annoCheck.typeSystem().Annotation();
            for (AnnotationTypeElemInstance ai : ct.annotationElems()) {
                Type aiType = ai.type();
                if (!aiType.isClass() || !aiType.toClass().interfaces().contains(annot)) continue;
                JL5ParsedClassType other = (JL5ParsedClassType)aiType;
                for (AnnotationTypeElemInstance aj : other.annotationElems()) {
                    if (!aj.type().equals(ct)) continue;
                    throw new SemanticException("cyclic annotation element type", aj.position());
                }
            }
        }
        return n;
    }

    @Override
    public void setAnnotations(Annotations annotations) {
        ClassDecl n = this.node();
        JL5ParsedClassType pct = (JL5ParsedClassType)n.type();
        pct.setAnnotations(annotations);
        pct.setAnnotationsResolved(true);
    }

    @Override
    protected Declaration declaration() {
        ClassDecl n = this.node();
        return n.type();
    }

    private Node reconstruct(Node n, List<ParamTypeNode> paramTypes) {
        n = this.paramTypes(n, paramTypes);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        List<ParamTypeNode> typeParams = this.visitList(this.paramTypes, v);
        Node n = super.visitChildren(v);
        return this.reconstruct(n, typeParams);
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        ClassDecl n = (ClassDecl)this.superLang().buildTypes(this.node(), tb);
        JL5TypeSystem ts = (JL5TypeSystem)tb.typeSystem();
        JL5ParsedClassType ct = (JL5ParsedClassType)n.type();
        MuPClass<TypeVariable, ReferenceType> pc = ts.mutablePClass(ct.position());
        ct.setPClass(pc);
        pc.clazz(ct);
        if (this.paramTypes != null && !this.paramTypes.isEmpty()) {
            ArrayList<TypeVariable> typeVars = new ArrayList<TypeVariable>(this.paramTypes.size());
            for (TypeNode typeNode : this.paramTypes) {
                TypeVariable tv = (TypeVariable)typeNode.type();
                typeVars.add(tv);
                tv.setDeclaringClass(ct);
            }
            ct.setTypeVariables(typeVars);
            pc.formals(new ArrayList<TypeVariable>(typeVars));
        }
        return n;
    }

    @Override
    public Context enterChildScope(Node child, Context c) {
        ClassDecl n = this.node();
        if (child == n.body()) {
            TypeSystem ts = c.typeSystem();
            c = c.pushClass(n.type(), ts.staticTarget(n.type()).toClass());
        } else {
            c = ((JL5Context)c).pushExtendsClause(n.type());
            c.addNamed(n.type());
        }
        for (TypeNode typeNode : this.paramTypes) {
            ((JL5Context)c).addTypeVariable((TypeVariable)typeNode.type());
        }
        return c.lang().enterScope(child, c);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        ClassDecl n = this.node();
        ParsedClassType type = n.type();
        JL5ClassDeclExt ext = (JL5ClassDeclExt)JL5Ext.ext(n);
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        Type superType = type.superType();
        if (superType != null && JL5Flags.isEnum(superType.toClass().flags())) {
            throw new SemanticException("Cannot extend enum type", n.position());
        }
        if (ts.equals(ts.Object(), type) && !ext.paramTypes.isEmpty()) {
            throw new SemanticException("Type: " + type + " cannot declare type variables.", n.position());
        }
        if (JL5Flags.isAnnotation(n.flags()) && n.flags().isPrivate()) {
            throw new SemanticException("Annotation types cannot have explicit private modifier", n.position());
        }
        ts.checkDuplicateAnnotations(ext.annotations);
        if (superType != null && ts.isSubtype(superType, ts.Throwable()) && !ext.paramTypes.isEmpty()) {
            throw new SemanticException("Cannot subclass java.lang.Throwable or any of its subtypes with a generic class", n.superClass().position());
        }
        for (int i = 0; i < ext.paramTypes.size(); ++i) {
            TypeNode typeNode = ext.paramTypes.get(i);
            for (int j = i + 1; j < ext.paramTypes.size(); ++j) {
                TypeNode tj = ext.paramTypes.get(j);
                if (!typeNode.name().equals(tj.name())) continue;
                throw new SemanticException("Duplicate type variable declaration.", tj.position());
            }
        }
        for (TypeNode typeNode : ext.paramTypes) {
            ts.checkCycles(typeNode.type().toReference());
        }
        return super.typeCheck(tc);
    }

    public void prettyPrintModifiers(CodeWriter w, PrettyPrinter tr) {
        ClassDecl n = this.node();
        Flags f = n.flags();
        if (f.isInterface()) {
            f = f.clearInterface().clearAbstract();
        }
        if (JL5Flags.isEnum(f)) {
            f = JL5Flags.clearEnum(f).clearStatic().clearAbstract();
        }
        if (JL5Flags.isAnnotation(f)) {
            f = JL5Flags.clearAnnotation(f);
        }
        w.write(f.translate());
        if (n.flags().isInterface()) {
            if (JL5Flags.isAnnotation(n.flags())) {
                w.write("@interface ");
            } else {
                w.write("interface ");
            }
        } else if (JL5Flags.isEnum(n.flags())) {
            w.write("enum ");
        } else {
            w.write("class ");
        }
    }

    public void prettyPrintName(CodeWriter w, PrettyPrinter tr) {
        ClassDecl n = this.node();
        w.write(n.id().id());
    }

    public void prettyPrintHeaderRest(CodeWriter w, PrettyPrinter tr) {
        ClassDecl n = this.node();
        if (n.superClass() != null && !JL5Flags.isEnum(n.flags()) && !JL5Flags.isAnnotation(n.flags())) {
            w.write(" extends ");
            this.print(n.superClass(), w, tr);
        }
        if (!n.interfaces().isEmpty() && !JL5Flags.isAnnotation(n.flags())) {
            if (n.flags().isInterface()) {
                w.write(" extends ");
            } else {
                w.write(" implements ");
            }
            Iterator<TypeNode> i = n.interfaces().iterator();
            while (i.hasNext()) {
                TypeNode tn = i.next();
                this.print(tn, w, tr);
                if (!i.hasNext()) continue;
                w.write(", ");
            }
        }
        w.write(" {");
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter pp) {
        this.superLang().prettyPrint((Node)this.node(), w, pp);
    }

    @Override
    public void prettyPrintHeader(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        super.prettyPrint(w, tr);
        w.end();
        this.prettyPrintModifiers(w, tr);
        this.prettyPrintName(w, tr);
        boolean printTypeVars = true;
        if (tr instanceof JL5Translator) {
            JL5Translator jl5tr = (JL5Translator)tr;
            boolean bl = printTypeVars = !jl5tr.removeJava5isms();
        }
        if (printTypeVars && !this.paramTypes.isEmpty()) {
            w.write("<");
            Iterator<ParamTypeNode> iter = this.paramTypes.iterator();
            while (iter.hasNext()) {
                TypeNode ptn = iter.next();
                tr.lang().prettyPrint((Node)ptn, w, tr);
                if (!iter.hasNext()) continue;
                w.write(", ");
            }
            w.write(">");
        }
        this.prettyPrintHeaderRest(w, tr);
    }

    @Override
    public void prettyPrintFooter(CodeWriter w, PrettyPrinter tr) {
        this.superLang().prettyPrintFooter(this.node(), w, tr);
    }

    @Override
    public Node addDefaultConstructor(TypeSystem ts, NodeFactory nf, ConstructorInstance defaultConstructorInstance) throws SemanticException {
        return this.superLang().addDefaultConstructor(this.node(), ts, nf, defaultConstructorInstance);
    }
}

