/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Node;
import polyglot.ext.jl5.ast.JL5TermExt;
import polyglot.ext.jl5.types.IntersectionType;
import polyglot.ext.jl5.types.JL5Context;
import polyglot.ext.jl5.types.JL5SubstClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.WildCardType;
import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.types.ArrayType;
import polyglot.types.ClassType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.SerialVersionUID;
import polyglot.visit.TypeChecker;

public class JL5CanonicalTypeNodeExt
extends JL5TermExt {
    private static final long serialVersionUID = SerialVersionUID.generate();

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Iterator<TypeVariable> i$;
        CanonicalTypeNode n = (CanonicalTypeNode)this.node();
        Type t = n.type();
        if (t instanceof JL5SubstClassType) {
            JL5SubstClassType st = (JL5SubstClassType)t;
            JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
            if (st.isInnerClass() && !st.base().typeVariables().isEmpty()) {
                for (TypeVariable tv : st.base().typeVariables()) {
                    if (st.subst().substitutions().keySet().contains(tv)) continue;
                    throw new SemanticException("\"Rare\" types are not allowed: cannot use raw class " + st.name() + " when the outer class " + st.outer() + " has instantiated type variables.", n.position());
                }
            }
            if (!st.base().typeVariables().isEmpty()) {
                JL5SubstClassType capCT = (JL5SubstClassType)ts.applyCaptureConversion(st, n.position());
                for (int i = 0; i < capCT.actuals().size(); ++i) {
                    TypeVariable ai = capCT.base().typeVariables().get(i);
                    Type xi = (Type)capCT.actuals().get(i);
                    if (!ai.upperBound().isCanonical()) {
                        Scheduler scheduler = tc.job().extensionInfo().scheduler();
                        Goal g = scheduler.SupertypesResolved(st.base());
                        throw new MissingDependencyException(g);
                    }
                    if (ts.isSubtype(xi, capCT.subst().substType(ai.upperBound()))) continue;
                    throw new SemanticException("Type argument " + st.actuals().get(i) + " is not a subtype of its declared bound " + ai.upperBound(), n.position());
                }
            }
        }
        if (tc.context().inStaticContext() && !((JL5Context)tc.context()).inCTORCall() && (i$ = this.findInstanceTypeVariables(t).iterator()).hasNext()) {
            TypeVariable tv = i$.next();
            throw new SemanticException("Type variable " + tv + " cannot be used in a static context", n.position());
        }
        ClassType currentClass = tc.context().currentClass();
        JL5Context jc = (JL5Context)tc.context();
        if (jc.inExtendsClause()) {
            currentClass = jc.extendsClauseDeclaringClass();
        }
        if (currentClass != null && currentClass.isNested() && !currentClass.isInnerClass()) {
            for (TypeVariable tv : this.findInstanceTypeVariables(t)) {
                if (tv.declaringClass().equals(currentClass)) continue;
                throw new SemanticException("Type variable " + tv + " of class " + tv.declaringClass() + " cannot be used in a nested class", n.position());
            }
        }
        return this.superLang().typeCheck(this.node(), tc);
    }

    private Set<TypeVariable> findInstanceTypeVariables(Type t) {
        LinkedHashSet<TypeVariable> s = new LinkedHashSet<TypeVariable>();
        this.findInstanceTypeVariables(t, s);
        return s;
    }

    private void findInstanceTypeVariables(Type t, Set<TypeVariable> tvs) {
        ReferenceType at;
        TypeVariable tv;
        if (t instanceof TypeVariable && (tv = (TypeVariable)t).declaredIn() == TypeVariable.TVarDecl.CLASS_TYPE_VARIABLE) {
            tvs.add(tv);
        }
        if (t instanceof ArrayType) {
            at = (ArrayType)t;
            this.findInstanceTypeVariables(at.base(), tvs);
        }
        if (t instanceof WildCardType) {
            at = (WildCardType)t;
            this.findInstanceTypeVariables(at.upperBound(), tvs);
        }
        if (t instanceof JL5SubstClassType) {
            JL5SubstClassType ct = (JL5SubstClassType)t;
            for (Type at2 : ct.actuals()) {
                this.findInstanceTypeVariables(at2, tvs);
            }
        }
        if (t instanceof IntersectionType) {
            IntersectionType it = (IntersectionType)t;
            for (Type at2 : it.bounds()) {
                this.findInstanceTypeVariables(at2, tvs);
            }
        }
        if (t.isClass() && t.toClass().isNested()) {
            this.findInstanceTypeVariables(t.toClass().outer(), tvs);
        }
    }
}

