/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import polyglot.ast.Binary;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Precedence;
import polyglot.ext.jl5.ast.JL5ExprExt;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.PrimitiveType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.TypeChecker;

public class JL5BinaryExt
extends JL5ExprExt {
    private static final long serialVersionUID = SerialVersionUID.generate();

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Binary b = (Binary)this.node();
        Binary.Operator op = b.operator();
        Expr left = b.left();
        Expr right = b.right();
        Type l = left.type();
        Type r = right.type();
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        if (!ts.isPrimitiveWrapper(l) && !ts.isPrimitiveWrapper(r)) {
            return this.superLang().typeCheck(this.node(), tc);
        }
        if (!l.isNull() && !r.isNull()) {
            l = ts.isPrimitiveWrapper(l) ? ts.primitiveTypeOfWrapper(l) : l;
            Type type = r = ts.isPrimitiveWrapper(r) ? ts.primitiveTypeOfWrapper(r) : r;
        }
        if (op == Binary.GT || op == Binary.LT || op == Binary.GE || op == Binary.LE) {
            if (!l.isNumeric()) {
                throw new SemanticException("The " + op + " operator must have numeric operands, not type " + l + ".", left.position());
            }
            if (!r.isNumeric()) {
                throw new SemanticException("The " + op + " operator must have numeric operands, not type " + r + ".", right.position());
            }
            return b.type(ts.Boolean());
        }
        if (op == Binary.EQ || op == Binary.NE) {
            if (!ts.isCastValid(l, r) && !ts.isCastValid(r, l)) {
                throw new SemanticException("The " + op + " operator must have operands of similar type.", b.position());
            }
            return b.type(ts.Boolean());
        }
        if (op == Binary.COND_OR || op == Binary.COND_AND) {
            if (!l.isBoolean()) {
                throw new SemanticException("The " + op + " operator must have boolean operands, not type " + l + ".", left.position());
            }
            if (!r.isBoolean()) {
                throw new SemanticException("The " + op + " operator must have boolean operands, not type " + r + ".", right.position());
            }
            return b.type(ts.Boolean());
        }
        if (op == Binary.ADD && (ts.isSubtype(l, ts.String()) || ts.isSubtype(r, ts.String()))) {
            if (!ts.canCoerceToString(r, tc.context())) {
                throw new SemanticException("Cannot coerce an expression of type " + r + " to a String.", right.position());
            }
            if (!ts.canCoerceToString(l, tc.context())) {
                throw new SemanticException("Cannot coerce an expression of type " + l + " to a String.", left.position());
            }
            return b.precedence(Precedence.STRING_ADD).type(ts.String());
        }
        if ((op == Binary.BIT_AND || op == Binary.BIT_OR || op == Binary.BIT_XOR) && l.isBoolean() && r.isBoolean()) {
            return b.type(ts.Boolean());
        }
        if (op == Binary.ADD) {
            if (!l.isNumeric()) {
                throw new SemanticException("The " + op + " operator must have numeric or String operands, not type " + l + ".", left.position());
            }
            if (!r.isNumeric()) {
                throw new SemanticException("The " + op + " operator must have numeric or String operands, not type " + r + ".", right.position());
            }
        }
        if (op == Binary.BIT_AND || op == Binary.BIT_OR || op == Binary.BIT_XOR) {
            if (!ts.isImplicitCastValid(l, ts.Long())) {
                throw new SemanticException("The " + op + " operator must have numeric or boolean operands, not type " + l + ".", left.position());
            }
            if (!ts.isImplicitCastValid(r, ts.Long())) {
                throw new SemanticException("The " + op + " operator must have numeric or boolean operands, not type " + r + ".", right.position());
            }
        }
        if (op == Binary.SUB || op == Binary.MUL || op == Binary.DIV || op == Binary.MOD) {
            if (!l.isNumeric()) {
                throw new SemanticException("The " + op + " operator must have numeric operands, not type " + l + ".", left.position());
            }
            if (!r.isNumeric()) {
                throw new SemanticException("The " + op + " operator must have numeric operands, not type " + r + ".", right.position());
            }
        }
        if (op == Binary.SHL || op == Binary.SHR || op == Binary.USHR) {
            if (!ts.isImplicitCastValid(l, ts.Long())) {
                throw new SemanticException("The " + op + " operator must have numeric operands, not type " + l + ".", left.position());
            }
            if (!ts.isImplicitCastValid(r, ts.Long())) {
                throw new SemanticException("The " + op + " operator must have numeric operands, not type " + r + ".", right.position());
            }
        }
        if (op == Binary.SHL || op == Binary.SHR || op == Binary.USHR) {
            return b.type(ts.promote(l));
        }
        return b.type(ts.promote(l, r));
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        Expr other;
        Binary b = (Binary)this.node();
        Binary.Operator op = b.operator();
        Expr left = b.left();
        Expr right = b.right();
        if (child == left) {
            other = right;
        } else if (child == right) {
            other = left;
        } else {
            return child.type();
        }
        JL5TypeSystem ts = (JL5TypeSystem)av.typeSystem();
        Type childType = child.type();
        Type otherType = other.type();
        if (!ts.isPrimitiveWrapper(childType) && !ts.isPrimitiveWrapper(otherType)) {
            return this.superLang().childExpectedType(this.node(), child, av);
        }
        Type childUnboxedType = ts.unboxingConversion(childType);
        Type otherUnboxedType = ts.unboxingConversion(otherType);
        try {
            if (op == Binary.EQ || op == Binary.NE) {
                if ((childType.isReference() || childType.isNull()) && (otherType.isReference() || otherType.isNull())) {
                    return ts.leastCommonAncestor(childType, otherType);
                }
                if (childUnboxedType.isBoolean() && otherUnboxedType.isBoolean()) {
                    return ts.Boolean();
                }
                if (childUnboxedType.isNumeric() && otherUnboxedType.isNumeric()) {
                    return ts.promote(childUnboxedType, otherUnboxedType);
                }
                if (childType.isImplicitCastValid(otherType)) {
                    return otherType;
                }
                return childType;
            }
            if (op == Binary.ADD && ts.typeEquals(b.type(), ts.String())) {
                return ts.String();
            }
            if (op == Binary.GT || op == Binary.LT || op == Binary.GE || op == Binary.LE) {
                if (childUnboxedType.isNumeric() && otherUnboxedType.isNumeric()) {
                    return ts.promote(childUnboxedType, otherUnboxedType);
                }
                return childType;
            }
            if (op == Binary.COND_OR || op == Binary.COND_AND) {
                return ts.Boolean();
            }
            if (op == Binary.BIT_AND || op == Binary.BIT_OR || op == Binary.BIT_XOR) {
                if (otherUnboxedType.isBoolean()) {
                    return ts.Boolean();
                }
                if (childUnboxedType.isNumeric() && otherUnboxedType.isNumeric()) {
                    return ts.promote(childUnboxedType, otherUnboxedType);
                }
                return childType;
            }
            if (op == Binary.ADD || op == Binary.SUB || op == Binary.MUL || op == Binary.DIV || op == Binary.MOD) {
                if (childUnboxedType.isNumeric() && otherUnboxedType.isNumeric()) {
                    PrimitiveType t = ts.promote(childUnboxedType, otherUnboxedType);
                    if (ts.isImplicitCastValid(t, av.toType()) || ts.String().equals(av.toType())) {
                        return t;
                    }
                    return av.toType();
                }
                return childType;
            }
            if (op == Binary.SHL || op == Binary.SHR || op == Binary.USHR) {
                if (childUnboxedType.isNumeric() && otherUnboxedType.isNumeric()) {
                    if (child == left) {
                        PrimitiveType t = ts.promote(childUnboxedType);
                        if (ts.isImplicitCastValid(t, av.toType()) || ts.String().equals(av.toType())) {
                            return t;
                        }
                        return av.toType();
                    }
                    return ts.promote(childUnboxedType);
                }
                return childType;
            }
            return childType;
        }
        catch (SemanticException e) {
            return childType;
        }
    }
}

