/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.ClassBody;
import polyglot.ast.Expr;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ext.jl5.ast.EnumConstantDecl;
import polyglot.ext.jl5.types.EnumInstance;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.translate.ExtensionRewriter;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.MemberInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.UnknownType;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Copy;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class EnumConstantDecl_c
extends Term_c
implements EnumConstantDecl {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected List<Expr> args;
    protected Id name;
    protected Flags flags;
    protected ClassBody body;
    protected EnumInstance enumInstance;
    protected ConstructorInstance constructorInstance;
    protected ParsedClassType type;
    protected long ordinal;

    public EnumConstantDecl_c(Position pos, Flags flags, Id name, List<Expr> args, ClassBody body) {
        super(pos);
        this.name = name;
        this.args = args;
        this.body = body;
        this.flags = flags;
    }

    @Override
    public long ordinal() {
        return this.ordinal;
    }

    @Override
    public EnumConstantDecl ordinal(long ordinal) {
        return this.ordinal(this, ordinal);
    }

    protected <N extends EnumConstantDecl_c> N ordinal(N n, long ordinal) {
        if (n.ordinal == ordinal) {
            return n;
        }
        if (n == this) {
            n = Copy.Util.copy(n);
        }
        n.ordinal = ordinal;
        return n;
    }

    @Override
    public List<Expr> args() {
        return this.args;
    }

    @Override
    public EnumConstantDecl args(List<Expr> args) {
        return this.args(this, args);
    }

    protected <N extends EnumConstantDecl_c> N args(N n, List<Expr> args) {
        if (CollectionUtil.equals(n.args, args)) {
            return n;
        }
        if (n == this) {
            n = Copy.Util.copy(n);
        }
        n.args = args;
        return n;
    }

    @Override
    public Id name() {
        return this.name;
    }

    @Override
    public EnumConstantDecl name(Id name) {
        return this.name(this, name);
    }

    protected <N extends EnumConstantDecl_c> N name(N n, Id name) {
        if (n.name == name) {
            return n;
        }
        if (n == this) {
            n = Copy.Util.copy(n);
        }
        n.name = name;
        return n;
    }

    @Override
    public ClassBody body() {
        return this.body;
    }

    @Override
    public EnumConstantDecl body(ClassBody body) {
        return this.body(this, body);
    }

    protected <N extends EnumConstantDecl_c> N body(N n, ClassBody body) {
        if (n.body == body) {
            return n;
        }
        if (n == this) {
            n = Copy.Util.copy(n);
        }
        n.body = body;
        return n;
    }

    @Override
    public ParsedClassType type() {
        return this.type;
    }

    @Override
    public EnumConstantDecl type(ParsedClassType pct) {
        return this.type(this, pct);
    }

    protected <N extends EnumConstantDecl_c> N type(N n, ParsedClassType type) {
        if (n.type == type) {
            return n;
        }
        if (n == this) {
            n = Copy.Util.copy(n);
        }
        n.type = type;
        return n;
    }

    @Override
    public MemberInstance memberInstance() {
        return this.enumInstance();
    }

    @Override
    public EnumInstance enumInstance() {
        return this.enumInstance;
    }

    @Override
    public EnumConstantDecl enumInstance(EnumInstance ei) {
        return this.enumInstance(this, ei);
    }

    protected <N extends EnumConstantDecl_c> N enumInstance(N n, EnumInstance ei) {
        if (n.enumInstance == ei) {
            return n;
        }
        if (n == this) {
            n = Copy.Util.copy(n);
        }
        n.enumInstance = ei;
        return n;
    }

    @Override
    public ConstructorInstance constructorInstance() {
        return this.constructorInstance;
    }

    @Override
    public EnumConstantDecl constructorInstance(ConstructorInstance ci) {
        return this.constructorInstance(this, ci);
    }

    protected <N extends EnumConstantDecl_c> N constructorInstance(N n, ConstructorInstance ci) {
        if (n.constructorInstance == ci) {
            return n;
        }
        if (n == this) {
            n = Copy.Util.copy(n);
        }
        n.constructorInstance = ci;
        return n;
    }

    @Override
    public Flags flags() {
        return this.flags;
    }

    protected EnumConstantDecl_c reconstruct(List<Expr> args, ClassBody body) {
        EnumConstantDecl_c n = this;
        n = this.args(n, args);
        n = this.body(n, body);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        List<Expr> args = this.visitList(this.args, v);
        ClassBody body = this.visitChild(this.body, v);
        return this.reconstruct(args, body);
    }

    @Override
    public Context enterChildScope(Node child, Context c) {
        if (child == this.body && this.type != null && this.body != null) {
            c = c.pushClass(this.type, this.type);
        }
        return super.enterChildScope(child, c);
    }

    @Override
    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        if (this.body() != null) {
            return tb.pushCode().pushAnonClass(this.position()).enterAnonClass();
        }
        return tb.pushCode();
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tb.typeSystem();
        ArrayList<UnknownType> l = new ArrayList<UnknownType>(this.args().size());
        for (int i = 0; i < this.args().size(); ++i) {
            l.add(ts.unknownType(this.position()));
        }
        ConstructorInstance ci = ts.constructorInstance(this.position(), ts.Object(), Flags.NONE, l, Collections.emptyList());
        EnumConstantDecl_c n = this;
        n = this.constructorInstance(n, ci);
        JL5ParsedClassType enumType = null;
        if (n.body() != null) {
            ParsedClassType type = tb.currentClass();
            n = this.type(n, type);
            type.setMembersAdded(true);
            enumType = (JL5ParsedClassType)tb.pop().currentClass();
            if (!type.supertypesResolved()) {
                type.superType(enumType);
                type.setSupertypesResolved(true);
            }
        } else {
            enumType = (JL5ParsedClassType)tb.currentClass();
            n = this.type(n, enumType);
        }
        if (enumType == null) {
            return n;
        }
        EnumInstance ei = ts.enumInstance(this.position(), enumType, Flags.NONE, this.name.id(), this.ordinal);
        enumType.addEnumConstant(ei);
        n = this.enumInstance(n, ei);
        return n;
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        Context c = tc.context();
        JL5ParsedClassType ct = (JL5ParsedClassType)c.currentClass();
        LinkedList<Type> argTypes = new LinkedList<Type>();
        for (Expr e : this.args) {
            argTypes.add(e.type());
        }
        ConstructorInstance ci = ts.findConstructor(ct, argTypes, c.currentClass(), false);
        EnumConstantDecl_c n = this.constructorInstance(this, ci);
        if (n.flags() != Flags.NONE) {
            throw new SemanticException("Cannot have modifier(s): " + this.flags + " on enum constant declaration", this.position());
        }
        if (this.body != null) {
            ts.checkClassConformance(this.type);
        }
        return n;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        Iterator<Expr> i = this.args().iterator();
        Iterator<? extends Type> j = this.constructorInstance().formalTypes().iterator();
        while (i.hasNext() && j.hasNext()) {
            Expr e = i.next();
            Type t = j.next();
            if (e != child) continue;
            return t;
        }
        return child.type();
    }

    @Override
    public Node extRewrite(ExtensionRewriter rw) throws SemanticException {
        EnumConstantDecl_c n = (EnumConstantDecl_c)super.extRewrite(rw);
        n = this.enumInstance(n, null);
        n = this.constructorInstance(n, null);
        n = this.type(n, null);
        return n;
    }

    @Override
    public String toString() {
        return this.name + "(" + this.args + ")" + (this.body != null ? "..." : "");
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write(this.name.id());
        if (this.args != null && !this.args.isEmpty()) {
            w.write(" ( ");
            Iterator<Expr> it = this.args.iterator();
            while (it.hasNext()) {
                Expr e = it.next();
                this.print(e, w, tr);
                if (!it.hasNext()) continue;
                w.write(", ");
                w.allowBreak(0);
            }
            w.write(" )");
        }
        if (this.body != null) {
            w.write(" {");
            this.print(this.body, w, tr);
            w.write("}");
        }
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        return succs;
    }

    @Override
    public Term firstChild() {
        return this;
    }
}

