/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.Iterator;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ext.jl5.ast.ElementValueArrayInit;
import polyglot.ext.jl5.ast.JL5NodeFactory;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class ElementValueArrayInit_c
extends Term_c
implements ElementValueArrayInit {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected List<Term> elements;
    protected Type type;

    public ElementValueArrayInit_c(Position pos, List<Term> elements) {
        super(pos);
        assert (elements != null);
        this.elements = ListUtil.copy(elements, true);
    }

    @Override
    public List<Term> elements() {
        return this.elements;
    }

    @Override
    public Node elements(List<Term> elements) {
        return this.elements(this, elements);
    }

    protected <N extends ElementValueArrayInit_c> N elements(N n, List<Term> elements) {
        N ext = n;
        if (CollectionUtil.equals(ext.elements, elements)) {
            return n;
        }
        if (n == this) {
            ext = n = Copy.Util.copy(n);
        }
        ext.elements = ListUtil.copy(elements, true);
        return n;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public Node type(Type type) {
        return this.type(this, type);
    }

    protected <N extends ElementValueArrayInit_c> N type(N n, Type type) {
        N ext = n;
        if (ext.type == type) {
            return n;
        }
        if (n == this) {
            ext = n = Copy.Util.copy(n);
        }
        ext.type = type;
        return n;
    }

    protected <N extends ElementValueArrayInit_c> N reconstruct(N n, List<Term> elements) {
        n = this.elements(n, elements);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        List<Term> elements = this.visitList(this.elements, v);
        return this.reconstruct(this, elements);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Type type = null;
        for (Term e : this.elements) {
            if (type == null) {
                type = ElementValueArrayInit_c.typeOf(e);
                continue;
            }
            type = ts.leastCommonAncestor(type, ElementValueArrayInit_c.typeOf(e));
        }
        if (type == null) {
            return this.type(ts.Null());
        }
        return this.type(this.arrayOf(ts, type));
    }

    private static Type typeOf(Term e) {
        if (e instanceof Expr) {
            return ((Expr)e).type();
        }
        if (e instanceof ElementValueArrayInit) {
            return ((ElementValueArrayInit)e).type();
        }
        return null;
    }

    protected Type arrayOf(TypeSystem ts, Type baseType) {
        return ts.arrayOf(baseType);
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (this.elements.isEmpty()) {
            return child.type();
        }
        Type t = av.toType();
        if (t == null) {
            t = this.type();
        }
        if (!t.isArray()) {
            throw new InternalCompilerError("Type of array initializer must be an array.", this.position());
        }
        t = t.toArray().base();
        for (Term e : this.elements) {
            if (e != child) continue;
            return t;
        }
        return child.type();
    }

    @Override
    public void typeCheckElements(TypeChecker tc, Type lhsType) throws SemanticException {
        TypeSystem ts = lhsType.typeSystem();
        if (!lhsType.isArray()) {
            throw new SemanticException("Cannot initialize " + lhsType + " with " + this.type() + ".", this.position());
        }
        Type t = lhsType.toArray().base();
        for (Term e : this.elements) {
            Type s = ElementValueArrayInit_c.typeOf(e);
            if (e instanceof ElementValueArrayInit) {
                ((ElementValueArrayInit)e).typeCheckElements(tc, t);
                continue;
            }
            if (ts.isImplicitCastValid(s, t) || ts.typeEquals(s, t) || ts.numericConversionValid(t, tc.lang().constantValue((Expr)e, tc.lang()))) continue;
            throw new SemanticException("Cannot assign " + s + " to " + t + ".", e.position());
        }
    }

    @Override
    public String toString() {
        return "{ ... }";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("{ ");
        Iterator<Term> i = this.elements.iterator();
        while (i.hasNext()) {
            Term e = i.next();
            this.print(e, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.write(" }");
    }

    @Override
    public Term firstChild() {
        return Term_c.listChild(this.elements, null);
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.visitCFGList(this.elements, this, 0);
        return succs;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return ((JL5NodeFactory)nf).ElementValueArrayInit(this.position(), this.elements);
    }
}

