/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5;

import polyglot.ast.NodeFactory;
import polyglot.ext.jl5.AnnotationsResolved;
import polyglot.ext.jl5.JL5Options;
import polyglot.ext.jl5.translate.JL5ToJLRewriter;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.visit.AnnotationChecker;
import polyglot.ext.jl5.visit.AutoBoxer;
import polyglot.ext.jl5.visit.JL5DefiniteAssignmentChecker;
import polyglot.ext.jl5.visit.JL5Translator;
import polyglot.ext.jl5.visit.RemoveAnnotations;
import polyglot.ext.jl5.visit.RemoveEnums;
import polyglot.ext.jl5.visit.RemoveExtendedFors;
import polyglot.ext.jl5.visit.RemoveStaticImports;
import polyglot.ext.jl5.visit.RemoveVarArgsFlags;
import polyglot.ext.jl5.visit.RemoveVarargVisitor;
import polyglot.ext.jl5.visit.SimplifyExpressionsForBoxing;
import polyglot.ext.jl5.visit.TVCaster;
import polyglot.ext.jl5.visit.TypeErasureProcDecls;
import polyglot.frontend.CyclicDependencyException;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.JLExtensionInfo;
import polyglot.frontend.JLScheduler;
import polyglot.frontend.Job;
import polyglot.frontend.OutputPass;
import polyglot.frontend.Pass;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.CodeGenerated;
import polyglot.frontend.goals.EmptyGoal;
import polyglot.frontend.goals.Goal;
import polyglot.frontend.goals.VisitorGoal;
import polyglot.main.Options;
import polyglot.types.ParsedClassType;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.visit.TypeClosure;

public class JL5Scheduler
extends JLScheduler {
    public JL5Scheduler(JLExtensionInfo extInfo) {
        super(extInfo);
    }

    public Goal AnnotationsResolved(ParsedClassType ct) {
        Goal g = AnnotationsResolved.create((Scheduler)this, ct);
        return this.internGoal(g);
    }

    public Goal AnnotationsResolved(Job job) {
        Goal g = AnnotationsResolved.create((Scheduler)this, job);
        return this.internGoal(g);
    }

    public Goal CastsInserted(Job job) {
        TypeSystem ts = this.extInfo.typeSystem();
        NodeFactory nf = this.extInfo.nodeFactory();
        VisitorGoal g = new VisitorGoal(job, new TVCaster(job, ts, nf));
        try {
            g.addPrerequisiteGoal(this.PreRemoveJava5isms(job), this);
            g.addPrerequisiteGoal(this.TypeChecked(job), this);
            g.addPrerequisiteGoal(this.AnnotationCheck(job), this);
            g.addPrerequisiteGoal(this.TypeClosure(job), this);
            g.addPrerequisiteGoal(this.AutoBoxing(job), this);
            g.addPrerequisiteGoal(this.RemoveExtendedFors(job), this);
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError(e);
        }
        return this.internGoal(g);
    }

    public Goal AutoBoxing(Job job) {
        JL5TypeSystem ts = (JL5TypeSystem)this.extInfo.typeSystem();
        NodeFactory nf = this.extInfo.nodeFactory();
        VisitorGoal g = new VisitorGoal(job, new AutoBoxer(job, ts, nf));
        try {
            g.addPrerequisiteGoal(this.PreRemoveJava5isms(job), this);
            g.addPrerequisiteGoal(this.RemoveVarArgs(job), this);
            g.addPrerequisiteGoal(this.RemoveExtendedFors(job), this);
            g.addPrerequisiteGoal(this.SimplifyExpressionsForBoxing(job), this);
            g.addPrerequisiteGoal(this.AnnotationCheck(job), this);
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError(e);
        }
        return this.internGoal(g);
    }

    public Goal TypeErasureProcDecls(Job job) {
        TypeSystem ts = this.extInfo.typeSystem();
        NodeFactory nf = this.extInfo.nodeFactory();
        VisitorGoal g = new VisitorGoal(job, new TypeErasureProcDecls(job, ts, nf));
        try {
            g.addPrerequisiteGoal(this.PreRemoveJava5isms(job), this);
            g.addPrerequisiteGoal(this.CastsInserted(job), this);
            g.addPrerequisiteGoal(this.AutoBoxing(job), this);
            g.addPrerequisiteGoal(this.RemoveExtendedFors(job), this);
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError(e);
        }
        return this.internGoal(g);
    }

    public Goal RemoveVarArgs(Job job) {
        TypeSystem ts = this.extInfo.typeSystem();
        NodeFactory nf = this.extInfo.nodeFactory();
        VisitorGoal g = new VisitorGoal(job, new RemoveVarargVisitor(job, ts, nf));
        try {
            g.addPrerequisiteGoal(this.PreRemoveJava5isms(job), this);
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError(e);
        }
        return this.internGoal(g);
    }

    public Goal SimplifyExpressionsForBoxing(Job job) {
        TypeSystem ts = this.extInfo.typeSystem();
        NodeFactory nf = this.extInfo.nodeFactory();
        VisitorGoal g = new VisitorGoal(job, new SimplifyExpressionsForBoxing(nf, ts));
        try {
            g.addPrerequisiteGoal(this.PreRemoveJava5isms(job), this);
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError(e);
        }
        return this.internGoal(g);
    }

    public Goal RemoveEnums(Job job) {
        TypeSystem ts = this.extInfo.typeSystem();
        NodeFactory nf = this.extInfo.nodeFactory();
        VisitorGoal g = new VisitorGoal(job, new RemoveEnums(job, ts, nf));
        try {
            g.addPrerequisiteGoal(this.PreRemoveJava5isms(job), this);
            g.addPrerequisiteGoal(this.RemoveStaticImports(job), this);
            g.addPrerequisiteGoal(this.RemoveVarArgs(job), this);
            g.addPrerequisiteGoal(this.AutoBoxing(job), this);
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError(e);
        }
        return this.internGoal(g);
    }

    public Goal RemoveVarArgsFlags(Job job) {
        TypeSystem ts = this.extInfo.typeSystem();
        NodeFactory nf = this.extInfo.nodeFactory();
        VisitorGoal g = new VisitorGoal(job, new RemoveVarArgsFlags(job, ts, nf));
        try {
            g.addPrerequisiteGoal(this.PreRemoveJava5isms(job), this);
            g.addPrerequisiteGoal(this.RemoveEnums(job), this);
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError(e);
        }
        return this.internGoal(g);
    }

    public Goal RemoveExtendedFors(Job job) {
        TypeSystem ts = this.extInfo.typeSystem();
        NodeFactory nf = this.extInfo.nodeFactory();
        VisitorGoal g = new VisitorGoal(job, new RemoveExtendedFors(job, ts, nf));
        try {
            g.addPrerequisiteGoal(this.PreRemoveJava5isms(job), this);
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError(e);
        }
        return this.internGoal(g);
    }

    public Goal RemoveStaticImports(Job job) {
        TypeSystem ts = this.extInfo.typeSystem();
        NodeFactory nf = this.extInfo.nodeFactory();
        VisitorGoal g = new VisitorGoal(job, new RemoveStaticImports(job, ts, nf));
        try {
            g.addPrerequisiteGoal(this.PreRemoveJava5isms(job), this);
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError(e);
        }
        return this.internGoal(g);
    }

    public Goal RemoveAnnotations(Job job) {
        TypeSystem ts = this.extInfo.typeSystem();
        NodeFactory nf = this.extInfo.nodeFactory();
        VisitorGoal g = new VisitorGoal(job, new RemoveAnnotations(job, ts, nf));
        try {
            g.addPrerequisiteGoal(this.PreRemoveJava5isms(job), this);
            g.addPrerequisiteGoal(this.RemoveStaticImports(job), this);
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError(e);
        }
        return this.internGoal(g);
    }

    public Goal PreRemoveJava5isms(Job job) {
        EmptyGoal g = new EmptyGoal(job, "PreRemoveJava5isms");
        try {
            g.addPrerequisiteGoal(this.TypeChecked(job), this);
            g.addPrerequisiteGoal(this.AnnotationCheck(job), this);
            g.addPrerequisiteGoal(this.Serialized(job), this);
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError(e);
        }
        return this.internGoal(g);
    }

    public Goal RemoveJava5isms(Job job) {
        Options opts = this.extInfo.getOptions();
        boolean typecheckResult = !(opts instanceof JL5Options) || !((JL5Options)opts).skip524checks;
        EmptyGoal g = typecheckResult ? this.internGoal(new VisitorGoal(job, new JL5ToJLRewriter(job, this.extInfo, this.extInfo.outputExtensionInfo()))) : new EmptyGoal(job, "RemoveJava5isms");
        try {
            g.addPrerequisiteGoal(this.PreRemoveJava5isms(job), this);
            g.addPrerequisiteGoal(this.CastsInserted(job), this);
            g.addPrerequisiteGoal(this.TypeErasureProcDecls(job), this);
            g.addPrerequisiteGoal(this.RemoveVarArgs(job), this);
            g.addPrerequisiteGoal(this.AutoBoxing(job), this);
            g.addPrerequisiteGoal(this.RemoveEnums(job), this);
            g.addPrerequisiteGoal(this.RemoveVarArgsFlags(job), this);
            g.addPrerequisiteGoal(this.RemoveExtendedFors(job), this);
            g.addPrerequisiteGoal(this.RemoveStaticImports(job), this);
            g.addPrerequisiteGoal(this.RemoveAnnotations(job), this);
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError(e);
        }
        return this.internGoal(g);
    }

    public Goal AnnotationCheck(Job job) {
        TypeSystem ts = this.extInfo.typeSystem();
        NodeFactory nf = this.extInfo.nodeFactory();
        VisitorGoal g = new VisitorGoal(job, new AnnotationChecker(job, ts, nf));
        try {
            g.addPrerequisiteGoal(this.TypeChecked(job), this);
            g.addPrerequisiteGoal(this.AnnotationsResolved(job), this);
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError(e);
        }
        return this.internGoal(g);
    }

    public Goal TypeClosure(Job job) {
        Goal g = this.internGoal(new VisitorGoal(job, new TypeClosure(this.extInfo.nodeFactory().lang())));
        try {
            g.addPrerequisiteGoal(this.TypeChecked(job), this);
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError(e);
        }
        return this.internGoal(g);
    }

    @Override
    public Goal CodeGenerated(Job job) {
        Options opts = this.extInfo.getOptions();
        if (opts instanceof JL5Options && ((JL5Options)opts).removeJava5isms) {
            Goal g = ((JL5Options)opts).skip524checks ? JL5CodeGenerated.create(this, job) : new EmptyGoal(job, "CodeGenerated");
            try {
                g.addPrerequisiteGoal(this.RemoveJava5isms(job), this);
            }
            catch (CyclicDependencyException e) {
                throw new InternalCompilerError(e);
            }
            return g;
        }
        return JL5CodeGenerated.create(this, job);
    }

    @Override
    public Goal Serialized(Job job) {
        Goal g = super.Serialized(job);
        try {
            g.addPrerequisiteGoal(this.AnnotationCheck(job), this);
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError(e);
        }
        return this.internGoal(g);
    }

    @Override
    public boolean runToCompletion() {
        boolean complete = super.runToCompletion();
        Options opts = this.extInfo.getOptions();
        if (complete && ((JL5Options)opts).removeJava5isms) {
            ExtensionInfo outExtInfo = this.extInfo.outputExtensionInfo();
            for (Job job : outExtInfo.scheduler().jobs()) {
                Job newJob = outExtInfo.scheduler().addJob(job.source(), job.ast());
                outExtInfo.scheduler().addGoal(outExtInfo.getCompileGoal(newJob));
            }
            this.cleanup();
            return outExtInfo.scheduler().runToCompletion();
        }
        return complete;
    }

    protected void cleanup() {
        this.extInfo.cleanup();
        this.inWorklist.clear();
        this.worklist.clear();
        this.jobs.clear();
        this.goals.clear();
        this.runCount.clear();
    }

    @Override
    public Goal InitializationsChecked(Job job) {
        TypeSystem ts = this.extInfo.typeSystem();
        NodeFactory nf = this.extInfo.nodeFactory();
        VisitorGoal g = new VisitorGoal(job, new JL5DefiniteAssignmentChecker(job, ts, nf));
        try {
            g.addPrerequisiteGoal(this.ReachabilityChecked(job), this);
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError(e);
        }
        return this.internGoal(g);
    }

    private static class JL5CodeGenerated
    extends CodeGenerated {
        public static Goal create(Scheduler scheduler, Job job) {
            return scheduler.internGoal(new JL5CodeGenerated(job));
        }

        protected JL5CodeGenerated(Job job) {
            super(job);
        }

        @Override
        public Pass createPass(ExtensionInfo extInfo) {
            TypeSystem ts = extInfo.typeSystem();
            NodeFactory nf = extInfo.nodeFactory();
            return new OutputPass(this, new JL5Translator(this.job(), ts, nf, extInfo.targetFactory()));
        }
    }
}

