/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5;

import java.util.ArrayList;
import java.util.Collection;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.visit.ResolveAnnotationsVisitor;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Job;
import polyglot.frontend.Pass;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.ClassTypeGoal;
import polyglot.frontend.goals.Goal;
import polyglot.frontend.goals.VisitorGoal;
import polyglot.frontend.passes.ClassFilePass;
import polyglot.types.ClassType;
import polyglot.types.ParsedClassType;

public class AnnotationsResolved
extends VisitorGoal {
    public static Goal create(Scheduler scheduler, ParsedClassType ct) {
        if (ct.job() != null) {
            return AnnotationsResolved.create(scheduler, ct.job());
        }
        return scheduler.internGoal(new AnnotationsResolvedCT(ct));
    }

    public static Goal create(Scheduler scheduler, Job job) {
        return scheduler.internGoal(new AnnotationsResolved(job));
    }

    protected AnnotationsResolved(Job job) {
        super(job, new ResolveAnnotationsVisitor(job));
    }

    @Override
    public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
        ArrayList<Goal> l = new ArrayList<Goal>();
        l.add(scheduler.Disambiguated(this.job));
        l.addAll(super.prerequisiteGoals(scheduler));
        return l;
    }

    static class ResolveAnnotationsForClass
    extends ClassFilePass {
        protected Scheduler scheduler;
        protected AnnotationsResolvedCT goal;

        public ResolveAnnotationsForClass(Scheduler scheduler, AnnotationsResolvedCT goal) {
            super(goal);
            this.scheduler = scheduler;
            this.goal = goal;
        }

        @Override
        public boolean run() {
            JL5ParsedClassType ct = (JL5ParsedClassType)this.goal.type();
            ct.annotations();
            ct.setAnnotationsResolved(true);
            return true;
        }
    }

    static class AnnotationsResolvedCT
    extends ClassTypeGoal {
        protected AnnotationsResolvedCT(ParsedClassType ct) {
            super(ct);
        }

        @Override
        public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
            ArrayList<Goal> l = new ArrayList<Goal>();
            l.add(scheduler.SignaturesResolved(this.ct));
            l.addAll(super.prerequisiteGoals(scheduler));
            return l;
        }

        @Override
        public Pass createPass(ExtensionInfo extInfo) {
            return new ResolveAnnotationsForClass(extInfo.scheduler(), this);
        }

        protected boolean isGlobal(ClassType ct) {
            return ct.isTopLevel() || ct.isMember() && this.isGlobal((ClassType)ct.container());
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof AnnotationsResolvedCT && super.equals(o);
        }
    }
}

