/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Ext;
import polyglot.ast.IntLit;
import polyglot.ast.Lang;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.Term;
import polyglot.ast.Unary;
import polyglot.ast.Variable;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Unary_c
extends Expr_c
implements Unary {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Unary.Operator op;
    protected Expr expr;

    public Unary_c(Position pos, Unary.Operator op, Expr expr) {
        this(pos, op, expr, null);
    }

    public Unary_c(Position pos, Unary.Operator op, Expr expr, Ext ext) {
        super(pos, ext);
        assert (op != null && expr != null);
        this.op = op;
        this.expr = expr;
    }

    @Override
    public Precedence precedence() {
        return Precedence.UNARY;
    }

    @Override
    public Expr expr() {
        return this.expr;
    }

    @Override
    public Unary expr(Expr expr) {
        return this.expr(this, expr);
    }

    protected <N extends Unary_c> N expr(N n, Expr expr) {
        if (n.expr == expr) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.expr = expr;
        return n;
    }

    @Override
    public Unary.Operator operator() {
        return this.op;
    }

    @Override
    public Unary operator(Unary.Operator op) {
        return this.operator(this, op);
    }

    protected <N extends Unary_c> N operator(N n, Unary.Operator op) {
        if (n.op == op) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.op = op;
        return n;
    }

    protected <N extends Unary_c> N reconstruct(N n, Expr expr) {
        n = this.expr(n, expr);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr expr = this.visitChild(this.expr, v);
        return this.reconstruct(this, expr);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (this.op == POST_INC || this.op == POST_DEC || this.op == PRE_INC || this.op == PRE_DEC) {
            if (!this.expr.type().isNumeric()) {
                throw new SemanticException("Operand of " + this.op + " operator must be numeric.", this.expr.position());
            }
            if (!(this.expr instanceof Variable)) {
                throw new SemanticException("Operand of " + this.op + " operator must be a variable.", this.expr.position());
            }
            if (((Variable)this.expr).flags().isFinal()) {
                throw new SemanticException("Operand of " + this.op + " operator must be a non-final variable.", this.expr.position());
            }
            return this.type(this.expr.type());
        }
        if (this.op == BIT_NOT) {
            if (!ts.isImplicitCastValid(this.expr.type(), ts.Long())) {
                throw new SemanticException("Operand of " + this.op + " operator must be numeric.", this.expr.position());
            }
            return this.type(ts.promote(this.expr.type()));
        }
        if (this.op == NEG || this.op == POS) {
            if (!this.expr.type().isNumeric()) {
                throw new SemanticException("Operand of " + this.op + " operator must be numeric.", this.expr.position());
            }
            return this.type(ts.promote(this.expr.type()));
        }
        if (this.op == NOT) {
            if (!this.expr.type().isBoolean()) {
                throw new SemanticException("Operand of " + this.op + " operator must be boolean.", this.expr.position());
            }
            return this.type(this.expr.type());
        }
        return this;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        try {
            if (child == this.expr) {
                if (this.op == POST_INC || this.op == POST_DEC || this.op == PRE_INC || this.op == PRE_DEC) {
                    if (ts.isImplicitCastValid(child.type(), av.toType())) {
                        return ts.promote(child.type());
                    }
                    return av.toType();
                }
                if (this.op == NEG || this.op == POS) {
                    if (ts.isImplicitCastValid(child.type(), av.toType())) {
                        return ts.promote(child.type());
                    }
                    return av.toType();
                }
                if (this.op == BIT_NOT) {
                    if (ts.isImplicitCastValid(child.type(), av.toType())) {
                        return ts.promote(child.type());
                    }
                    return av.toType();
                }
                if (this.op == NOT) {
                    return ts.Boolean();
                }
            }
        }
        catch (SemanticException e) {
            // empty catch block
        }
        return child.type();
    }

    @Override
    public String toString() {
        if (this.op == NEG && this.expr instanceof IntLit && ((IntLit)this.expr).boundary()) {
            return this.op.toString() + ((IntLit)this.expr).positiveToString();
        }
        if (this.op.isPrefix()) {
            return this.op.toString() + this.expr.toString();
        }
        return this.expr.toString() + this.op.toString();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.op == NEG && this.expr instanceof IntLit && ((IntLit)this.expr).boundary()) {
            w.write(this.op.toString());
            w.write(((IntLit)this.expr).positiveToString());
        } else if (this.op.isPrefix()) {
            w.write(this.op.toString());
            this.printSubExpr(this.expr, false, w, tr);
        } else {
            this.printSubExpr(this.expr, false, w, tr);
            w.write(this.op.toString());
        }
    }

    @Override
    public Term firstChild() {
        return this.expr;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        if (this.expr.type().isBoolean()) {
            v.visitCFG(this.expr, FlowGraph.EDGE_KEY_TRUE, this, 0, FlowGraph.EDGE_KEY_FALSE, this, 0);
        } else {
            v.visitCFG(this.expr, this, 0);
        }
        return succs;
    }

    @Override
    public boolean constantValueSet(Lang lang) {
        return lang.constantValueSet(this.expr, lang);
    }

    @Override
    public boolean isConstant(Lang lang) {
        if (this.op == POST_INC || this.op == POST_DEC || this.op == PRE_INC || this.op == PRE_DEC) {
            return false;
        }
        return lang.isConstant(this.expr, lang);
    }

    @Override
    public Object constantValue(Lang lang) {
        int vv;
        if (!lang.isConstant(this, lang)) {
            return null;
        }
        Object v = lang.constantValue(this.expr, lang);
        if (v instanceof Boolean) {
            vv = ((Boolean)v).booleanValue();
            if (this.op == NOT) {
                return vv == 0;
            }
        }
        if (v instanceof Double) {
            double vv2 = (Double)v;
            if (this.op == POS) {
                return new Double(vv2);
            }
            if (this.op == NEG) {
                return new Double(-vv2);
            }
        }
        if (v instanceof Float) {
            float vv3 = ((Float)v).floatValue();
            if (this.op == POS) {
                return new Float(vv3);
            }
            if (this.op == NEG) {
                return new Float(-vv3);
            }
        }
        if (v instanceof Long) {
            long vv4 = (Long)v;
            if (this.op == BIT_NOT) {
                return new Long(vv4 ^ 0xFFFFFFFFFFFFFFFFL);
            }
            if (this.op == POS) {
                return new Long(vv4);
            }
            if (this.op == NEG) {
                return new Long(-vv4);
            }
        }
        if (v instanceof Integer) {
            vv = (Integer)v;
            if (this.op == BIT_NOT) {
                return new Integer(~vv);
            }
            if (this.op == POS) {
                return new Integer(vv);
            }
            if (this.op == NEG) {
                return new Integer(-vv);
            }
        }
        if (v instanceof Character) {
            vv = ((Character)v).charValue();
            if (this.op == BIT_NOT) {
                return new Integer(~vv);
            }
            if (this.op == POS) {
                return new Integer(vv);
            }
            if (this.op == NEG) {
                return new Integer(-vv);
            }
        }
        if (v instanceof Short) {
            vv = ((Short)v).shortValue();
            if (this.op == BIT_NOT) {
                return new Integer(~vv);
            }
            if (this.op == POS) {
                return new Integer(vv);
            }
            if (this.op == NEG) {
                return new Integer(-vv);
            }
        }
        if (v instanceof Byte) {
            vv = ((Byte)v).byteValue();
            if (this.op == BIT_NOT) {
                return new Integer(~vv);
            }
            if (this.op == POS) {
                return new Integer(vv);
            }
            if (this.op == NEG) {
                return new Integer(-vv);
            }
        }
        return null;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Unary(this.position, this.op, this.expr);
    }
}

