/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Case;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt_c;
import polyglot.ast.Switch;
import polyglot.ast.SwitchElement;
import polyglot.ast.Term;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ConstantChecker;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Switch_c
extends Stmt_c
implements Switch {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Expr expr;
    protected List<SwitchElement> elements;

    public Switch_c(Position pos, Expr expr, List<SwitchElement> elements) {
        this(pos, expr, elements, null);
    }

    public Switch_c(Position pos, Expr expr, List<SwitchElement> elements, Ext ext) {
        super(pos, ext);
        assert (expr != null && elements != null);
        this.expr = expr;
        this.elements = ListUtil.copy(elements, true);
    }

    @Override
    public Expr expr() {
        return this.expr;
    }

    @Override
    public Switch expr(Expr expr) {
        return this.expr(this, expr);
    }

    protected <N extends Switch_c> N expr(N n, Expr expr) {
        if (n.expr == expr) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.expr = expr;
        return n;
    }

    @Override
    public List<SwitchElement> elements() {
        return this.elements;
    }

    @Override
    public Switch elements(List<SwitchElement> elements) {
        return this.elements(this, elements);
    }

    protected <N extends Switch_c> N elements(N n, List<SwitchElement> elements) {
        if (CollectionUtil.equals(n.elements, elements)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.elements = ListUtil.copy(elements, true);
        return n;
    }

    protected <N extends Switch_c> N reconstruct(N n, Expr expr, List<SwitchElement> elements) {
        n = this.expr(n, expr);
        n = this.elements(n, elements);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr expr = this.visitChild(this.expr, v);
        List<SwitchElement> elements = this.visitList(this.elements, v);
        return this.reconstruct(this, expr, elements);
    }

    @Override
    public Context enterScope(Context c) {
        return c.pushBlock();
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Type type;
        TypeSystem ts = tc.typeSystem();
        if (!ts.isImplicitCastValid(type = this.expr.type(), ts.Int())) {
            throw new SemanticException("Switch index must be an integer.", this.position());
        }
        for (SwitchElement se : this.elements) {
            Case c;
            Expr cExpr;
            if (!(se instanceof Case) || (cExpr = (c = (Case)se).expr()) == null || ts.isImplicitCastValid(cExpr.type(), type) || ts.typeEquals(cExpr.type(), type) || ts.numericConversionValid(type, tc.lang().constantValue(cExpr, tc.lang()))) continue;
            throw new SemanticException("Case constant \"" + cExpr + "\" is not assignable to " + type + ".", c.position());
        }
        return this;
    }

    @Override
    public Node checkConstants(ConstantChecker cc) throws SemanticException {
        LinkedHashSet<String> labels = new LinkedHashSet<String>();
        for (SwitchElement s : this.elements) {
            String str;
            Object key;
            if (!(s instanceof Case)) continue;
            Case c = (Case)s;
            Expr expr = c.expr();
            if (c.isDefault()) {
                key = "default";
                str = "default";
            } else {
                if (!cc.lang().constantValueSet(expr, cc.lang())) {
                    return this;
                }
                if (!cc.lang().isConstant(expr, cc.lang())) continue;
                key = new Long(c.value());
                str = expr.toString() + " (" + c.value() + ")";
            }
            if (labels.contains(key)) {
                throw new SemanticException("Duplicate case label: " + str + ".", c.position());
            }
            labels.add((String)key);
        }
        return this;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.expr) {
            return ts.Int();
        }
        return child.type();
    }

    @Override
    public String toString() {
        return "switch (" + this.expr + ") { ... }";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("switch (");
        this.printBlock(this.expr, w, tr);
        w.write(") {");
        w.unifiedBreak(4);
        w.begin(0);
        boolean lastWasCase = false;
        boolean first = true;
        for (SwitchElement s : this.elements) {
            if (s instanceof Case) {
                if (lastWasCase) {
                    w.unifiedBreak(0);
                } else if (!first) {
                    w.unifiedBreak(0);
                }
                this.printBlock(s, w, tr);
                lastWasCase = true;
            } else {
                w.unifiedBreak(4);
                this.print(s, w, tr);
                lastWasCase = false;
            }
            first = false;
        }
        w.end();
        w.unifiedBreak(0);
        w.write("}");
    }

    @Override
    public Term firstChild() {
        return this.expr;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        LinkedList<Term> cases = new LinkedList<Term>();
        LinkedList<Integer> entry = new LinkedList<Integer>();
        boolean hasDefault = false;
        for (SwitchElement s : this.elements) {
            if (!(s instanceof Case)) continue;
            cases.add(s);
            entry.add(new Integer(1));
            if (((Case)s).expr() != null) continue;
            hasDefault = true;
        }
        if (!hasDefault) {
            cases.add(this);
            entry.add(new Integer(0));
        }
        v.visitCFG((Term)this.expr, FlowGraph.EDGE_KEY_OTHER, cases, entry);
        v.push(this).visitCFGList(this.elements, this, 0);
        return succs;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Switch(this.position, this.expr, this.elements);
    }
}

