/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Ambiguous;
import polyglot.ast.ClassBody;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Ext;
import polyglot.ast.JLang;
import polyglot.ast.New;
import polyglot.ast.NewOps;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.translate.ExtensionRewriter;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.ParsedClassType;
import polyglot.types.ProcedureInstance;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.UnknownType;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.BodyDisambiguator;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ConstantChecker;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.PruningVisitor;
import polyglot.visit.SignatureDisambiguator;
import polyglot.visit.SupertypeDisambiguator;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class New_c
extends Expr_c
implements New,
NewOps {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Expr qualifier;
    protected TypeNode objectType;
    protected List<Expr> arguments;
    protected ClassBody body;
    protected ConstructorInstance ci;
    protected ParsedClassType anonType;
    protected boolean qualifierImplicit;

    public New_c(Position pos, Expr qualifier, TypeNode tn, List<Expr> arguments, ClassBody body) {
        this(pos, qualifier, tn, arguments, body, null);
    }

    public New_c(Position pos, Expr qualifier, TypeNode tn, List<Expr> arguments, ClassBody body, Ext ext) {
        super(pos, ext);
        assert (tn != null && arguments != null);
        this.qualifier = qualifier;
        this.qualifierImplicit = qualifier == null;
        this.objectType = tn;
        this.arguments = ListUtil.copy(arguments, true);
        this.body = body;
    }

    @Override
    public Expr qualifier() {
        return this.qualifier;
    }

    @Override
    public New qualifier(Expr qualifier) {
        return this.qualifier(this, qualifier);
    }

    protected <N extends New_c> N qualifier(N n, Expr qualifier) {
        if (n.qualifier == qualifier) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.qualifier = qualifier;
        return n;
    }

    @Override
    public boolean isQualifierImplicit() {
        return this.qualifierImplicit;
    }

    @Override
    public New qualifierImplicit(boolean implicit) {
        return this.qualifierImplicit(this, implicit);
    }

    protected <N extends New_c> N qualifierImplicit(N n, boolean implicit) {
        if (n.qualifierImplicit == implicit) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.qualifierImplicit = implicit;
        return n;
    }

    @Override
    public TypeNode objectType() {
        return this.objectType;
    }

    @Override
    public New objectType(TypeNode objectType) {
        return this.objectType(this, objectType);
    }

    protected <N extends New_c> N objectType(N n, TypeNode objectType) {
        if (n.objectType == objectType) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.objectType = objectType;
        return n;
    }

    @Override
    public ParsedClassType anonType() {
        return this.anonType;
    }

    @Override
    public New anonType(ParsedClassType anonType) {
        return this.anonType(this, anonType);
    }

    protected <N extends New_c> N anonType(N n, ParsedClassType anonType) {
        if (n.anonType == anonType) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.anonType = anonType;
        return n;
    }

    @Override
    public ProcedureInstance procedureInstance() {
        return this.constructorInstance();
    }

    @Override
    public ConstructorInstance constructorInstance() {
        return this.ci;
    }

    @Override
    public New constructorInstance(ConstructorInstance ci) {
        return this.constructorInstance(this, ci);
    }

    protected <N extends New_c> N constructorInstance(N n, ConstructorInstance ci) {
        if (n.ci == ci) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.ci = ci;
        return n;
    }

    @Override
    public List<Expr> arguments() {
        return this.arguments;
    }

    @Override
    public New arguments(List<Expr> arguments) {
        return this.arguments(this, arguments);
    }

    protected <N extends New_c> N arguments(N n, List<Expr> arguments) {
        if (CollectionUtil.equals(n.arguments, arguments)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.arguments = ListUtil.copy(arguments, true);
        return n;
    }

    @Override
    public ClassBody body() {
        return this.body;
    }

    @Override
    public New body(ClassBody body) {
        return this.body(this, body);
    }

    protected <N extends New_c> N body(N n, ClassBody body) {
        if (n.body == body) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.body = body;
        return n;
    }

    protected <N extends New_c> N reconstruct(N n, Expr qualifier, TypeNode tn, List<Expr> arguments, ClassBody body) {
        n = this.objectType(n, tn);
        n = this.qualifier(n, qualifier);
        n = this.arguments(n, arguments);
        n = this.body(n, body);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr qualifier = this.visitChild(this.qualifier, v);
        TypeNode tn = this.visitChild(this.objectType, v);
        List<Expr> arguments = this.visitList(this.arguments, v);
        ClassBody body = this.visitChild(this.body, v);
        return this.reconstruct(this, qualifier, tn, arguments, body);
    }

    @Override
    public Context enterChildScope(Node child, Context c) {
        if (child == this.body && this.anonType != null && this.body != null) {
            c = c.pushClass(this.anonType, this.anonType);
        }
        return super.enterChildScope(child, c);
    }

    @Override
    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        if (this.body != null) {
            return tb.pushAnonClass(this.position());
        }
        return tb;
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        New_c n = this;
        TypeSystem ts = tb.typeSystem();
        ArrayList<UnknownType> l = new ArrayList<UnknownType>(n.arguments.size());
        for (int i = 0; i < n.arguments.size(); ++i) {
            l.add(ts.unknownType(this.position()));
        }
        ConstructorInstance ci = ts.constructorInstance(this.position(), tb.currentClass(), Flags.NONE, l, Collections.emptyList());
        if ((n = this.constructorInstance(n, ci)).body() != null) {
            ParsedClassType type = tb.anonClass();
            n = this.anonType(n, type);
            type.setMembersAdded(true);
        }
        n = this.type(n, ts.unknownType(this.position()));
        return n;
    }

    @Override
    public Node disambiguateOverride(Node parent, AmbiguityRemover ar) throws SemanticException {
        ClassType ct;
        TypeNode objectType;
        New_c nn = this;
        BodyDisambiguator bd = new BodyDisambiguator(ar);
        NodeVisitor childv = bd.enter(parent, this);
        if (childv instanceof PruningVisitor) {
            return nn;
        }
        BodyDisambiguator childbd = (BodyDisambiguator)childv;
        if (this.qualifier == null) {
            objectType = this.visitChild(this.objectType, childbd);
            nn = this.objectType(nn, objectType);
            if (!objectType.isDisambiguated()) {
                return nn;
            }
            if (objectType.type().isClass() && (ct = objectType.type().toClass()).isInnerClass() && !ct.isLocal()) {
                Expr qualifier = this.visitChild(ar.lang().findQualifier(this, ar, ct), childbd);
                nn = this.qualifier(nn, qualifier);
                nn = this.qualifierImplicit(nn, true);
            }
        } else {
            Expr qualifier = this.visitChild(this.qualifier, childbd);
            nn = this.qualifier(nn, qualifier);
            TypeNode objectType2 = this.objectType;
            if (objectType2 instanceof Ambiguous) {
                if (!qualifier.isTypeChecked()) {
                    return nn;
                }
                if (!qualifier.type().isClass()) {
                    throw new SemanticException("Cannot instantiate member class of non-class type.", nn.position());
                }
                ClassType outer = qualifier.type().toClass();
                TypeNode tn = ar.lang().findQualifiedTypeNode(this, ar, outer, objectType2);
                nn = this.objectType(nn, tn);
            } else if (!objectType2.isDisambiguated()) {
                return nn;
            }
        }
        nn = this.arguments(nn, this.visitList(this.arguments, (NodeVisitor)childbd));
        if (this.body != null) {
            objectType = nn.objectType;
            if (!objectType.isDisambiguated()) {
                return nn;
            }
            ct = objectType.type().toClass();
            ParsedClassType anonType = nn.anonType();
            if (anonType != null && !anonType.supertypesResolved()) {
                if (!ct.flags().isInterface()) {
                    anonType.superType(ct);
                } else {
                    anonType.superType(ar.typeSystem().Object());
                    anonType.addInterface(ct);
                }
                anonType.setSupertypesResolved(true);
            }
            SupertypeDisambiguator supDisamb = new SupertypeDisambiguator(childbd);
            nn = this.body(nn, nn.visitChild(nn.body(), supDisamb));
            SignatureDisambiguator sigDisamb = new SignatureDisambiguator(childbd);
            nn = this.body(nn, nn.visitChild(nn.body(), sigDisamb));
            nn = this.body(nn, nn.visitChild(nn.body(), childbd));
        }
        nn = (New_c)bd.leave(parent, this, nn, childbd);
        return nn;
    }

    @Override
    public TypeNode findQualifiedTypeNode(AmbiguityRemover ar, ClassType outer, TypeNode objectType) throws SemanticException {
        TypeSystem ts = ar.typeSystem();
        NodeFactory nf = ar.nodeFactory();
        Context c = ar.context();
        String name = objectType.name();
        ClassType ct = ts.findMemberClass(outer, name, c.currentClass());
        return nf.CanonicalTypeNode(objectType.position(), ct);
    }

    @Override
    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        return this;
    }

    @Override
    public Expr findQualifier(AmbiguityRemover ar, ClassType ct) throws SemanticException {
        NodeFactory nf = ar.nodeFactory();
        Context c = ar.context();
        if (c.inStaticContext()) {
            if (this.body != null) {
                return null;
            }
            throw new SemanticException("Inner class " + ct + " cannot be instantiated in a static context.", this.position());
        }
        ClassType outer = ar.lang().findEnclosingClass(this, c, ct);
        if (outer == null) {
            throw new SemanticException("Could not find non-static member class \"" + ct.name() + "\".B" + this, this.position());
        }
        Expr q = outer.equals(c.currentClass()) ? nf.This(this.position().startOf()) : nf.This(this.position().startOf(), nf.CanonicalTypeNode(this.position(), outer));
        q = q.type(outer);
        return q;
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        ClassType contextClass;
        ClassType ct;
        TypeSystem ts = tc.typeSystem();
        ArrayList<Type> argTypes = new ArrayList<Type>(this.arguments.size());
        for (Expr e : this.arguments) {
            argTypes.add(e.type());
        }
        if (!this.objectType.type().isClass()) {
            throw new SemanticException("Must have a class for a new expression.", this.position());
        }
        tc.lang().typeCheckFlags(this, tc);
        tc.lang().typeCheckNested(this, tc);
        if (this.body != null) {
            ts.checkClassConformance(this.anonType);
        }
        if (!(ct = this.objectType.type().toClass()).flags().isInterface()) {
            Context c = tc.context();
            if (this.anonType != null) {
                c = c.pushClass(this.anonType, this.anonType);
            }
            this.ci = ts.findConstructor(ct, argTypes, c.currentClass(), this.body == null);
        } else {
            this.ci = ts.defaultConstructor(this.position(), ct);
        }
        New_c n = this.constructorInstance(this, this.ci);
        if (this.anonType != null) {
            ct = this.anonType;
        } else if (this.ci.flags().isProtected() && !ts.equals((contextClass = tc.context().currentClass()).package_(), ct.package_())) {
            throw new SemanticException("Constructor " + this.ci.signature() + " is inaccessible from class " + contextClass, this.position());
        }
        return this.type(n, ct);
    }

    @Override
    public void typeCheckNested(TypeChecker tc) throws SemanticException {
        ClassType ct = this.objectType.type().toClass();
        if (!ct.isMember()) {
            return;
        }
        if (ct.isInnerClass()) {
            ClassType qualifierClassType;
            if (this.qualifier != null) {
                Type qt = this.qualifier.type();
                if (!qt.isClass()) {
                    throw new SemanticException("Cannot instantiate member class of a non-class type.", this.qualifier.position());
                }
                qualifierClassType = qt.toClass();
            } else {
                qualifierClassType = tc.lang().findEnclosingClass(this, tc.context(), ct);
            }
            if (qualifierClassType == null) {
                throw new SemanticException("Could not find non-static member class \"" + ct.name() + "\".A" + this, this.position());
            }
        } else {
            if (this.qualifier != null) {
                throw new SemanticException("Cannot provide a containing instance for non-inner class " + ct.fullName() + ".", this.qualifier.position());
            }
            ClassType t = ct;
            while (t.isMember()) {
                if (!t.flags().isStatic()) {
                    throw new SemanticException("Cannot allocate non-static member class \"" + t + "\".", this.position());
                }
                t = t.outer();
            }
        }
    }

    @Override
    public ClassType findEnclosingClass(Context c, ClassType ct) {
        if (ct == this.anonType) {
            return c.currentClass();
        }
        TypeSystem ts = ct.typeSystem();
        String name = ct.name();
        for (ClassType t = c.currentClass(); t != null; t = t.outer()) {
            try {
                t = ts.staticTarget(t).toClass();
                ClassType mt = ts.findMemberClass(t, name, c.currentClass());
                if (!ts.isSubtype(mt, ct)) continue;
                return t;
            }
            catch (SemanticException e) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void typeCheckFlags(TypeChecker tc) throws SemanticException {
        if (this.objectType.type().isClass()) {
            this.typeCheckFlags(tc, this.objectType.type().toClass().flags());
        }
    }

    protected void typeCheckFlags(TypeChecker tc, Flags classFlags) throws SemanticException {
        if (this.body == null) {
            if (classFlags.isInterface()) {
                throw new SemanticException("Cannot instantiate an interface.", this.position());
            }
            if (classFlags.isAbstract()) {
                throw new SemanticException("Cannot instantiate an abstract class.", this.position());
            }
        } else {
            if (classFlags.isFinal()) {
                throw new SemanticException("Cannot create an anonymous subclass of a final class.", this.position());
            }
            if (classFlags.isInterface() && !this.arguments.isEmpty()) {
                throw new SemanticException("Cannot pass arguments to an anonymous class that implements an interface.", this.arguments.get(0).position());
            }
        }
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.qualifier) {
            ReferenceType t = this.ci.container();
            if (t.isClass() && t.toClass().isMember()) {
                t = t.toClass().container();
                return t;
            }
            return child.type();
        }
        Iterator<Expr> i = this.arguments.iterator();
        Iterator<? extends Type> j = this.ci.formalTypes().iterator();
        while (i.hasNext() && j.hasNext()) {
            Expr e = i.next();
            Type t = j.next();
            if (e != child) continue;
            return t;
        }
        return child.type();
    }

    @Override
    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        if (this.ci == null) {
            throw new InternalCompilerError(this.position(), "Null constructor instance after type check.");
        }
        for (Type type : this.ci.throwTypes()) {
            ec.throwsException(type, this.position());
        }
        return super.exceptionCheck(ec);
    }

    @Override
    public NodeVisitor extRewriteEnter(ExtensionRewriter rw) throws SemanticException {
        if (this.isQualifierImplicit()) {
            return rw.bypass(this.qualifier());
        }
        return super.extRewriteEnter(rw);
    }

    @Override
    public Node extRewrite(ExtensionRewriter rw) throws SemanticException {
        New_c n = (New_c)super.extRewrite(rw);
        n = this.constructorInstance(n, null);
        n = this.anonType(n, null);
        if (this.isQualifierImplicit()) {
            n = this.qualifier(n, null);
        }
        return n;
    }

    @Override
    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    @Override
    public String toString() {
        return (this.qualifier != null ? this.qualifier.toString() + "." : "") + "new " + this.objectType + "(...)" + (this.body != null ? " " + this.body : "");
    }

    @Override
    public void printQualifier(CodeWriter w, PrettyPrinter tr) {
        if (this.qualifier != null && !this.qualifierImplicit) {
            this.printSubExpr(this.qualifier, w, tr);
            w.write(".");
        }
    }

    @Override
    public void printShortObjectType(CodeWriter w, PrettyPrinter tr) {
        w.write(this.objectType.name());
    }

    @Override
    public void printArgs(CodeWriter w, PrettyPrinter tr) {
        w.write("(");
        w.allowBreak(2, 2, "", 0);
        w.begin(0);
        Iterator<Expr> i = this.arguments.iterator();
        while (i.hasNext()) {
            Expr e = i.next();
            this.print(e, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0);
        }
        w.end();
        w.write(")");
    }

    @Override
    public void printBody(CodeWriter w, PrettyPrinter tr) {
        if (this.body != null) {
            w.write(" {");
            this.print(this.body, w, tr);
            w.write("}");
        }
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        ((JLang)tr.lang()).printQualifier(this, w, tr);
        w.write("new ");
        if (this.qualifier != null && !this.qualifierImplicit) {
            ((JLang)tr.lang()).printShortObjectType(this, w, tr);
        } else {
            this.print(this.objectType, w, tr);
        }
        ((JLang)tr.lang()).printArgs(this, w, tr);
        ((JLang)tr.lang()).printBody(this, w, tr);
    }

    @Override
    public Term firstChild() {
        return this.qualifier != null ? this.qualifier : this.objectType;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        if (this.qualifier != null) {
            v.visitCFG(this.qualifier, this.objectType, 1);
        }
        if (this.body != null) {
            v.visitCFG(this.objectType, (Term)New_c.listChild(this.arguments, this.body), 1);
            v.visitCFGList(this.arguments, this.body, 1);
            v.visitCFG(this.body, this, 0);
        } else if (!this.arguments.isEmpty()) {
            v.visitCFG(this.objectType, (Term)New_c.listChild(this.arguments, null), 1);
            v.visitCFGList(this.arguments, this, 0);
        } else {
            v.visitCFG(this.objectType, this, 0);
        }
        return succs;
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        LinkedList<Type> l = new LinkedList<Type>();
        l.addAll(this.ci.throwTypes());
        l.addAll(ts.uncheckedExceptions());
        return l;
    }

    @Override
    public Node typeCheckOverride(Node parent, TypeChecker tc) throws SemanticException {
        New_c nn;
        New_c old = nn = this;
        NodeVisitor childv = tc.enter(parent, this);
        if (childv instanceof PruningVisitor) {
            return nn;
        }
        TypeChecker childtc = (TypeChecker)childv;
        if (nn.qualifier() != null) {
            if (!(nn = this.qualifier(nn, nn.visitChild(nn.qualifier(), childtc))).qualifier().type().isCanonical()) {
                return nn;
            }
            BodyDisambiguator bd = new BodyDisambiguator(tc);
            if (!(nn = bd.visitEdge(parent, nn)).objectType().isDisambiguated()) {
                return nn;
            }
        }
        if (!(nn = this.objectType(nn, nn.visitChild(nn.objectType(), childtc))).objectType().type().isCanonical()) {
            return nn;
        }
        nn = this.arguments(nn, nn.visitList(nn.arguments(), (NodeVisitor)childtc));
        nn = this.body(nn, nn.visitChild(nn.body(), childtc));
        nn = (New_c)tc.leave(parent, old, nn, childtc);
        ConstantChecker cc = new ConstantChecker(tc.job(), tc.typeSystem(), tc.nodeFactory());
        cc = (ConstantChecker)cc.context(childtc.context());
        nn = (New_c)tc.lang().checkConstants(nn, cc);
        return nn;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.New(this.position, this.qualifier, this.objectType, this.arguments, this.body);
    }
}

