/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Ext;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.ProcedureDecl_c;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.main.Report;
import polyglot.translate.ExtensionRewriter;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.ProcedureInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.UnknownType;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class MethodDecl_c
extends ProcedureDecl_c
implements MethodDecl {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected TypeNode returnType;
    protected MethodInstance mi;
    private static final Collection<String> TOPICS = CollectionUtil.list("types", "context");

    public MethodDecl_c(Position pos, Flags flags, TypeNode returnType, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body) {
        this(pos, flags, returnType, name, formals, throwTypes, body, null);
    }

    public MethodDecl_c(Position pos, Flags flags, TypeNode returnType, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body, Ext ext) {
        super(pos, flags, name, formals, throwTypes, body, ext);
        assert (returnType != null);
        this.returnType = returnType;
    }

    @Override
    public boolean isDisambiguated() {
        return this.mi != null && this.mi.isCanonical() && super.isDisambiguated();
    }

    @Override
    public MemberInstance memberInstance() {
        return this.mi;
    }

    @Override
    public TypeNode returnType() {
        return this.returnType;
    }

    @Override
    public MethodDecl returnType(TypeNode returnType) {
        return this.returnType(this, returnType);
    }

    protected <N extends MethodDecl_c> N returnType(N n, TypeNode returnType) {
        if (n.returnType == returnType) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.returnType = returnType;
        return n;
    }

    @Override
    public ProcedureInstance procedureInstance() {
        return this.methodInstance();
    }

    @Override
    public MethodInstance methodInstance() {
        return this.mi;
    }

    @Override
    public MethodDecl methodInstance(MethodInstance mi) {
        return this.methodInstance(this, mi);
    }

    protected <N extends MethodDecl_c> N methodInstance(N n, MethodInstance mi) {
        if (n.mi == mi) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.mi = mi;
        return n;
    }

    protected <N extends MethodDecl_c> N reconstruct(N n, TypeNode returnType, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body) {
        n = super.reconstruct(n, name, formals, throwTypes, body);
        n = this.returnType(n, returnType);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Id name = this.visitChild(this.name, v);
        List<Formal> formals = this.visitList(this.formals, v);
        TypeNode returnType = this.visitChild(this.returnType, v);
        List<TypeNode> throwTypes = this.visitList(this.throwTypes, v);
        Block body = this.visitChild(this.body, v);
        return this.reconstruct(this, returnType, name, formals, throwTypes, body);
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        TypeSystem ts = tb.typeSystem();
        ParsedClassType ct = tb.currentClass();
        if (ct == null) {
            return this;
        }
        ArrayList<UnknownType> formalTypes = new ArrayList<UnknownType>(this.formals.size());
        for (int i = 0; i < this.formals.size(); ++i) {
            formalTypes.add(ts.unknownType(this.position()));
        }
        ArrayList<UnknownType> throwTypes = new ArrayList<UnknownType>(this.throwTypes().size());
        for (int i = 0; i < this.throwTypes().size(); ++i) {
            throwTypes.add(ts.unknownType(this.position()));
        }
        Flags f = this.flags;
        if (ct.flags().isInterface()) {
            f = f.Public().Abstract();
        }
        MethodInstance mi = ts.methodInstance(this.position(), ct, f, ts.unknownType(this.position()), this.name.id(), formalTypes, throwTypes);
        ct.addMethod(mi);
        return this.methodInstance(mi);
    }

    @Override
    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (!this.returnType.isDisambiguated()) {
            return this;
        }
        this.mi.setReturnType(this.returnType.type());
        return super.disambiguate(ar);
    }

    @Override
    public Context enterScope(Context c) {
        if (Report.should_report(TOPICS, 5)) {
            Report.report(5, "enter scope of method " + this.name);
        }
        c = c.pushCode(this.mi);
        return c;
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Flags flags = this.mi.flags();
        if (tc.context().currentClass().flags().isInterface() && (flags.isProtected() || flags.isPrivate())) {
            throw new SemanticException("Interface methods must be public.", this.position());
        }
        try {
            ts.checkMethodFlags(flags);
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        if (this.body == null && !flags.isAbstract() && !flags.isNative()) {
            throw new SemanticException("Missing method body.", this.position());
        }
        if (this.body != null && (flags.isAbstract() || flags.isNative())) {
            throw new SemanticException("An abstract method cannot have a body.", this.position());
        }
        if (this.body != null && flags.isNative()) {
            throw new SemanticException("A native method cannot have a body.", this.position());
        }
        this.throwsCheck(tc);
        if (flags.isStatic() && this.methodInstance().container().toClass().isInnerClass()) {
            throw new SemanticException("Inner classes cannot declare static methods.", this.position());
        }
        this.overrideMethodCheck(tc);
        return this;
    }

    public void throwsCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        for (TypeNode tn : this.throwTypes()) {
            Type t = tn.type();
            if (t.isThrowable()) continue;
            throw new SemanticException("Type \"" + t + "\" is not a subclass of \"" + ts.Throwable() + "\".", tn.position());
        }
    }

    public void overrideMethodCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        for (MethodInstance methodInstance : this.mi.implemented()) {
            ts.checkOverride(this.mi, methodInstance);
        }
    }

    @Override
    public Node extRewrite(ExtensionRewriter rw) throws SemanticException {
        MethodDecl_c n = (MethodDecl_c)super.extRewrite(rw);
        n = this.methodInstance(n, null);
        return n;
    }

    @Override
    public String toString() {
        return this.flags.translate() + this.returnType + " " + this.name + "(...)";
    }

    @Override
    public void prettyPrintHeader(Flags flags, CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        w.write(flags.translate());
        this.print(this.returnType, w, tr);
        w.allowBreak(2, 2, " ", 1);
        w.write(this.name + "(");
        w.allowBreak(2, 2, "", 0);
        w.begin(0);
        Iterator<Object> i = this.formals.iterator();
        while (i.hasNext()) {
            Formal f = (Formal)i.next();
            this.print(f, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.end();
        w.write(")");
        if (!this.throwTypes().isEmpty()) {
            w.allowBreak(6);
            w.write("throws ");
            i = this.throwTypes().iterator();
            while (i.hasNext()) {
                TypeNode tn = (TypeNode)i.next();
                this.print(tn, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(4, " ");
            }
        }
        w.end();
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(name " + this.name + ")");
        w.end();
    }

    @Override
    public Term firstChild() {
        return MethodDecl_c.listChild(this.formals(), this.returnType());
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.visitCFGList(this.formals(), this.returnType(), 1);
        if (this.body() == null) {
            v.visitCFG(this.returnType(), this, 0);
        } else {
            v.visitCFG(this.returnType(), this.body(), 1);
            v.visitCFG(this.body(), this, 0);
        }
        return succs;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.MethodDecl(this.position, this.flags, this.returnType, this.name, (List<Formal>)this.formals, (List<TypeNode>)this.throwTypes, this.body);
    }
}

