/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.ast.Ext;
import polyglot.ast.IntLit;
import polyglot.ast.Lang;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.NumLit_c;
import polyglot.ast.Precedence;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class IntLit_c
extends NumLit_c
implements IntLit {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected IntLit.Kind kind;

    public IntLit_c(Position pos, IntLit.Kind kind, long value) {
        this(pos, kind, value, null);
    }

    public IntLit_c(Position pos, IntLit.Kind kind, long value, Ext ext) {
        super(pos, value, ext);
        assert (kind != null);
        this.kind = kind;
    }

    @Override
    public boolean boundary() {
        return this.kind == INT && (int)this.value == Integer.MIN_VALUE || this.kind == LONG && this.value == Long.MIN_VALUE;
    }

    @Override
    public long value() {
        return this.longValue();
    }

    @Override
    public IntLit value(long value) {
        return this.value(this, value);
    }

    protected <N extends IntLit_c> N value(N n, long value) {
        if (n.value == value) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.value = value;
        return n;
    }

    @Override
    public IntLit.Kind kind() {
        return this.kind;
    }

    @Override
    public IntLit kind(IntLit.Kind kind) {
        return this.kind(this, kind);
    }

    protected <N extends IntLit_c> N kind(N n, IntLit.Kind kind) {
        if (n.kind == kind) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.kind = kind;
        return n;
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        IntLit.Kind kind = this.kind();
        if (kind == INT) {
            return this.type(ts.Int());
        }
        if (kind == LONG) {
            return this.type(ts.Long());
        }
        throw new InternalCompilerError("Unrecognized IntLit kind " + kind);
    }

    @Override
    public String positiveToString() {
        if (this.kind() == LONG) {
            if (this.boundary()) {
                return "9223372036854775808L";
            }
            if (this.value < 0L) {
                return "0x" + Long.toHexString(this.value) + "L";
            }
            return Long.toString(this.value) + "L";
        }
        if (this.boundary()) {
            return "2147483648";
        }
        if ((int)this.value < 0) {
            return "0x" + Integer.toHexString((int)this.value);
        }
        return Integer.toString((int)this.value);
    }

    @Override
    public String toString() {
        if (this.kind() == LONG) {
            return Long.toString(this.value) + "L";
        }
        return Long.toString((int)this.value);
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write(this.toString());
    }

    @Override
    public Object constantValue(Lang lang) {
        if (this.kind() == LONG) {
            return new Long(this.value);
        }
        return new Integer((int)this.value);
    }

    @Override
    public Precedence precedence() {
        if (this.value < 0L && !this.boundary()) {
            return Precedence.UNARY;
        }
        return Precedence.LITERAL;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.IntLit(this.position, this.kind, this.value);
    }
}

