/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.JLang;
import polyglot.ast.Lang;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.NodeOps;
import polyglot.ast.Stmt;
import polyglot.frontend.ExtensionInfo;
import polyglot.translate.ExtensionRewriter;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.SerialVersionUID;
import polyglot.util.StringUtil;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.ConstantChecker;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public abstract class Ext_c
implements Ext {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Node node = null;
    protected NodeOps pred;
    protected Ext ext;

    public Ext_c() {
        this(null);
    }

    public Ext_c(Ext ext) {
        this.ext = ext;
    }

    @Override
    public Lang lang() {
        throw new InternalCompilerError("Unexpected invocation from extension object: " + this);
    }

    protected final JLang superLang() {
        return (JLang)this.pred.lang();
    }

    @Override
    public <N extends Node> N visitChild(N child, NodeVisitor v) {
        return this.node().visitChild(child, v);
    }

    @Override
    public <N extends Node> List<N> visitList(List<N> l, NodeVisitor v) {
        return this.node().visitList(l, v);
    }

    @Override
    public Node node() {
        return this.node;
    }

    @Override
    public NodeOps pred() {
        return this.pred;
    }

    @Override
    public void init(Node node) {
        if (this.node != null) {
            throw new InternalCompilerError("Already initialized.");
        }
        this.node = node;
        if (this.ext != null) {
            this.ext.init(node);
        }
    }

    @Override
    public void initPred(NodeOps pred) {
        if (this.pred != null) {
            throw new InternalCompilerError("Already initialized.");
        }
        this.pred = pred;
        if (this.ext != null) {
            this.ext.initPred(this);
        }
    }

    @Override
    public Ext ext() {
        return this.ext;
    }

    @Override
    public Ext ext(Ext ext) {
        Ext old = this.ext;
        this.ext = null;
        Ext_c copy = (Ext_c)this.copy();
        copy.ext = ext;
        this.ext = old;
        return copy;
    }

    @Override
    public Ext copy() {
        try {
            Ext_c copy = (Ext_c)super.clone();
            if (this.ext != null) {
                copy.ext = (Ext)this.ext.copy();
            }
            copy.node = null;
            copy.pred = null;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalCompilerError("Unable to clone an extension object.");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(StringUtil.getShortNameComponent(this.getClass().getName()));
        if (this.ext != null) {
            sb.append(":");
            sb.append(this.ext.toString());
        }
        return sb.toString();
    }

    @Override
    public void dump(CodeWriter w) {
        w.write(this.toString());
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        return this.superLang().visitChildren(this.node(), v);
    }

    @Override
    public Context enterScope(Context c) {
        return this.superLang().enterScope(this.node(), c);
    }

    @Override
    public Context enterChildScope(Node child, Context c) {
        return this.superLang().enterChildScope(this.node(), child, c);
    }

    @Override
    public void addDecls(Context c) {
        this.superLang().addDecls(this.node(), c);
    }

    @Override
    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        return this.superLang().buildTypesEnter(this.node(), tb);
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        return this.superLang().buildTypes(this.node(), tb);
    }

    @Override
    public Node disambiguateOverride(Node parent, AmbiguityRemover ar) throws SemanticException {
        return this.superLang().disambiguateOverride(this.node(), parent, ar);
    }

    @Override
    public NodeVisitor disambiguateEnter(AmbiguityRemover ar) throws SemanticException {
        return this.superLang().disambiguateEnter(this.node(), ar);
    }

    @Override
    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        return this.superLang().disambiguate(this.node(), ar);
    }

    @Override
    public Node typeCheckOverride(Node parent, TypeChecker tc) throws SemanticException {
        return this.superLang().typeCheckOverride(this.node(), parent, tc);
    }

    @Override
    public NodeVisitor typeCheckEnter(TypeChecker tc) throws SemanticException {
        return this.superLang().typeCheckEnter(this.node(), tc);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        return this.superLang().typeCheck(this.node(), tc);
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        return this.superLang().childExpectedType(this.node(), child, av);
    }

    @Override
    public Node checkConstants(ConstantChecker cc) throws SemanticException {
        return this.superLang().checkConstants(this.node(), cc);
    }

    @Override
    public NodeVisitor exceptionCheckEnter(ExceptionChecker ec) throws SemanticException {
        return this.superLang().exceptionCheckEnter(this.node(), ec);
    }

    @Override
    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        return this.superLang().exceptionCheck(this.node(), ec);
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        return this.superLang().throwTypes(this.node(), ts);
    }

    @Override
    public NodeVisitor extRewriteEnter(ExtensionRewriter rw) throws SemanticException {
        return this.superLang().extRewriteEnter(this.node(), rw);
    }

    @Override
    public Node extRewrite(ExtensionRewriter rw) throws SemanticException {
        return this.superLang().extRewrite(this.node(), rw);
    }

    @Override
    @Deprecated
    public void dump(OutputStream os) {
        this.node().del().dump(os);
    }

    @Override
    public void dump(Lang lang, OutputStream os) {
        this.superLang().dump(this.node(), lang, os);
    }

    @Override
    @Deprecated
    public void dump(Writer w) {
        this.node().del().dump(w);
    }

    @Override
    public void dump(Lang lang, Writer w) {
        this.superLang().dump(this.node(), lang, w);
    }

    @Override
    @Deprecated
    public void prettyPrint(OutputStream os) {
        this.node().del().prettyPrint(os);
    }

    @Override
    public void prettyPrint(Lang lang, OutputStream os) {
        this.superLang().prettyPrint(this.node(), lang, os);
    }

    @Override
    @Deprecated
    public void prettyPrint(Writer w) {
        this.node().del().prettyPrint(w);
    }

    @Override
    public void prettyPrint(Lang lang, Writer w) {
        this.superLang().prettyPrint(this.node(), lang, w);
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter pp) {
        this.superLang().prettyPrint(this.node(), w, pp);
    }

    public void print(Node child, CodeWriter w, PrettyPrinter pp) {
        pp.print(this.node(), child, w);
    }

    public void printBlock(Node n, CodeWriter w, PrettyPrinter pp) {
        w.begin(0);
        this.print(n, w, pp);
        w.end();
    }

    public void printSubStmt(Stmt stmt, CodeWriter w, PrettyPrinter pp) {
        if (stmt instanceof Block) {
            w.write(" ");
            this.print(stmt, w, pp);
        } else {
            w.allowBreak(4, " ");
            this.printBlock(stmt, w, pp);
        }
    }

    @Override
    public void translate(CodeWriter w, Translator tr) {
        this.superLang().translate(this.node(), w, tr);
    }

    @Override
    public Node copy(NodeFactory nf) {
        return this.superLang().copy(this.node(), nf);
    }

    @Override
    public Node copy(ExtensionInfo extInfo) throws SemanticException {
        return this.superLang().copy(this.node(), extInfo);
    }
}

