/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.ast.Ambiguous;
import polyglot.ast.Disamb;
import polyglot.ast.Expr;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.PackageNode;
import polyglot.ast.Prefix;
import polyglot.ast.QualifierNode;
import polyglot.ast.Receiver;
import polyglot.ast.TypeNode;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.LocalInstance;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.NoMemberException;
import polyglot.types.Qualifier;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;

public class Disamb_c
implements Disamb {
    protected ContextVisitor v;
    protected Position pos;
    protected Prefix prefix;
    protected Id name;
    protected NodeFactory nf;
    protected TypeSystem ts;
    protected Context c;
    protected Ambiguous amb;

    @Override
    @Deprecated
    public Node disambiguate(Ambiguous amb, ContextVisitor v, Position pos, Prefix prefix, String name) throws SemanticException {
        return this.disambiguate(amb, v, pos, prefix, v.nodeFactory().Id(pos, name));
    }

    @Override
    public Node disambiguate(Ambiguous amb, ContextVisitor v, Position pos, Prefix prefix, Id name) throws SemanticException {
        this.v = v;
        this.pos = pos;
        this.prefix = prefix;
        this.name = name;
        this.amb = amb;
        this.nf = v.nodeFactory();
        this.ts = v.typeSystem();
        this.c = v.context();
        if (prefix instanceof Ambiguous) {
            throw new SemanticException("Cannot disambiguate node with ambiguous prefix.");
        }
        Node result = null;
        if (prefix instanceof PackageNode) {
            PackageNode pn = (PackageNode)prefix;
            result = this.disambiguatePackagePrefix(pn);
        } else if (prefix instanceof TypeNode) {
            TypeNode tn = (TypeNode)prefix;
            result = this.disambiguateTypeNodePrefix(tn);
        } else if (prefix instanceof Expr) {
            Expr e = (Expr)prefix;
            result = this.disambiguateExprPrefix(e);
        } else if (prefix == null) {
            result = this.disambiguateNoPrefix();
        }
        return result;
    }

    protected Node disambiguatePackagePrefix(PackageNode pn) throws SemanticException {
        Named n;
        Resolver pc = this.ts.packageContextResolver(pn.package_());
        try {
            n = pc.find(this.name.id());
        }
        catch (SemanticException e) {
            return null;
        }
        Qualifier q = null;
        if (!(n instanceof Qualifier)) {
            return null;
        }
        q = (Qualifier)((Object)n);
        if (q.isPackage() && this.packageOK()) {
            return this.nf.PackageNode(this.pos, q.toPackage());
        }
        if (q.isType() && this.typeOK()) {
            return this.nf.CanonicalTypeNode(this.pos, q.toType());
        }
        return null;
    }

    protected Node disambiguateTypeNodePrefix(TypeNode tn) throws SemanticException {
        Type t;
        block7: {
            t = tn.type();
            if (t.isReference() && this.exprOK()) {
                try {
                    FieldInstance fi = this.ts.findField(t.toReference(), this.name.id(), this.c.currentClass(), true);
                    return this.nf.Field(this.pos, (Receiver)tn, this.name).fieldInstance(fi).type(this.ts.unknownType(this.pos));
                }
                catch (NoMemberException e) {
                    if (e.getKind() == 3) break block7;
                    throw e;
                }
            }
        }
        if (t.isClass() && this.typeOK()) {
            Named n;
            Resolver tc = t.toClass().resolver();
            try {
                n = tc.find(this.name.id());
            }
            catch (NoClassException e) {
                return null;
            }
            if (n instanceof Type) {
                Type type = (Type)((Object)n);
                return this.nf.CanonicalTypeNode(this.pos, type);
            }
        }
        return null;
    }

    protected Node disambiguateExprPrefix(Expr e) throws SemanticException {
        if (this.exprOK()) {
            return this.nf.Field(this.pos, (Receiver)e, this.name).type(this.ts.unknownType(this.pos));
        }
        return null;
    }

    protected Node disambiguateNoPrefix() throws SemanticException {
        block7: {
            Node n;
            VarInstance vi;
            if (this.exprOK() && (vi = this.c.findVariableSilent(this.name.id())) != null && (n = this.disambiguateVarInstance(vi)) != null) {
                return n;
            }
            if (this.typeOK()) {
                try {
                    Named n2 = this.c.find(this.name.id());
                    if (n2 instanceof Type) {
                        Type type = (Type)((Object)n2);
                        if (!type.isCanonical()) {
                            throw new InternalCompilerError("Found an ambiguous type in the context: " + type, this.pos);
                        }
                        return this.nf.CanonicalTypeNode(this.pos, type);
                    }
                }
                catch (NoClassException e) {
                    if (this.name.id().equals(e.getClassName())) break block7;
                    throw e;
                }
            }
        }
        if (this.packageOK()) {
            return this.nf.PackageNode(this.pos, this.ts.packageForName(this.name.id()));
        }
        return null;
    }

    protected Node disambiguateVarInstance(VarInstance vi) throws SemanticException {
        if (vi instanceof FieldInstance) {
            FieldInstance fi = (FieldInstance)vi;
            Receiver r = this.makeMissingFieldTarget(fi);
            return this.nf.Field(this.pos, r, this.name).fieldInstance(fi).targetImplicit(true).type(this.ts.unknownType(this.pos));
        }
        if (vi instanceof LocalInstance) {
            LocalInstance li = (LocalInstance)vi;
            return this.nf.Local(this.pos, this.name).localInstance(li).type(this.ts.unknownType(this.pos));
        }
        return null;
    }

    protected Receiver makeMissingFieldTarget(FieldInstance fi) throws SemanticException {
        ClassType scope = this.c.findFieldScope(this.name.id());
        Receiver r = fi.flags().isStatic() ? this.nf.CanonicalTypeNode(this.pos, scope) : (!this.ts.equals(scope, this.c.currentClass()) ? this.nf.This(this.pos.startOf(), this.nf.CanonicalTypeNode(this.pos, scope)) : this.nf.This(this.pos.startOf()));
        return r;
    }

    protected boolean typeOK() {
        return !(this.amb instanceof Expr) && (this.amb instanceof TypeNode || this.amb instanceof QualifierNode || this.amb instanceof Receiver || this.amb instanceof Prefix);
    }

    protected boolean packageOK() {
        return !(this.amb instanceof Receiver) && (this.amb instanceof QualifierNode || this.amb instanceof Prefix);
    }

    protected boolean exprOK() {
        return !(this.amb instanceof QualifierNode) && !(this.amb instanceof TypeNode) && (this.amb instanceof Expr || this.amb instanceof Receiver || this.amb instanceof Prefix);
    }

    public String toString() {
        return "Disamb(" + this.amb.getClass().getName() + ": " + this.amb + ")";
    }
}

