/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Ext;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.ProcedureDecl_c;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.translate.ExtensionRewriter;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.MemberInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.ProcedureInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.UnknownType;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class ConstructorDecl_c
extends ProcedureDecl_c
implements ConstructorDecl {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected ConstructorInstance ci;

    public ConstructorDecl_c(Position pos, Flags flags, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body) {
        this(pos, flags, name, formals, throwTypes, body, null);
    }

    public ConstructorDecl_c(Position pos, Flags flags, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body, Ext ext) {
        super(pos, flags, name, formals, throwTypes, body, ext);
    }

    @Override
    public boolean isDisambiguated() {
        return this.ci != null && this.ci.isCanonical() && super.isDisambiguated();
    }

    @Override
    public MemberInstance memberInstance() {
        return this.ci;
    }

    @Override
    public ProcedureInstance procedureInstance() {
        return this.constructorInstance();
    }

    @Override
    public ConstructorInstance constructorInstance() {
        return this.ci;
    }

    @Override
    public ConstructorDecl constructorInstance(ConstructorInstance ci) {
        return this.constructorInstance(this, ci);
    }

    protected <N extends ConstructorDecl_c> N constructorInstance(N n, ConstructorInstance ci) {
        if (n.ci == ci) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.ci = ci;
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Id name = this.visitChild(this.name, v);
        List<Formal> formals = this.visitList(this.formals, v);
        List<TypeNode> throwTypes = this.visitList(this.throwTypes, v);
        Block body = this.visitChild(this.body, v);
        return this.reconstruct(this, name, formals, throwTypes, body);
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        TypeSystem ts = tb.typeSystem();
        ParsedClassType ct = tb.currentClass();
        if (ct == null) {
            return this;
        }
        ArrayList<UnknownType> formalTypes = new ArrayList<UnknownType>(this.formals.size());
        for (int i = 0; i < this.formals.size(); ++i) {
            formalTypes.add(ts.unknownType(this.position()));
        }
        ArrayList<UnknownType> throwTypes = new ArrayList<UnknownType>(this.throwTypes().size());
        for (int i = 0; i < this.throwTypes().size(); ++i) {
            throwTypes.add(ts.unknownType(this.position()));
        }
        ConstructorInstance ci = ts.constructorInstance(this.position(), ct, this.flags, formalTypes, throwTypes);
        ct.addConstructor(ci);
        return this.constructorInstance(ci);
    }

    @Override
    public Context enterScope(Context c) {
        return c.pushCode(this.ci);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Context c = tc.context();
        TypeSystem ts = tc.typeSystem();
        ClassType ct = c.currentClass();
        if (ct.flags().isInterface()) {
            throw new SemanticException("Cannot declare a constructor inside an interface.", this.position());
        }
        if (ct.isAnonymous()) {
            throw new SemanticException("Cannot declare a constructor inside an anonymous class.", this.position());
        }
        String ctName = ct.name();
        if (!ctName.equals(this.name.id())) {
            throw new SemanticException("Constructor name \"" + this.name + "\" does not match name of containing class \"" + ctName + "\".", this.position());
        }
        try {
            ts.checkConstructorFlags(this.flags());
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        if (this.body == null && !this.flags().isNative()) {
            throw new SemanticException("Missing constructor body.", this.position());
        }
        if (this.body != null && this.flags().isNative()) {
            throw new SemanticException("A native constructor cannot have a body.", this.position());
        }
        for (TypeNode tn : this.throwTypes()) {
            Type t = tn.type();
            if (t.isThrowable()) continue;
            throw new SemanticException("Type \"" + t + "\" is not a subclass of \"" + ts.Throwable() + "\".", tn.position());
        }
        return this;
    }

    @Override
    public Node extRewrite(ExtensionRewriter rw) throws SemanticException {
        ConstructorDecl_c n = (ConstructorDecl_c)super.extRewrite(rw);
        n = this.constructorInstance(n, null);
        return n;
    }

    @Override
    public String toString() {
        return this.flags.translate() + this.name + "(...)";
    }

    @Override
    public void prettyPrintHeader(Flags flags, CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        w.write(flags.translate());
        tr.print(this, this.name, w);
        w.write("(");
        w.begin(0);
        Iterator<Object> i = this.formals.iterator();
        while (i.hasNext()) {
            Formal f = (Formal)i.next();
            this.print(f, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.end();
        w.write(")");
        if (!this.throwTypes().isEmpty()) {
            w.allowBreak(6);
            w.write("throws ");
            i = this.throwTypes().iterator();
            while (i.hasNext()) {
                TypeNode tn = (TypeNode)i.next();
                this.print(tn, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(4, " ");
            }
        }
        w.end();
    }

    @Override
    public Term firstChild() {
        return ConstructorDecl_c.listChild(this.formals(), this.body() != null ? this.body() : null);
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        if (this.body() != null) {
            v.visitCFGList(this.formals(), this.body(), 1);
            v.visitCFG(this.body(), this, 0);
        } else {
            v.visitCFGList(this.formals(), this, 0);
        }
        return succs;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.ConstructorDecl(this.position, this.flags, this.name, (List<Formal>)this.formals, (List<TypeNode>)this.throwTypes, this.body);
    }
}

