/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Catch;
import polyglot.ast.Ext;
import polyglot.ast.Formal;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Catch_c
extends Stmt_c
implements Catch {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Formal formal;
    protected Block body;

    public Catch_c(Position pos, Formal formal, Block body) {
        this(pos, formal, body, null);
    }

    public Catch_c(Position pos, Formal formal, Block body, Ext ext) {
        super(pos, ext);
        assert (formal != null && body != null);
        this.formal = formal;
        this.body = body;
    }

    @Override
    public Type catchType() {
        return this.formal.declType();
    }

    @Override
    public Formal formal() {
        return this.formal;
    }

    @Override
    public Catch formal(Formal formal) {
        return this.formal(this, formal);
    }

    protected <N extends Catch_c> N formal(N n, Formal formal) {
        if (n.formal == formal) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.formal = formal;
        return n;
    }

    @Override
    public Block body() {
        return this.body;
    }

    @Override
    public Catch body(Block body) {
        return this.body(this, body);
    }

    protected <N extends Catch_c> N body(N n, Block body) {
        if (n.body == body) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.body = body;
        return n;
    }

    protected <N extends Catch_c> N reconstruct(N n, Formal formal, Block body) {
        n = this.formal(n, formal);
        n = this.body(n, body);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Formal formal = this.visitChild(this.formal, v);
        Block body = this.visitChild(this.body, v);
        return this.reconstruct(this, formal, body);
    }

    @Override
    public Context enterScope(Context c) {
        return c.pushBlock();
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (!this.catchType().isThrowable()) {
            throw new SemanticException("Can only throw subclasses of \"" + ts.Throwable() + "\".", this.formal.position());
        }
        return this;
    }

    @Override
    public String toString() {
        return "catch (" + this.formal + ") " + this.body;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("catch (");
        this.printBlock(this.formal, w, tr);
        w.write(")");
        this.printSubStmt(this.body, w, tr);
    }

    @Override
    public Term firstChild() {
        return this.formal;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.visitCFG(this.formal, this.body, 1);
        v.visitCFG(this.body, this, 0);
        return succs;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Catch(this.position, this.formal, this.body);
    }
}

