/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Assert;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.main.Options;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.ErrorQueue;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;
import polyglot.visit.TypeChecker;

public class Assert_c
extends Stmt_c
implements Assert {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Expr cond;
    protected Expr errorMessage;

    public Assert_c(Position pos, Expr cond, Expr errorMessage) {
        this(pos, cond, errorMessage, null);
    }

    public Assert_c(Position pos, Expr cond, Expr errorMessage, Ext ext) {
        super(pos, ext);
        assert (cond != null);
        this.cond = cond;
        this.errorMessage = errorMessage;
    }

    @Override
    public Expr cond() {
        return this.cond;
    }

    @Override
    public Assert cond(Expr cond) {
        return this.cond(this, cond);
    }

    protected <N extends Assert_c> N cond(N n, Expr cond) {
        if (n.cond == cond) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.cond = cond;
        return n;
    }

    @Override
    public Expr errorMessage() {
        return this.errorMessage;
    }

    @Override
    public Assert errorMessage(Expr errorMessage) {
        return this.errorMessage(this, errorMessage);
    }

    protected <N extends Assert_c> N errorMessage(N n, Expr errorMessage) {
        if (n.errorMessage == errorMessage) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.errorMessage = errorMessage;
        return n;
    }

    protected <N extends Assert_c> N reconstruct(N n, Expr cond, Expr errorMessage) {
        n = this.cond(n, cond);
        n = this.errorMessage(n, errorMessage);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr cond = this.visitChild(this.cond, v);
        Expr errorMessage = this.visitChild(this.errorMessage, v);
        return this.reconstruct(this, cond, errorMessage);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (!Options.global.assertions) {
            ErrorQueue eq = tc.errorQueue();
            eq.enqueue(0, "assert statements are disabled. Recompile with -assert and ensure the post compiler supports assert (e.g., -post \"javac -source 1.4\"). Removing the statement and continuing.", this.cond.position());
        }
        if (!ts.typeEquals(this.cond.type(), ts.Boolean())) {
            throw new SemanticException("Condition of assert statement must have boolean type.", this.cond.position());
        }
        if (this.errorMessage != null && ts.typeEquals(this.errorMessage.type(), ts.Void())) {
            throw new SemanticException("Error message in assert statement must have a value.", this.errorMessage.position());
        }
        return this;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.cond) {
            return ts.Boolean();
        }
        return child.type();
    }

    @Override
    public String toString() {
        return "assert " + this.cond.toString() + (this.errorMessage != null ? ": " + this.errorMessage.toString() : "") + ";";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("assert ");
        this.print(this.cond, w, tr);
        if (this.errorMessage != null) {
            w.write(": ");
            this.print(this.errorMessage, w, tr);
        }
        w.write(";");
    }

    @Override
    public void translate(CodeWriter w, Translator tr) {
        if (!Options.global.assertions) {
            w.write(";");
        } else {
            tr.lang().prettyPrint((Node)this, w, tr);
        }
    }

    @Override
    public Term firstChild() {
        return this.cond;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        if (this.errorMessage != null) {
            v.visitCFG(this.cond, this.errorMessage, 1);
            v.visitCFG(this.errorMessage, this, 0);
        } else {
            v.visitCFG(this.cond, this, 0);
        }
        return succs;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Assert(this.position, this.cond, this.errorMessage);
    }
}

