/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.ast.AmbPrefix;
import polyglot.ast.Ambiguous;
import polyglot.ast.Ext;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Node_c;
import polyglot.ast.Prefix;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.ContextVisitor;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class AmbPrefix_c
extends Node_c
implements AmbPrefix {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Prefix prefix;
    protected Id name;

    public AmbPrefix_c(Position pos, Prefix prefix, Id name) {
        this(pos, prefix, name, null);
    }

    public AmbPrefix_c(Position pos, Prefix prefix, Id name, Ext ext) {
        super(pos, ext);
        assert (name != null);
        this.prefix = prefix;
        this.name = name;
    }

    @Override
    public Id nameNode() {
        return this.name;
    }

    public AmbPrefix id(Id name) {
        return this.id(this, name);
    }

    protected <N extends AmbPrefix_c> N id(N n, Id name) {
        if (n.name == name) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.name = name;
        return n;
    }

    @Override
    public String name() {
        return this.name.id();
    }

    public AmbPrefix name(String name) {
        return this.id(this.name.id(name));
    }

    @Override
    public Prefix prefix() {
        return this.prefix;
    }

    public AmbPrefix prefix(Prefix prefix) {
        return this.prefix(this, prefix);
    }

    protected <N extends AmbPrefix_c> N prefix(N n, Prefix prefix) {
        if (n.prefix == prefix) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.prefix = prefix;
        return n;
    }

    protected <N extends AmbPrefix_c> N reconstruct(N n, Prefix prefix, Id name) {
        n = this.prefix(n, prefix);
        n = this.id(n, name);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Prefix prefix = this.visitChild(this.prefix, v);
        Id name = this.visitChild(this.name, v);
        return this.reconstruct(this, prefix, name);
    }

    @Override
    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (this.prefix != null && !this.prefix.isDisambiguated()) {
            return this;
        }
        return ar.nodeFactory().disamb().disambiguate((Ambiguous)this, (ContextVisitor)ar, this.position(), this.prefix, this.name);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        return this;
    }

    @Override
    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        throw new InternalCompilerError(this.position(), "Cannot exception check ambiguous node " + this + ".");
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.prefix != null) {
            this.print(this.prefix, w, tr);
            w.write(".");
        }
        tr.print(this, this.name, w);
    }

    @Override
    public String toString() {
        return (this.prefix == null ? this.name.toString() : this.prefix.toString() + "." + this.name.toString()) + "{amb}";
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.AmbPrefix(this.position, this.prefix, this.name);
    }
}

