/*
 * Decompiled with CFR 0.152.
 */
package java_cup;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Stack;
import java_cup.ErrorManager;
import java_cup.Main;
import java_cup.emit;
import java_cup.internal_error;
import java_cup.lalr_item;
import java_cup.lalr_item_set;
import java_cup.lalr_transition;
import java_cup.non_terminal;
import java_cup.nonassoc_action;
import java_cup.parse_action;
import java_cup.parse_action_row;
import java_cup.parse_action_table;
import java_cup.parse_reduce_row;
import java_cup.parse_reduce_table;
import java_cup.production;
import java_cup.production_part;
import java_cup.reduce_action;
import java_cup.shift_action;
import java_cup.symbol;
import java_cup.symbol_part;
import java_cup.symbol_set;
import java_cup.terminal;
import java_cup.terminal_set;

public class lalr_state {
    protected static HashMap<lalr_item_set, lalr_state> _all = new HashMap();
    protected static HashMap<lalr_item_set, lalr_state> _all_kernels = new HashMap();
    protected static int next_index = 0;
    protected lalr_item_set _items;
    protected lalr_transition _transitions = null;
    protected int _index;
    private static lalr_state start_state;
    private static lalr_item start_itm;

    public lalr_state(lalr_item_set itms) throws internal_error {
        if (itms == null) {
            throw new internal_error("Attempt to construct an LALR state from a null item set");
        }
        if (lalr_state.find_state(itms) != null) {
            throw new internal_error("Attempt to construct a duplicate LALR state");
        }
        this._index = next_index++;
        this._items = itms;
        _all.put(this._items, this);
    }

    public static Iterable<lalr_state> all_states() {
        return _all.values();
    }

    public static void clear() {
        _all.clear();
        _all_kernels.clear();
        next_index = 0;
    }

    public static int number() {
        return _all.size();
    }

    public static lalr_state find_state(lalr_item_set itms) {
        if (itms == null) {
            return null;
        }
        return _all.get(itms);
    }

    public lalr_item_set items() {
        return this._items;
    }

    public lalr_transition transitions() {
        return this._transitions;
    }

    public int index() {
        return this._index;
    }

    protected static void dump_state(lalr_state st) throws internal_error {
        if (st == null) {
            System.out.println("NULL lalr_state");
            return;
        }
        System.out.println("lalr_state [" + st.index() + "] {");
        lalr_item_set itms = st.items();
        for (lalr_item itm : itms) {
            System.out.print("  [");
            System.out.print(itm.the_production().lhs().the_symbol().name());
            System.out.print(" ::= ");
            for (int i = 0; i < itm.the_production().rhs_length(); ++i) {
                production_part part;
                if (i == itm.dot_pos()) {
                    System.out.print("(*) ");
                }
                if ((part = itm.the_production().rhs(i)).is_action()) {
                    System.out.print("{action} ");
                    continue;
                }
                System.out.print(((symbol_part)part).the_symbol().name() + " ");
            }
            if (itm.dot_at_end()) {
                System.out.print("(*) ");
            }
            System.out.println("]");
        }
        System.out.println("}");
    }

    protected static void propagate_all_lookaheads() throws internal_error {
        for (lalr_state st : lalr_state.all_states()) {
            st.propagate_lookaheads();
        }
    }

    public void add_transition(symbol on_sym, lalr_state to_st) throws internal_error {
        lalr_transition trans;
        this._transitions = trans = new lalr_transition(on_sym, to_st, this._transitions);
    }

    public static lalr_state build_machine(production start_prod) throws internal_error {
        Stack<lalr_state> work_stack = new Stack<lalr_state>();
        if (start_prod == null) {
            throw new internal_error("Attempt to build viable prefix recognizer using a null production");
        }
        lalr_item_set start_items = new lalr_item_set();
        start_itm = new lalr_item(start_prod);
        start_itm.lookahead().add(terminal.EOF);
        start_items.add(start_itm);
        lalr_item_set kernel = new lalr_item_set(start_items);
        start_items.compute_closure();
        start_state = new lalr_state(start_items);
        work_stack.push(start_state);
        _all_kernels.put(kernel, start_state);
        while (!work_stack.empty()) {
            lalr_state st = (lalr_state)work_stack.pop();
            symbol_set outgoing = new symbol_set();
            for (lalr_item itm : st.items()) {
                symbol sym2 = itm.symbol_after_dot();
                if (sym2 == null) continue;
                outgoing.add(sym2);
            }
            for (symbol s : outgoing) {
                lalr_item_set linked_items = new lalr_item_set();
                lalr_item_set new_items = new lalr_item_set();
                for (lalr_item itm : st.items()) {
                    symbol sym2 = itm.symbol_after_dot();
                    if (!s.equals(sym2)) continue;
                    new_items.add(itm.shift());
                    linked_items.add(itm);
                }
                kernel = new lalr_item_set(new_items);
                lalr_state new_st = _all_kernels.get(kernel);
                if (new_st == null) {
                    new_items.compute_closure();
                    new_st = new lalr_state(new_items);
                    work_stack.push(new_st);
                    _all_kernels.put(kernel, new_st);
                } else {
                    for (lalr_item fix_itm : linked_items) {
                        for (int l = 0; l < fix_itm.propagate_items().size(); ++l) {
                            lalr_item new_itm = (lalr_item)fix_itm.propagate_items().elementAt(l);
                            lalr_item existing = new_st.items().find(new_itm);
                            if (existing == null) continue;
                            fix_itm.propagate_items().setElementAt(existing, l);
                        }
                    }
                }
                st.add_transition(s, new_st);
            }
        }
        lalr_state.propagate_all_lookaheads();
        return start_state;
    }

    protected void propagate_lookaheads() throws internal_error {
        for (lalr_item itm : this.items()) {
            itm.propagate_lookaheads(null);
        }
    }

    public void build_table_entries(parse_action_table act_table, parse_reduce_table reduce_table) throws internal_error {
        parse_action act;
        terminal_set conflict_set = new terminal_set();
        parse_action_row our_act_row = act_table.under_state[this.index()];
        parse_reduce_row our_red_row = reduce_table.under_state[this.index()];
        for (lalr_item itm : this.items()) {
            if (!itm.dot_at_end()) continue;
            act = new reduce_action(itm.the_production());
            for (int t = 0; t < terminal.number(); ++t) {
                if (!itm.lookahead().contains(t)) continue;
                if (our_act_row.under_term[t].kind() == 0) {
                    our_act_row.under_term[t] = act;
                    continue;
                }
                terminal term = terminal.find(t);
                parse_action other_act = our_act_row.under_term[t];
                if (other_act.kind() != 1 && other_act.kind() != 3) {
                    if (itm.the_production().index() < ((reduce_action)other_act).reduce_with().index()) {
                        our_act_row.under_term[t] = act;
                    }
                } else if (this.fix_with_precedence(itm.the_production(), t, our_act_row, act)) {
                    term = null;
                }
                if (term == null) continue;
                conflict_set.add(term);
            }
        }
        for (lalr_transition trans = this.transitions(); trans != null; trans = trans.next()) {
            symbol sym2 = trans.on_symbol();
            if (!sym2.is_non_term()) {
                act = new shift_action(trans.to_state());
                if (our_act_row.under_term[sym2.index()].kind() == 0) {
                    our_act_row.under_term[sym2.index()] = act;
                    continue;
                }
                production p = ((reduce_action)our_act_row.under_term[sym2.index()]).reduce_with();
                if (this.fix_with_precedence(p, sym2.index(), our_act_row, act)) continue;
                our_act_row.under_term[sym2.index()] = act;
                conflict_set.add(terminal.find(sym2.index()));
                continue;
            }
            our_red_row.under_non_term[sym2.index()] = trans.to_state();
        }
        if (!conflict_set.empty()) {
            this.report_conflicts(conflict_set);
        }
    }

    protected boolean fix_with_precedence(production p, int term_index, parse_action_row table_row, parse_action act) throws internal_error {
        terminal term = terminal.find(term_index);
        if (p.precedence_num() > -1) {
            if (p.precedence_num() > term.precedence_num()) {
                table_row.under_term[term_index] = this.insert_reduce(table_row.under_term[term_index], act);
                return true;
            }
            if (p.precedence_num() < term.precedence_num()) {
                table_row.under_term[term_index] = this.insert_shift(table_row.under_term[term_index], act);
                return true;
            }
            if (term.precedence_side() == 1) {
                table_row.under_term[term_index] = this.insert_shift(table_row.under_term[term_index], act);
                return true;
            }
            if (term.precedence_side() == 0) {
                table_row.under_term[term_index] = this.insert_reduce(table_row.under_term[term_index], act);
                return true;
            }
            if (term.precedence_side() == 2) {
                table_row.under_term[term_index] = new nonassoc_action();
                return true;
            }
            throw new internal_error("Unable to resolve conflict correctly");
        }
        if (term.precedence_num() > -1) {
            table_row.under_term[term_index] = this.insert_shift(table_row.under_term[term_index], act);
            return true;
        }
        return false;
    }

    protected parse_action insert_action(parse_action a1, parse_action a2, int act_type) throws internal_error {
        if (a1.kind() == act_type && a2.kind() == act_type) {
            throw new internal_error("Conflict resolution of bogus actions");
        }
        if (a1.kind() == act_type) {
            return a1;
        }
        if (a2.kind() == act_type) {
            return a2;
        }
        throw new internal_error("Conflict resolution of bogus actions");
    }

    protected parse_action insert_shift(parse_action a1, parse_action a2) throws internal_error {
        return this.insert_action(a1, a2, 1);
    }

    protected parse_action insert_reduce(parse_action a1, parse_action a2) throws internal_error {
        return this.insert_action(a1, a2, 2);
    }

    protected void report_conflicts(terminal_set conflict_set) throws internal_error {
        for (lalr_item itm : this.items()) {
            if (!itm.dot_at_end()) continue;
            boolean after_itm = false;
            for (lalr_item compare : this.items()) {
                if (itm == compare) {
                    after_itm = true;
                }
                if (itm == compare || !compare.dot_at_end() || !after_itm || !compare.lookahead().intersects(itm.lookahead())) continue;
                this.report_reduce_reduce(itm, compare);
            }
            for (int t = 0; t < terminal.number(); ++t) {
                if (!conflict_set.contains(t)) continue;
                this.report_shift_reduce(itm, t);
            }
        }
    }

    private void errOutput(StringBuilder sb, ByteArrayOutputStream s) {
        try {
            sb.append(s.toString("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            sb.append("<UNENCODABLE>");
        }
    }

    protected void report_reduce_reduce(lalr_item itm1, lalr_item itm2) throws internal_error {
        boolean comma_flag = false;
        StringBuilder message = new StringBuilder("*** Reduce/Reduce conflict found in state #");
        message.append(this.index());
        message.append("\n  between ");
        message.append(itm1.to_simple_string());
        message.append("\n");
        ByteArrayOutputStream ds = new ByteArrayOutputStream();
        if (Main.report_counterexamples) {
            message.append("    Example:    ");
            this.report_shortest_path(itm1, message, new PrintStream(ds));
            message.append(" (*)\n    Derivation: ");
            this.errOutput(message, ds);
            message.append(" ] (*)\n\n");
        }
        message.append("  and     ");
        message.append(itm2.to_simple_string());
        message.append("\n");
        ds.reset();
        if (Main.report_counterexamples) {
            message.append("    Example:    ");
            this.report_shortest_path(itm2, message, new PrintStream(ds));
            message.append(" (*)\n    Derivation: ");
            this.errOutput(message, ds);
            message.append(" ] (*)\n");
        }
        message.append("  under symbols: {");
        for (int t = 0; t < terminal.number(); ++t) {
            if (!itm1.lookahead().contains(t) || !itm2.lookahead().contains(t)) continue;
            if (comma_flag) {
                message.append(", ");
            } else {
                comma_flag = true;
            }
            message.append(terminal.find(t).name());
        }
        message.append("}\n  Resolved in favor of ");
        if (itm1.the_production().index() < itm2.the_production().index()) {
            message.append("the first production.\n");
        } else {
            message.append("the second production.\n");
        }
        ++emit.num_conflicts;
        ErrorManager.getManager().emit_warning(message.toString());
    }

    protected void report_shift_reduce(lalr_item red_itm, int conflict_sym) throws internal_error {
        StringBuilder message = new StringBuilder("*** Shift/Reduce conflict found in state #");
        message.append(this.index());
        message.append("\n  between reduction on ");
        message.append(red_itm.to_simple_string());
        message.append("\n");
        ByteArrayOutputStream ds = new ByteArrayOutputStream();
        if (Main.report_counterexamples) {
            message.append("    Example:    ");
            this.report_shortest_path(red_itm, message, new PrintStream(ds));
            message.append(" (*) ");
            message.append(terminal.find(conflict_sym).name());
            message.append("\n    Derivation: ");
            this.errOutput(message, ds);
            message.append(" ] (*) ");
            message.append(terminal.find(conflict_sym).name());
            message.append("\n\n");
        }
        for (lalr_item itm : this.items()) {
            symbol shift_sym;
            if (itm == red_itm || itm.dot_at_end() || (shift_sym = itm.symbol_after_dot()).is_non_term() || shift_sym.index() != conflict_sym) continue;
            message.append("  and shift on ");
            message.append(itm.to_simple_string());
            message.append("\n");
            if (!Main.report_counterexamples) continue;
            ds.reset();
            message.append("    Example:    ");
            this.report_shortest_path(itm, message, new PrintStream(ds));
            message.append(" (*) ");
            message.append(this.right_of_dot(itm));
            message.append("\n    Derivation: ");
            this.errOutput(message, ds);
            message.append(" (*) ");
            message.append(this.right_of_dot(itm));
            message.append("\n\n");
        }
        message.append("  under symbol ");
        message.append(terminal.find(conflict_sym).name());
        message.append("\n  Resolved in favor of shifting.\n");
        ++emit.num_conflicts;
        ErrorManager.getManager().emit_warning(message.toString());
    }

    protected void report_shortest_path(lalr_item itm, StringBuilder example_s, PrintStream derivation_s) throws internal_error {
        Path p = this.shortest_path(itm);
        boolean first = true;
        for (Step s : p.steps) {
            s.appendToReport(example_s, derivation_s, first);
            first = false;
        }
    }

    protected Path shortest_path(lalr_item itm) throws internal_error {
        HashSet<StateItem> visited = new HashSet<StateItem>();
        LinkedList<Path> active = new LinkedList<Path>();
        StateItem start = new StateItem(start_state, start_itm);
        Path p = new Path(new LinkedList<Step>(), start);
        active.add(p);
        while (!active.isEmpty()) {
            Path p1 = (Path)active.removeFirst();
            StateItem si = p1.last;
            if (visited.contains(si)) continue;
            visited.add(si);
            lalr_state s = si.state;
            lalr_item i = si.item;
            if (this.equals(s) && itm.equals(i)) {
                p = p1;
                return p;
            }
            for (lalr_transition tr = s.transitions(); tr != null; tr = tr.next()) {
                if (!tr.on_symbol().equals(i.symbol_after_dot())) continue;
                lalr_item i2 = i.shift();
                LinkedList<Step> newt = new LinkedList<Step>(p1.steps);
                newt.add(new TransStep(tr));
                Path p2 = new Path(newt, new StateItem(tr.to_state(), i2));
                active.add(p2);
            }
            non_terminal nt = i.dot_before_nt();
            if (nt == null) continue;
            for (production prod : nt.productions()) {
                terminal_set new_lookaheads = i.calc_lookahead(i.lookahead());
                lalr_item i2 = new lalr_item(prod, new terminal_set(new_lookaheads));
                LinkedList<Step> newt = new LinkedList<Step>(p1.steps);
                newt.add(new ProdStep(prod));
                Path p2 = new Path(newt, new StateItem(s, i2));
                active.add(p2);
            }
        }
        return null;
    }

    String right_of_dot(lalr_item itm) throws internal_error {
        int pos;
        String result = "";
        production prod = itm.the_production();
        for (int i = pos = itm.dot_pos(); i < prod.rhs_length(); ++i) {
            production_part pp;
            if (i != pos) {
                result = result + " ";
            }
            if (!((pp = prod.rhs(i)) instanceof symbol_part)) continue;
            result = result + ((symbol_part)pp).the_symbol().name();
        }
        return result;
    }

    public boolean equals(lalr_state other) {
        return other != null && this.items().equals(other.items());
    }

    public boolean equals(Object other) {
        if (!(other instanceof lalr_state)) {
            return false;
        }
        return this.equals((lalr_state)other);
    }

    public int hashCode() {
        return this.items().hashCode();
    }

    public String toString() {
        String result = "lalr_state [" + this.index() + "]: " + this._items + "\n";
        for (lalr_transition tr = this.transitions(); tr != null; tr = tr.next()) {
            result = result + tr;
            result = result + "\n";
        }
        return result;
    }

    private static class StateItem {
        lalr_state state;
        lalr_item item;

        StateItem(lalr_state s, lalr_item i) {
            this.state = s;
            this.item = i;
        }

        public boolean equals(Object o) {
            StateItem si2 = (StateItem)o;
            return this.state.equals(si2.state) && this.item.equals(si2.item);
        }

        public int hashCode() {
            return this.state.hashCode() + this.item.hashCode();
        }
    }

    private static class Path {
        LinkedList<Step> steps;
        StateItem last;

        Path(LinkedList<Step> t, StateItem si) {
            this.steps = t;
            this.last = si;
        }
    }

    private static class ProdStep
    implements Step {
        private production prod;

        public ProdStep(production pr) {
            this.prod = pr;
        }

        @Override
        public void appendToReport(StringBuilder example_s, PrintStream derivation_s, boolean first) {
            if (!first) {
                derivation_s.print(" ");
            }
            derivation_s.print("[" + this.prod.lhs().the_symbol().name() + "::=");
        }
    }

    private static class TransStep
    implements Step {
        lalr_transition trans;

        public TransStep(lalr_transition tr) {
            this.trans = tr;
        }

        @Override
        public void appendToReport(StringBuilder example_s, PrintStream derivation_s, boolean first) {
            String name = this.trans.on_symbol().name();
            if (!first) {
                derivation_s.print(" ");
                example_s.append(" ");
            }
            example_s.append(name);
            derivation_s.print(name);
        }
    }

    private static interface Step {
        public void appendToReport(StringBuilder var1, PrintStream var2, boolean var3);
    }
}

