/*
 * Decompiled with CFR 0.152.
 */
package ppg.lex;

import java.io.IOException;
import java.io.Reader;
import ppg.lex.LexicalError;
import ppg.lex.Token;

public class Lexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int COMMENT = 2;
    public static final int STRING = 4;
    public static final int CODE = 6;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3};
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0003\u0001\u0005\u0001\u0006\u0001\u0005\u0001\u0005\u0012\u0000\u0001\u000b\u0001\n\u0001\u0013\u0002\n\u00012\u0004\n\u0001\u0007\u0001\n\u0001*\u0001\n\u0001)\u0001\u0004\n\u0002\u0001\b\u0001(\u0001.\u0001'\u0001/\u00010\u0001\u0012\r\u0001\u0001\r\f\u0001\u0001,\u0001\f\u0001-\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u001f\u0001\u0001\u0001\u0015\u0001\u0018\u0001\u0019\u0001!\u0001#\u0001&\u0001\u0014\u0001\u0001\u0001\"\u0001\u0016\u0001$\u0001\u000e\u0001\u001c\u0001\u001d\u0001\u0001\u0001\u001b\u0001 \u0001\u000f\u0001\u0017\u0001\u001e\u0001%\u0001\u001a\u0002\u0001\u0001+\u00011\u0001\t\u0001\u0012\u0006\u0000\u0001\u0006\u1fa2\u0000\u0001\u0006\u0001\u0006\udfd6\u0000";
    private static final char[] ZZ_CMAP = Lexer.zzUnpackCMap("\t\u0000\u0001\u0003\u0001\u0005\u0001\u0006\u0001\u0005\u0001\u0005\u0012\u0000\u0001\u000b\u0001\n\u0001\u0013\u0002\n\u00012\u0004\n\u0001\u0007\u0001\n\u0001*\u0001\n\u0001)\u0001\u0004\n\u0002\u0001\b\u0001(\u0001.\u0001'\u0001/\u00010\u0001\u0012\r\u0001\u0001\r\f\u0001\u0001,\u0001\f\u0001-\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u001f\u0001\u0001\u0001\u0015\u0001\u0018\u0001\u0019\u0001!\u0001#\u0001&\u0001\u0014\u0001\u0001\u0001\"\u0001\u0016\u0001$\u0001\u000e\u0001\u001c\u0001\u001d\u0001\u0001\u0001\u001b\u0001 \u0001\u000f\u0001\u0017\u0001\u001e\u0001%\u0001\u001a\u0002\u0001\u0001+\u00011\u0001\t\u0001\u0012\u0006\u0000\u0001\u0006\u1fa2\u0000\u0001\u0006\u0001\u0006\udfd6\u0000");
    private static final int[] ZZ_ACTION = Lexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0002\u0000\u0001\u0001\u0001\u0000\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0002\u0001\u0005\u0001\u0006\u0001\u0007\u0002\u0003\u0001\b\u000b\u0003\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0002\u0001\u0013\u0001\u0000\u0001\u0013\u0001\u0014\u0001\u0001\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0000\u0001\u0017\u0001\u0004\u0001\u0018\u0001\u0000\u0003\u0003\u0001\u0019\u000e\u0003\u0001\u001a\u0002\u0000\u0001\u001b\u0004\u0000\u0001\u001c\u0001\u001d\u0001\u001e\u0012\u0003\u0002\u0000\u0004\u0003\u0001\u001f\u0003\u0003\u0001 \u0001!\u0001\"\b\u0003\u0001#\u0001$\u0001\u0000\b\u0003\u0001%\u0005\u0003\u0001&\u0001'\u0006\u0003\u0001(\u0001)\u0003\u0003\u0001*\u0001+\u0004\u0003\u0001,\u0001\u0003\u0001-\u0002\u0003\u0001.\u0001\u0003\u0001/\u00010\u00011\u0001\u0003\u00012\u0005\u0003\u00013\u00014\u00015";
    private static final int[] ZZ_ROWMAP = Lexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u00003\u0000f\u0000\u0099\u0000\u00cc\u0000\u00ff\u0000\u0132\u0000\u0165\u0000\u00cc\u0000\u0198\u0000\u00cc\u0000\u01cb\u0000\u01fe\u0000\u00cc\u0000\u0231\u0000\u0264\u0000\u0297\u0000\u02ca\u0000\u02fd\u0000\u0330\u0000\u0363\u0000\u0396\u0000\u03c9\u0000\u03fc\u0000\u042f\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u0462\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u0495\u0000\u04c8\u0000\u04c8\u0000\u04fb\u0000\u00cc\u0000\u052e\u0000\u0561\u0000\u00cc\u0000\u0594\u0000\u0594\u0000\u05c7\u0000\u05fa\u0000\u00cc\u0000\u062d\u0000\u0660\u0000\u0693\u0000\u06c6\u0000\u00ff\u0000\u06f9\u0000\u072c\u0000\u075f\u0000\u0792\u0000\u07c5\u0000\u07f8\u0000\u082b\u0000\u085e\u0000\u0891\u0000\u08c4\u0000\u08f7\u0000\u092a\u0000\u095d\u0000\u0990\u0000\u00cc\u0000\u09c3\u0000\u04fb\u0000\u00cc\u0000\u09f6\u0000\u0a29\u0000\u0a5c\u0000\u05c7\u0000\u00cc\u0000\u00cc\u0000\u0a8f\u0000\u0ac2\u0000\u0af5\u0000\u0b28\u0000\u0b5b\u0000\u0b8e\u0000\u0bc1\u0000\u0bf4\u0000\u0c27\u0000\u0c5a\u0000\u0c8d\u0000\u0cc0\u0000\u0cf3\u0000\u0d26\u0000\u0d59\u0000\u0d8c\u0000\u0dbf\u0000\u0df2\u0000\u0e25\u0000\u0e58\u0000\u0e8b\u0000\u0ebe\u0000\u0ef1\u0000\u0f24\u0000\u0f57\u0000\u00ff\u0000\u0f8a\u0000\u0fbd\u0000\u0ff0\u0000\u00ff\u0000\u00ff\u0000\u00ff\u0000\u1023\u0000\u1056\u0000\u1089\u0000\u10bc\u0000\u10ef\u0000\u1122\u0000\u1155\u0000\u1188\u0000\u00ff\u0000\u00ff\u0000\u11bb\u0000\u11ee\u0000\u1221\u0000\u1254\u0000\u1287\u0000\u12ba\u0000\u12ed\u0000\u1320\u0000\u1353\u0000\u00ff\u0000\u1386\u0000\u13b9\u0000\u13ec\u0000\u141f\u0000\u1452\u0000\u00ff\u0000\u00cc\u0000\u1485\u0000\u14b8\u0000\u14eb\u0000\u151e\u0000\u1551\u0000\u1584\u0000\u00ff\u0000\u15b7\u0000\u15ea\u0000\u161d\u0000\u1650\u0000\u00ff\u0000\u00ff\u0000\u1683\u0000\u16b6\u0000\u16e9\u0000\u171c\u0000\u00ff\u0000\u174f\u0000\u00ff\u0000\u1782\u0000\u17b5\u0000\u00ff\u0000\u17e8\u0000\u00ff\u0000\u00ff\u0000\u00ff\u0000\u181b\u0000\u00ff\u0000\u184e\u0000\u1881\u0000\u18b4\u0000\u18e7\u0000\u191a\u0000\u00ff\u0000\u00ff\u0000\u00ff";
    private static final int[] ZZ_TRANS = Lexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0005\u0001\u0006\u0001\u0005\u0001\u0007\u0001\b\u0001\u0007\u0001\u0000\u0001\t\u0001\n\u0001\u000b\u0001\u0005\u0001\u0007\u0001\u0005\u0001\u0006\u0001\f\u0001\r\u0003\u0005\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0006\u0001\u0012\u0001\u0013\u0001\u0006\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0006\u0001\u0017\u0001\u0018\u0004\u0006\u0001\u0019\u0001\u0006\u0001\u0005\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u001d\u0001\u001e\u0001\u001f\u0001 \u0001!\u0001\"\u0001#\u0001$\u0005%\u0002&\u0001'+%\u0001(\u0002)\u0001(\u0001)\u0002\u0000\u0005)\u0001*\u0006)\u0001+\u001f)\u0005,\u0002-\u0001,\u0001.*,4\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0013\u0006\u000f\u0000\u0001\u0007\u0001\u0000\u0001\u0007\u0005\u0000\u0001\u0007+\u0000\u0001/\u0002\u0000\u000103\u0000\u00011+\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\b\u0006\u00012\n\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0005\u0006\u00013\u0001\u0006\u00014\u00015\n\u0006\r\u0000\u0002\u0006\n\u0000\u0001\u0006\u00016\u0001\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0010\u0006\u00017\u0002\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\b\u0006\u00018\n\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0005\u0006\u00019\r\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0007\u0006\u0001:\u000b\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0006\u0006\u0001;\f\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0001<\u0012\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\n\u0006\u0001=\b\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0007\u0006\u0001>\u0003\u0006\u0001?\u0007\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0001\u0006\u0001@\u0011\u0006\r\u0000\u0002\u0006\n\u0000\u0002\u0006\u0001A\u0001\u0000\u0001\u0006\u0002\u0000\u0001\u0006\u0001B\u0011\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0001C\u0012\u0006\u0014\u0000\u0001DG\u0000\u0001E\u0015\u0000\u0007&\u0001F/&\u0001G\u0002&\u0001F+&\u0001\u0000\u0002)\u0001\u0000\u0001)\u0002\u0000\u0005)\u0001*\u0006)\u0001+\u001f)\u0002\u0000\u0001H\u0001I\u0001\u0000\u0001I\u0005\u0000\u0001I\u0004)\u0001J\u0002\u0000\u0001)\u001f\u0000\b-\u0001K2-\u0001K\u0001L)-\u0005/\u0002\u0000,/'\u0000\u0001M\f\u0000\u0002\u0006\n\u0000\u0001\u0006\u0001N\u0001\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0013\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0007\u0006\u0001O\u000b\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u000b\u0006\u0001P\u0007\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0001Q\u0001R\u0011\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\t\u0006\u0001S\t\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0004\u0006\u0001T\u000e\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\r\u0006\u0001U\u0005\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\b\u0006\u0001V\n\u0006\r\u0000\u0002\u0006\n\u0000\u0002\u0006\u0001W\u0001\u0000\u0001\u0006\u0002\u0000\u0013\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u000f\u0006\u0001X\u0003\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0005\u0006\u0001Y\r\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0005\u0006\u0001Z\r\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0001\u0006\u0001[\u0005\u0006\u0001\\\u000b\u0006\r\u0000\u0002\u0006\n\u0000\u0002\u0006\u0001]\u0001\u0000\u0001\u0006\u0002\u0000\u0013\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u000b\u0006\u0001^\u0007\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u000b\u0006\u0001_\u0007\u0006\r\u0000\u0002\u0006\n\u0000\u0002\u0006\u0001`\u0001\u0000\u0001\u0006\u0002\u0000\u0013\u0006'\u0000\u0001a\u0019\u0000\u0001b3\u0000\u0001I\u0001\u0000\u0001I\u0005\u0000\u0001I\u0001)'\u0000\u0001)\u0007\u0000\u0001)\u0002\u0000\u0007)\u0001\u0000\u0013)\u0004\u0000\u0003)\u0003\u0000\u0001)\u0002\u0000\u0002\u0006\n\u0000\u0002\u0006\u0001c\u0001\u0000\u0001\u0006\u0002\u0000\u000b\u0006\u0001d\u0007\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0010\u0006\u0001e\u0002\u0006\r\u0000\u0002\u0006\n\u0000\u0001\u0006\u0001f\u0001\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0013\u0006\r\u0000\u0002\u0006\n\u0000\u0002\u0006\u0001g\u0001\u0000\u0001\u0006\u0002\u0000\u0013\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0002\u0006\u0001h\u0010\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0002\u0006\u0001i\u0005\u0006\u0001j\n\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0005\u0006\u0001k\r\u0006\r\u0000\u0002\u0006\n\u0000\u0002\u0006\u0001l\u0001\u0000\u0001\u0006\u0002\u0000\u0013\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\t\u0006\u0001m\t\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0005\u0006\u0001n\r\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0012\u0006\u0001o\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0007\u0006\u0001p\u000b\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0001\u0006\u0001q\u0011\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u000e\u0006\u0001r\u0004\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\f\u0006\u0001s\u0006\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0001t\u0012\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0007\u0006\u0001u\u000b\u0006\r\u0000\u0002\u0006\n\u0000\u0001\u0006\u0001v\u0001\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0013\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0012\u0006\u0001w%\u0000\u0001x\u001b\u0000\u0001)1\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0005\u0006\u0001y\r\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\f\u0006\u0001z\u0006\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0001{\u0012\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\f\u0006\u0001|\u0006\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0003\u0006\u0001}\u000f\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0005\u0006\u0001~\r\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0007\u0006\u0001\u007f\u000b\u0006\r\u0000\u0002\u0006\n\u0000\u0001\u0006\u0001\u0080\u0001\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0013\u0006\r\u0000\u0002\u0006\n\u0000\u0002\u0006\u0001\u0081\u0001\u0000\u0001\u0006\u0002\u0000\u0013\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0007\u0006\u0001\u0082\u000b\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0005\u0006\u0001\u0083\r\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u000b\u0006\u0001\u0084\u0007\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0005\u0006\u0001\u0085\r\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\b\u0006\u0001\u0086\n\u0006\r\u0000\u0002\u0006\n\u0000\u0002\u0006\u0001\u0087\u0001\u0000\u0001\u0006\u0002\u0000\u0013\u0006!\u0000\u0001\u0088\u001e\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0007\u0006\u0001\u0089\u000b\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\f\u0006\u0001\u008a\u0006\u0006\r\u0000\u0002\u0006\n\u0000\u0001\u0006\u0001\u008b\u0001\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0013\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\r\u0006\u0001\u008c\u0005\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0004\u0006\u0001\u008d\u000e\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0010\u0006\u0001\u008e\u0002\u0006\r\u0000\u0002\u0006\n\u0000\u0002\u0006\u0001\u008f\u0001\u0000\u0001\u0006\u0002\u0000\u0013\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0004\u0006\u0001\u0090\u000e\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0001\u0091\u0012\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0004\u0006\u0001\u0092\u000e\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u000f\u0006\u0001\u0093\u0003\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0007\u0006\u0001\u0094\u000b\u0006\r\u0000\u0002\u0006\n\u0000\u0001\u0006\u0001\u0095\u0001\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0013\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0010\u0006\u0001\u0096\u0002\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\b\u0006\u0001\u0097\n\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u000b\u0006\u0001\u0098\u0007\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0005\u0006\u0001\u0099\r\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0005\u0006\u0001\u009a\r\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0005\u0006\u0001\u009b\r\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\f\u0006\u0001\u009c\u0006\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0004\u0006\u0001\u009d\u000e\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0005\u0006\u0001\u009e\r\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0005\u0006\u0001\u009f\r\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0001\u00a0\u0012\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0001\u0006\u0001\u00a1\u0011\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0002\u0006\u0001\u00a2\u0010\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0007\u0006\u0001\u00a3\u000b\u0006\r\u0000\u0002\u0006\n\u0000\u0001\u0006\u0001\u00a4\u0001\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0013\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0005\u0006\u0001\u00a5\r\u0006\r\u0000\u0002\u0006\n\u0000\u0001\u0006\u0001\u00a6\u0001\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0013\u0006\r\u0000\u0002\u0006\n\u0000\u0001\u0006\u0001\u00a7\u0001\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0013\u0006\r\u0000\u0002\u0006\n\u0000\u0002\u0006\u0001\u00a8\u0001\u0000\u0001\u0006\u0002\u0000\u0013\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0001\u0006\u0001\u00a9\u0011\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u000b\u0006\u0001\u00aa\u0007\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\f\u0006\u0001\u00ab\u0006\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0005\u0006\u0001\u00ac\r\u0006\r\u0000\u0002\u0006\n\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0002\u0006\u0001\u00ad\u0010\u0006\f\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = Lexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0002\u0000\u0001\u0001\u0001\u0000\u0001\t\u0003\u0001\u0001\t\u0001\u0001\u0001\t\u0002\u0001\u0001\t\u000b\u0001\u0003\t\u0001\u0001\u0006\t\u0002\u0001\u0001\u0000\u0001\u0001\u0001\t\u0002\u0001\u0001\t\u0001\u0001\u0001\u0000\u0002\u0001\u0001\t\u0001\u0000\u0012\u0001\u0001\t\u0002\u0000\u0001\t\u0004\u0000\u0002\t\u0013\u0001\u0002\u0000\u0015\u0001\u0001\u0000\u000f\u0001\u0001\t%\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private String filename = "";

    private static int[] zzUnpackAction() {
        int[] result = new int[173];
        int offset = 0;
        offset = Lexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[173];
        int offset = 0;
        offset = Lexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[6477];
        int offset = 0;
        offset = Lexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[173];
        int offset = 0;
        offset = Lexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public Lexer(Reader in, String filename) {
        this(in);
        this.filename = filename;
    }

    private void error(String message) throws LexicalError {
        throw new LexicalError(this.filename, this.yyline + 1, message);
    }

    private Token t(int id, Object value) {
        return new Token(id, this.filename, this.yyline + 1, this.yychar, this.yychar + this.yylength(), value);
    }

    private Token t(int id) {
        return this.t(id, this.yytext());
    }

    public Lexer(Reader in) {
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 142) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public Token getToken() throws IOException, LexicalError {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block112: while (true) {
            int zzInput;
            boolean eof;
            int zzCurrentPosL;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            boolean zzR = false;
            block113: for (zzCurrentPosL = this.zzStartRead; zzCurrentPosL < zzMarkedPosL; ++zzCurrentPosL) {
                switch (zzBufferL[zzCurrentPosL]) {
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        ++this.yyline;
                        zzR = false;
                        continue block113;
                    }
                    case '\r': {
                        ++this.yyline;
                        zzR = true;
                        continue block113;
                    }
                    case '\n': {
                        if (zzR) {
                            zzR = false;
                            continue block113;
                        }
                        ++this.yyline;
                        continue block113;
                    }
                    default: {
                        zzR = false;
                    }
                }
            }
            if (zzR) {
                boolean zzPeek;
                if (zzMarkedPosL < zzEndReadL) {
                    zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                } else if (this.zzAtEOF) {
                    zzPeek = false;
                } else {
                    eof = this.zzRefill();
                    zzEndReadL = this.zzEndRead;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    if (eof) {
                        zzPeek = false;
                    } else {
                        boolean bl = zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                    }
                }
                if (zzPeek) {
                    --this.yyline;
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    this.error("Unclosed string literal");
                }
                case 54: {
                    continue block112;
                }
                case 2: {
                    this.error("Invalid character: " + this.yytext());
                }
                case 55: {
                    continue block112;
                }
                case 3: {
                    return this.t(40, this.yytext().intern());
                }
                case 56: {
                    continue block112;
                }
                case 4: 
                case 57: {
                    continue block112;
                }
                case 5: {
                    return this.t(34);
                }
                case 58: {
                    continue block112;
                }
                case 6: {
                    return this.t(12);
                }
                case 59: {
                    continue block112;
                }
                case 7: {
                    return this.t(7);
                }
                case 60: {
                    continue block112;
                }
                case 8: {
                    this.yybegin(4);
                }
                case 61: {
                    continue block112;
                }
                case 9: {
                    return this.t(11);
                }
                case 62: {
                    continue block112;
                }
                case 10: {
                    return this.t(18);
                }
                case 63: {
                    continue block112;
                }
                case 11: {
                    return this.t(10);
                }
                case 64: {
                    continue block112;
                }
                case 12: {
                    return this.t(6);
                }
                case 65: {
                    continue block112;
                }
                case 13: {
                    return this.t(19);
                }
                case 66: {
                    continue block112;
                }
                case 14: {
                    return this.t(20);
                }
                case 67: {
                    continue block112;
                }
                case 15: {
                    return this.t(21);
                }
                case 68: {
                    continue block112;
                }
                case 16: {
                    return this.t(22);
                }
                case 69: {
                    continue block112;
                }
                case 17: {
                    return this.t(23);
                }
                case 70: {
                    continue block112;
                }
                case 18: {
                    return this.t(14);
                }
                case 71: {
                    continue block112;
                }
                case 19: {
                    this.error("Illegal comment");
                }
                case 72: {
                    continue block112;
                }
                case 20: {
                    this.error("Illegal character in string literal: " + this.yytext());
                }
                case 73: {
                    continue block112;
                }
                case 21: {
                    this.error("Illegal escape character");
                }
                case 74: {
                    continue block112;
                }
                case 22: {
                    this.yybegin(0);
                    String literal = this.yytext();
                    return this.t(39, literal.substring(0, literal.length() - 1));
                }
                case 75: {
                    continue block112;
                }
                case 23: {
                    this.error("Invalid character in code block: '" + this.yytext() + "'");
                }
                case 76: {
                    continue block112;
                }
                case 24: {
                    this.yybegin(2);
                }
                case 77: {
                    continue block112;
                }
                case 25: {
                    return this.t(3);
                }
                case 78: {
                    continue block112;
                }
                case 26: {
                    this.yybegin(6);
                }
                case 79: {
                    continue block112;
                }
                case 27: {
                    this.yybegin(0);
                }
                case 80: {
                    continue block112;
                }
                case 28: {
                    this.yybegin(0);
                    String codeStr = this.yytext();
                    return this.t(41, codeStr.substring(0, codeStr.length() - 2));
                }
                case 81: {
                    continue block112;
                }
                case 29: {
                    return this.t(13);
                }
                case 82: {
                    continue block112;
                }
                case 30: {
                    return this.t(29);
                }
                case 83: {
                    continue block112;
                }
                case 31: {
                    return this.t(30);
                }
                case 84: {
                    continue block112;
                }
                case 32: {
                    return this.t(26);
                }
                case 85: {
                    continue block112;
                }
                case 33: {
                    return this.t(36);
                }
                case 86: {
                    continue block112;
                }
                case 34: {
                    return this.t(4);
                }
                case 87: {
                    continue block112;
                }
                case 35: {
                    return this.t(31);
                }
                case 88: {
                    continue block112;
                }
                case 36: {
                    return this.t(32);
                }
                case 89: {
                    continue block112;
                }
                case 37: {
                    return this.t(37);
                }
                case 90: {
                    continue block112;
                }
                case 38: {
                    return this.t(33);
                }
                case 91: {
                    continue block112;
                }
                case 39: {
                    return this.t(17);
                }
                case 92: {
                    continue block112;
                }
                case 40: {
                    return this.t(25);
                }
                case 93: {
                    continue block112;
                }
                case 41: {
                    return this.t(42);
                }
                case 94: {
                    continue block112;
                }
                case 42: {
                    return this.t(28);
                }
                case 95: {
                    continue block112;
                }
                case 43: {
                    return this.t(27);
                }
                case 96: {
                    continue block112;
                }
                case 44: {
                    return this.t(2);
                }
                case 97: {
                    continue block112;
                }
                case 45: {
                    return this.t(8);
                }
                case 98: {
                    continue block112;
                }
                case 46: {
                    return this.t(24);
                }
                case 99: {
                    continue block112;
                }
                case 47: {
                    return this.t(38);
                }
                case 100: {
                    continue block112;
                }
                case 48: {
                    return this.t(15);
                }
                case 101: {
                    continue block112;
                }
                case 49: {
                    return this.t(5);
                }
                case 102: {
                    continue block112;
                }
                case 50: {
                    return this.t(43);
                }
                case 103: {
                    continue block112;
                }
                case 51: {
                    return this.t(9);
                }
                case 104: {
                    continue block112;
                }
                case 52: {
                    return this.t(35);
                }
                case 105: {
                    continue block112;
                }
                case 53: {
                    return this.t(16);
                }
                case 106: {
                    continue block112;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return this.t(0, "EOF");
            }
            this.zzScanError(1);
        }
    }
}

