/*
 * Decompiled with CFR 0.152.
 */
package ppg.lex;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import ppg.lex.Lexer;
import ppg.lex.Token;

public class LexTest {
    private static final String HEADER = "ppg [lexertest]: ";

    public static void main(String[] args) {
        FileReader fileReader;
        String filename = null;
        try {
            filename = args[0];
            fileReader = new FileReader(filename);
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: " + filename + " is not found.");
            return;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("ppg [lexertest]: Error: No file name given.");
            return;
        }
        File f = new File(filename);
        String simpleName = f.getName();
        Lexer lex = new Lexer(fileReader, simpleName);
        Token t = null;
        try {
            while (true) {
                t = lex.getToken();
                t.unparse(System.out);
                if (t.getCode() == 0) break;
                System.out.println();
            }
            fileReader.close();
        }
        catch (Error | Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }
}

