/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import polyglot.ast.JLang;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.frontend.Job;
import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.ConstantChecker;
import polyglot.visit.DisambiguationDriver;
import polyglot.visit.NodeVisitor;

public class TypeChecker
extends DisambiguationDriver {
    protected boolean checkConstants = true;

    public TypeChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    @Override
    public JLang lang() {
        return (JLang)super.lang();
    }

    public void setCheckConstants(boolean check) {
        this.checkConstants = check;
    }

    @Override
    public Node override(Node parent, Node n) {
        try {
            if (Report.should_report("visit", 2)) {
                Report.report(2, ">> " + this + "::override " + n);
            }
            Node m = this.lang().typeCheckOverride(n, parent, this);
            if (Report.should_report("visit", 2)) {
                Report.report(2, "<< " + this + "::override " + n + " -> " + m);
            }
            return m;
        }
        catch (MissingDependencyException e) {
            if (Report.should_report("frontend", 3)) {
                e.printStackTrace();
            }
            Scheduler scheduler = this.job.extensionInfo().scheduler();
            Goal g = scheduler.currentGoal();
            scheduler.addDependencyAndEnqueue(g, e.goal(), e.prerequisite());
            g.setUnreachableThisRun();
            if (this.rethrowMissingDependencies) {
                throw e;
            }
            return n;
        }
        catch (SemanticException e) {
            if (e.getMessage() != null) {
                Position position = e.position();
                if (position == null) {
                    position = n.position();
                }
                this.errorQueue().enqueue(5, e.getMessage(), position);
            }
            return n;
        }
    }

    @Override
    protected NodeVisitor enterCall(Node n) throws SemanticException {
        if (Report.should_report("visit", 2)) {
            Report.report(2, ">> " + this + "::enter " + n);
        }
        TypeChecker v = (TypeChecker)this.lang().typeCheckEnter(n, this);
        if (Report.should_report("visit", 2)) {
            Report.report(2, "<< " + this + "::enter " + n + " -> " + v);
        }
        return v;
    }

    @Override
    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        if (Report.should_report("visit", 2)) {
            Report.report(2, ">> " + this + "::leave " + n);
        }
        AmbChecker ac = new AmbChecker(this.lang());
        this.lang().visitChildren(n, ac);
        Node m = n;
        if (!ac.amb && m.isDisambiguated()) {
            TypeChecker childTc = (TypeChecker)v;
            m = this.lang().typeCheck(m, childTc);
            if (this.checkConstants) {
                ConstantChecker cc = new ConstantChecker(this.job, this.ts, this.nf);
                cc = (ConstantChecker)cc.context(childTc.context());
                m = this.lang().checkConstants(m, cc);
            }
        } else {
            Goal g = this.job.extensionInfo().scheduler().currentGoal();
            g.setUnreachableThisRun();
        }
        if (Report.should_report("visit", 2)) {
            Report.report(2, "<< " + this + "::leave " + n + " -> " + m);
        }
        return m;
    }

    protected static class AmbChecker
    extends NodeVisitor {
        public boolean amb;

        public AmbChecker(JLang lang) {
            super(lang);
        }

        @Override
        public Node override(Node n) {
            if (!n.isDisambiguated() || !n.isTypeChecked()) {
                this.amb = true;
            }
            return n;
        }
    }
}

