/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.Block;
import polyglot.ast.CompoundStmt;
import polyglot.ast.Initializer;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.frontend.Job;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.visit.CFGBuilder;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;

public class ReachChecker
extends DataFlow<DataFlowItem> {
    public ReachChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf, true, true);
    }

    @Override
    protected CFGBuilder<DataFlowItem> createCFGBuilder(TypeSystem ts, FlowGraph<DataFlowItem> g) {
        CFGBuilder<DataFlowItem> v = new CFGBuilder<DataFlowItem>(this.lang(), ts, g, this);
        v = v.skipDeadLoopBodies(true);
        return v;
    }

    @Override
    public DataFlowItem createInitialItem(FlowGraph<DataFlowItem> graph, Term node, boolean entry) {
        if (node == graph.root() && entry) {
            return DataFlowItem.REACHABLE;
        }
        return DataFlowItem.NOT_REACHABLE;
    }

    @Override
    public Map<FlowGraph.EdgeKey, DataFlowItem> flow(DataFlowItem in, FlowGraph<DataFlowItem> graph, FlowGraph.Peer<DataFlowItem> peer) {
        Set<FlowGraph.EdgeKey> succEdgeKeys = peer.succEdgeKeys();
        if (in == DataFlowItem.NOT_REACHABLE) {
            return ReachChecker.itemToMap(in, succEdgeKeys);
        }
        Map<FlowGraph.EdgeKey, DataFlowItem> m = ReachChecker.itemToMap(DataFlowItem.REACHABLE_EX_ONLY, succEdgeKeys);
        if (succEdgeKeys.contains(FlowGraph.EDGE_KEY_OTHER)) {
            m.put(FlowGraph.EDGE_KEY_OTHER, DataFlowItem.REACHABLE);
        }
        if (succEdgeKeys.contains(FlowGraph.EDGE_KEY_TRUE)) {
            m.put(FlowGraph.EDGE_KEY_TRUE, DataFlowItem.REACHABLE);
        }
        if (succEdgeKeys.contains(FlowGraph.EDGE_KEY_FALSE)) {
            m.put(FlowGraph.EDGE_KEY_FALSE, DataFlowItem.REACHABLE);
        }
        return m;
    }

    @Override
    public DataFlowItem confluence(List<DataFlowItem> inItems, FlowGraph.Peer<DataFlowItem> peer, FlowGraph<DataFlowItem> graph) {
        throw new InternalCompilerError("Should never be called.");
    }

    @Override
    public DataFlowItem confluence(List<DataFlowItem> inItems, List<FlowGraph.EdgeKey> itemKeys, FlowGraph.Peer<DataFlowItem> peer, FlowGraph<DataFlowItem> graph) {
        List<DataFlowItem> l = this.filterItemsNonException(inItems, itemKeys);
        for (DataFlowItem i : l) {
            if (i != DataFlowItem.REACHABLE) continue;
            return DataFlowItem.REACHABLE;
        }
        for (DataFlowItem i : inItems) {
            if (!i.reachable) continue;
            return DataFlowItem.REACHABLE_EX_ONLY;
        }
        return DataFlowItem.NOT_REACHABLE;
    }

    @Override
    public Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        if (n instanceof Term && !((Term)(n = this.checkReachability((Term)n))).reachable() && (n instanceof Block && ((Block)n).statements().isEmpty() || n instanceof Stmt && !(n instanceof CompoundStmt))) {
            throw new SemanticException("Unreachable statement.", n.position());
        }
        return super.leaveCall(old, n, v);
    }

    protected Node checkReachability(Term n) throws SemanticException {
        Collection peers;
        FlowGraph g = this.currentFlowGraph();
        if (g != null && (peers = g.peers(n, 0)) != null && !peers.isEmpty()) {
            boolean isReachable = false;
            boolean isNormalReachable = false;
            block0: for (FlowGraph.Peer p : peers) {
                if (p.inItem() != null) {
                    DataFlowItem dfi = (DataFlowItem)p.inItem();
                    if (dfi.reachable) {
                        isReachable = true;
                    }
                    if (dfi.normalReachable) {
                        isNormalReachable = true;
                        break;
                    }
                }
                if (p.outItems == null) continue;
                for (DataFlowItem item : p.outItems.values()) {
                    if (item == null || !item.reachable) continue;
                    isReachable = true;
                    continue block0;
                }
            }
            if (!isNormalReachable && n instanceof Initializer) {
                throw new SemanticException("Initializers must be able to complete normally.", n.position());
            }
            n = n.reachable(isReachable);
        }
        return n;
    }

    @Override
    public void post(FlowGraph<DataFlowItem> graph, Term root) throws SemanticException {
        if (Report.should_report("cfg", 2)) {
            this.dumpFlowGraph(graph, root);
        }
    }

    @Override
    public void check(FlowGraph<DataFlowItem> graph, Term n, boolean entry, DataFlowItem inItem, Map<FlowGraph.EdgeKey, DataFlowItem> outItems) throws SemanticException {
        throw new InternalCompilerError("ReachChecker.check should never be called.");
    }

    protected static class DataFlowItem
    extends DataFlow.Item {
        public final boolean reachable;
        public final boolean normalReachable;
        public static final DataFlowItem REACHABLE = new DataFlowItem(true, true);
        public static final DataFlowItem REACHABLE_EX_ONLY = new DataFlowItem(true, false);
        public static final DataFlowItem NOT_REACHABLE = new DataFlowItem(false, false);

        protected DataFlowItem(boolean reachable, boolean normalReachable) {
            this.reachable = reachable;
            this.normalReachable = normalReachable;
        }

        public String toString() {
            return (this.reachable ? "" : "not ") + "reachable" + (this.normalReachable ? "" : " by exceptions only");
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof DataFlowItem) {
                return this.reachable == ((DataFlowItem)o).reachable && this.normalReachable == ((DataFlowItem)o).normalReachable;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.reachable ? 5423 : 5753) + (this.normalReachable ? 31 : -2);
        }
    }
}

