/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import polyglot.ast.Assign;
import polyglot.ast.Cast;
import polyglot.ast.Expr;
import polyglot.ast.FieldDecl;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.types.Type;
import polyglot.util.Position;
import polyglot.visit.NodeVisitor;

public class MakeNarrowingAssignmentsExplicit
extends NodeVisitor {
    private NodeFactory nf;

    public MakeNarrowingAssignmentsExplicit(NodeFactory nf) {
        super(nf.lang());
        this.nf = nf;
    }

    private Expr rewriteRHS(Type toType, Expr r) {
        Type rt = r.type();
        if (this.lang().isConstant(r, this.lang()) && rt.isIntOrLess() && (toType.isByte() || toType.isShort() || toType.isChar())) {
            Position pos = r.position();
            Cast c = (Cast)this.nf.Cast(pos, this.nf.CanonicalTypeNode(pos, toType), r).type(toType);
            return c;
        }
        return r;
    }

    @Override
    public Node leave(Node old, Node n, NodeVisitor v) {
        if (n instanceof FieldDecl && ((FieldDecl)n).init() != null) {
            FieldDecl fd = (FieldDecl)n;
            return fd.init(this.rewriteRHS(fd.declType(), fd.init()));
        }
        if (n instanceof LocalDecl && ((LocalDecl)n).init() != null) {
            LocalDecl ld = (LocalDecl)n;
            return ld.init(this.rewriteRHS(ld.declType(), ld.init()));
        }
        if (n instanceof Assign && Assign.ASSIGN.equals(((Assign)n).operator())) {
            Assign a = (Assign)n;
            return a.right(this.rewriteRHS(a.left().type(), a.right()));
        }
        return n;
    }
}

