/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import polyglot.ast.ConstructorCall;
import polyglot.ast.Expr;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.visit.InnerClassAbstractRemover;
import polyglot.visit.NodeVisitor;

public class InnerClassConstructorFixer
extends InnerClassAbstractRemover {
    public InnerClassConstructorFixer(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    @Override
    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        ArrayList<Expr> newArgs;
        ClassType ct;
        if (n instanceof New) {
            New newExp = (New)n;
            ct = (ClassType)newExp.objectType().type();
            newArgs = new ArrayList<Expr>(newExp.arguments());
            newArgs.addAll(this.envAsActuals(this.env(ct, true), ct.outer(), newExp.qualifier()));
            newExp = newExp.arguments(newArgs);
            newExp = newExp.qualifier(null);
            newExp = newExp.qualifierImplicit(true);
            n = newExp;
        }
        if (n instanceof ConstructorCall) {
            ConstructorCall cc = (ConstructorCall)n;
            ct = this.context.currentClass();
            if (cc.kind() == ConstructorCall.THIS) {
                newArgs = new ArrayList();
                newArgs.addAll(cc.arguments());
                newArgs.addAll(this.envAsActuals(this.env(ct, true), ct.outer(), cc.qualifier()));
                ConstructorCall newCC = (ConstructorCall)cc.arguments(newArgs);
                newCC = newCC.qualifier(null);
                n = newCC;
            } else {
                newArgs = new ArrayList();
                newArgs.addAll(cc.arguments());
                ClassType sup = (ClassType)ct.superType();
                if (sup.isInnerClass()) {
                    newArgs.addAll(this.envAsActuals(this.env(sup, true), sup.outer(), cc.qualifier()));
                } else {
                    newArgs.addAll(this.envAsActuals(this.env(sup, true), null, null));
                }
                ConstructorCall newCC = (ConstructorCall)cc.arguments(newArgs);
                newCC = newCC.qualifier(null);
                n = newCC;
            }
        }
        n = super.leaveCall(old, n, v);
        return n;
    }
}

