/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.CompoundStmt;
import polyglot.ast.Do;
import polyglot.ast.Empty;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.For;
import polyglot.ast.If;
import polyglot.ast.JLang;
import polyglot.ast.Local;
import polyglot.ast.LocalAssign;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Stmt;
import polyglot.ast.Switch;
import polyglot.ast.Term;
import polyglot.ast.Unary;
import polyglot.ast.While;
import polyglot.frontend.Job;
import polyglot.main.Report;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Pair;
import polyglot.util.Position;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;
import polyglot.visit.HaltingVisitor;
import polyglot.visit.NodeVisitor;

public class DeadCodeEliminator
extends DataFlow<DataFlowItem> {
    public DeadCodeEliminator(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf, false, true);
    }

    @Override
    public DataFlowItem createInitialItem(FlowGraph<DataFlowItem> graph, Term node, boolean entry) {
        return new DataFlowItem();
    }

    @Override
    public DataFlowItem confluence(List<DataFlowItem> inItems, FlowGraph.Peer<DataFlowItem> peer, FlowGraph<DataFlowItem> graph) {
        return this.confluence(inItems);
    }

    public DataFlowItem confluence(List<DataFlowItem> inItems) {
        DataFlowItem result = null;
        for (DataFlowItem inItem : inItems) {
            if (result == null) {
                result = new DataFlowItem(inItem);
                continue;
            }
            result.union(inItem);
        }
        return result;
    }

    @Override
    public Map<FlowGraph.EdgeKey, DataFlowItem> flow(DataFlowItem in, FlowGraph<DataFlowItem> graph, FlowGraph.Peer<DataFlowItem> peer) {
        DataFlowItem result = new DataFlowItem(in);
        if (peer.isEntry()) {
            return DeadCodeEliminator.itemToMap(result, peer.succEdgeKeys());
        }
        Term t = peer.node();
        Pair<Set<LocalInstance>, Set<LocalInstance>> du = null;
        if (t instanceof LocalDecl) {
            LocalDecl n = (LocalDecl)t;
            LocalInstance to = n.localInstance();
            result.removeDecl(to);
            du = this.getDefUse(n.init());
        } else if (t instanceof Stmt && !(t instanceof CompoundStmt)) {
            du = this.getDefUse(t);
        } else if (t instanceof CompoundStmt) {
            if (t instanceof If) {
                du = this.getDefUse(((If)t).cond());
            } else if (t instanceof Switch) {
                du = this.getDefUse(((Switch)t).expr());
            } else if (t instanceof Do) {
                du = this.getDefUse(((Do)t).cond());
            } else if (t instanceof For) {
                du = this.getDefUse(((For)t).cond());
            } else if (t instanceof While) {
                du = this.getDefUse(((While)t).cond());
            }
        }
        if (du != null) {
            result.removeAll(du.part1());
            result.addAll(du.part2());
        }
        return DeadCodeEliminator.itemToMap(result, peer.succEdgeKeys());
    }

    @Override
    public void post(FlowGraph<DataFlowItem> graph, Term root) throws SemanticException {
        if (Report.should_report("cfg", 2)) {
            this.dumpFlowGraph(graph, root);
        }
    }

    @Override
    public void check(FlowGraph<DataFlowItem> graph, Term n, boolean entry, DataFlowItem inItem, Map<FlowGraph.EdgeKey, DataFlowItem> outItems) throws SemanticException {
        throw new InternalCompilerError("DeadCodeEliminator.check should never be called.");
    }

    private DataFlowItem getItem(Term n) {
        FlowGraph g = this.currentFlowGraph();
        if (g == null) {
            return null;
        }
        Collection peers = g.peers(n, 0);
        if (peers == null || peers.isEmpty()) {
            return null;
        }
        ArrayList<DataFlowItem> items = new ArrayList<DataFlowItem>();
        for (FlowGraph.Peer p : peers) {
            if (p.inItem() == null) continue;
            items.add((DataFlowItem)p.inItem());
        }
        return this.confluence(items);
    }

    @Override
    public Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        if (n instanceof LocalDecl) {
            LocalDecl ld = (LocalDecl)n;
            DataFlowItem in = this.getItem(ld);
            if (in == null || in.needDecl(ld.localInstance())) {
                return n;
            }
            return this.getEffects(ld.init());
        }
        if (n instanceof Eval) {
            Local local;
            Eval eval = (Eval)n;
            Expr expr = eval.expr();
            Expr right = null;
            if (expr instanceof Assign) {
                Assign assign = (Assign)expr;
                Expr left = assign.left();
                right = assign.right();
                if (!(left instanceof Local)) {
                    return n;
                }
                local = (Local)left;
            } else if (expr instanceof Unary) {
                Unary unary = (Unary)expr;
                if (!((expr = unary.expr()) instanceof Local)) {
                    return n;
                }
                local = (Local)expr;
            } else {
                return n;
            }
            DataFlowItem in = this.getItem(eval);
            if (in == null || in.needDef(local.localInstance().orig())) {
                return n;
            }
            if (right != null) {
                return this.getEffects(right);
            }
            return this.nf.Empty(Position.compilerGenerated());
        }
        if (n instanceof Block) {
            Block b = (Block)n;
            ArrayList<Stmt> stmts = new ArrayList<Stmt>(b.statements());
            Iterator it = stmts.iterator();
            while (it.hasNext()) {
                if (!(it.next() instanceof Empty)) continue;
                it.remove();
            }
            return b.statements(stmts);
        }
        return n;
    }

    protected Pair<Set<LocalInstance>, Set<LocalInstance>> getDefUse(Node n) {
        HashSet<LocalInstance> def = new HashSet<LocalInstance>();
        HashSet<LocalInstance> use = new HashSet<LocalInstance>();
        if (n != null) {
            n.visit(this.createDefUseFinder(def, use));
        }
        return new Pair<Set<LocalInstance>, Set<LocalInstance>>(def, use);
    }

    protected NodeVisitor createDefUseFinder(Set<LocalInstance> def, Set<LocalInstance> use) {
        return new DefUseFinder(this.lang(), def, use);
    }

    protected Stmt getEffects(Expr expr) {
        Empty empty = this.nf.Empty(Position.compilerGenerated());
        if (expr == null) {
            return empty;
        }
        final LinkedList<Stmt> result = new LinkedList<Stmt>();
        final Position pos = Position.compilerGenerated();
        HaltingVisitor v = new HaltingVisitor(this.lang()){

            @Override
            public NodeVisitor enter(Node n) {
                Unary.Operator op;
                if (n instanceof Assign || n instanceof ProcedureCall) {
                    return this.bypassChildren(n);
                }
                if (n instanceof Unary && ((op = ((Unary)n).operator()) == Unary.POST_INC || op == Unary.POST_DEC || op == Unary.PRE_INC || op == Unary.PRE_INC)) {
                    return this.bypassChildren(n);
                }
                return this;
            }

            @Override
            public Node leave(Node old, Node n, NodeVisitor v) {
                Unary.Operator op;
                if (n instanceof Assign || n instanceof ProcedureCall) {
                    result.add(DeadCodeEliminator.this.nf.Eval(pos, (Expr)n));
                } else if (n instanceof Unary && ((op = ((Unary)n).operator()) == Unary.POST_INC || op == Unary.POST_DEC || op == Unary.PRE_INC || op == Unary.PRE_INC)) {
                    result.add(DeadCodeEliminator.this.nf.Eval(pos, (Expr)n));
                }
                return n;
            }
        };
        expr.visit(v);
        if (result.isEmpty()) {
            return empty;
        }
        if (result.size() == 1) {
            return (Stmt)result.get(0);
        }
        return this.nf.Block(Position.compilerGenerated(), result);
    }

    protected static class DefUseFinder
    extends HaltingVisitor {
        protected Set<LocalInstance> def;
        protected Set<LocalInstance> use;

        public DefUseFinder(JLang lang, Set<LocalInstance> def, Set<LocalInstance> use) {
            super(lang);
            this.def = def;
            this.use = use;
        }

        @Override
        public NodeVisitor enter(Node n) {
            if (n instanceof LocalAssign) {
                return this.bypass(((Assign)n).left());
            }
            return super.enter(n);
        }

        @Override
        public Node leave(Node old, Node n, NodeVisitor v) {
            Expr left;
            if (n instanceof Local) {
                this.use.add(((Local)n).localInstance().orig());
            } else if (n instanceof Assign && (left = ((Assign)n).left()) instanceof Local) {
                this.def.add(((Local)left).localInstance().orig());
            }
            return n;
        }
    }

    protected static class DataFlowItem
    extends DataFlow.Item {
        private Set<LocalInstance> liveVars;
        private Set<LocalInstance> liveDecls;

        protected DataFlowItem() {
            this.liveVars = new HashSet<LocalInstance>();
            this.liveDecls = new HashSet<LocalInstance>();
        }

        protected DataFlowItem(DataFlowItem dfi) {
            this.liveVars = new HashSet<LocalInstance>(dfi.liveVars);
            this.liveDecls = new HashSet<LocalInstance>(dfi.liveDecls);
        }

        public void add(LocalInstance li) {
            this.liveVars.add(li);
            this.liveDecls.add(li);
        }

        public void addAll(Set<LocalInstance> lis) {
            this.liveVars.addAll(lis);
            this.liveDecls.addAll(lis);
        }

        public void remove(LocalInstance li) {
            this.liveVars.remove(li);
        }

        public void removeAll(Set<LocalInstance> lis) {
            this.liveVars.removeAll(lis);
        }

        public void removeDecl(LocalInstance li) {
            this.liveVars.remove(li);
            this.liveDecls.remove(li);
        }

        public void union(DataFlowItem dfi) {
            this.liveVars.addAll(dfi.liveVars);
            this.liveDecls.addAll(dfi.liveDecls);
        }

        protected boolean needDecl(LocalInstance li) {
            return this.liveDecls.contains(li);
        }

        protected boolean needDef(LocalInstance li) {
            return this.liveVars.contains(li);
        }

        @Override
        public int hashCode() {
            int result = 0;
            for (LocalInstance li : this.liveVars) {
                result = 31 * result + li.hashCode();
            }
            for (LocalInstance li : this.liveDecls) {
                result = 31 * result + li.hashCode();
            }
            return result;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof DataFlowItem)) {
                return false;
            }
            DataFlowItem dfi = (DataFlowItem)o;
            return this.liveVars.equals(dfi.liveVars) && this.liveDecls.equals(dfi.liveDecls);
        }

        public String toString() {
            return "<vars=" + this.liveVars + " ; decls=" + this.liveDecls + ">";
        }
    }
}

