/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.frontend.Job;
import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.main.Report;
import polyglot.types.Context;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.visit.ErrorHandlingVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PruningVisitor;

public class ContextVisitor
extends ErrorHandlingVisitor {
    protected ContextVisitor outer = null;
    protected boolean rethrowMissingDependencies = false;
    protected Context context = null;
    protected boolean prune;

    public ContextVisitor(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    public ContextVisitor rethrowMissingDependencies(boolean rethrow) {
        if (rethrow == this.rethrowMissingDependencies) {
            return this;
        }
        ContextVisitor cv = (ContextVisitor)this.copy();
        cv.rethrowMissingDependencies = rethrow;
        return cv;
    }

    @Override
    public NodeVisitor begin() {
        this.context = this.ts.createContext();
        this.outer = null;
        return super.begin();
    }

    public Context context() {
        return this.context;
    }

    public ContextVisitor context(Context c) {
        ContextVisitor v = (ContextVisitor)this.copy();
        v.context = c;
        return v;
    }

    protected Context enterScope(Node parent, Node n) {
        if (parent != null) {
            return this.lang().enterChildScope(parent, n, this.context);
        }
        return this.lang().enterScope(n, this.context);
    }

    protected void addDecls(Node old, Node n) {
        this.addDecls(n);
    }

    protected void addDecls(Node n) {
        this.lang().addDecls(n, this.context);
    }

    @Override
    public final NodeVisitor enter(Node n) {
        throw new InternalCompilerError("Cannot call enter(Node n) on a ContextVisitor; use enter(Node parent, Node n) instead");
    }

    @Override
    public final NodeVisitor enter(Node parent, Node n) {
        if (Report.should_report("visit", 5)) {
            Report.report(5, "enter(" + n + ")");
        }
        if (this.prune) {
            return new PruningVisitor(this.lang());
        }
        try {
            ContextVisitor v = this;
            Context c = this.enterScope(parent, n);
            if (c != this.context) {
                v = (ContextVisitor)this.copy();
                v.context = c;
                v.outer = this;
                v.error = false;
            }
            return v.superEnter(parent, n);
        }
        catch (MissingDependencyException e) {
            if (Report.should_report("frontend", 3)) {
                e.printStackTrace();
            }
            Scheduler scheduler = this.job.extensionInfo().scheduler();
            Goal g = scheduler.currentGoal();
            scheduler.addDependencyAndEnqueue(g, e.goal(), e.prerequisite());
            g.setUnreachableThisRun();
            this.prune = true;
            if (this.rethrowMissingDependencies) {
                throw e;
            }
            return new PruningVisitor(this.lang());
        }
    }

    public NodeVisitor superEnter(Node parent, Node n) {
        return super.enter(parent, n);
    }

    @Override
    public final Node leave(Node parent, Node old, Node n, NodeVisitor v) {
        if (v instanceof PruningVisitor || this.prune) {
            return n;
        }
        try {
            Node m = super.leave(parent, old, n, v);
            this.addDecls(old, m);
            return m;
        }
        catch (MissingDependencyException e) {
            if (Report.should_report("frontend", 3)) {
                e.printStackTrace();
            }
            Scheduler scheduler = this.job.extensionInfo().scheduler();
            Goal g = scheduler.currentGoal();
            scheduler.addDependencyAndEnqueue(g, e.goal(), e.prerequisite());
            g.setUnreachableThisRun();
            if (this.rethrowMissingDependencies) {
                throw e;
            }
            return n;
        }
    }
}

