/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.FieldDecl;
import polyglot.ast.IntLit;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.TypeNode;
import polyglot.main.Report;
import polyglot.main.Version;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.InitializerInstance;
import polyglot.types.TypeSystem;
import polyglot.util.ErrorQueue;
import polyglot.util.Position;
import polyglot.util.TypeEncoder;
import polyglot.visit.NodeVisitor;

public class ClassSerializer
extends NodeVisitor {
    private static final int MAX_ENCODED_TYPE_INFO_STRING_LENGTH = 8192;
    protected TypeEncoder te;
    protected ErrorQueue eq;
    protected long time;
    protected TypeSystem ts;
    protected NodeFactory nf;
    protected Version ver;

    public ClassSerializer(TypeSystem ts, NodeFactory nf, long time, ErrorQueue eq, Version ver) {
        super(nf.lang());
        this.ts = ts;
        this.nf = nf;
        this.te = new TypeEncoder(ts);
        this.eq = eq;
        this.time = time;
        this.ver = ver;
    }

    @Override
    public Node override(Node n) {
        if (n instanceof ClassMember && !(n instanceof ClassDecl)) {
            return n;
        }
        return null;
    }

    @Override
    public Node leave(Node old, Node n, NodeVisitor v) {
        if (!(n instanceof ClassDecl)) {
            return n;
        }
        ClassDecl cd = (ClassDecl)n;
        ClassBody body = cd.body();
        List<ClassMember> l = this.createSerializationMembers(cd);
        for (ClassMember m : l) {
            body = body.addMember(m);
        }
        return cd.body(body);
    }

    public List<ClassMember> createSerializationMembers(ClassDecl cd) {
        return this.createSerializationMembers(cd.type());
    }

    public List<ClassMember> createSerializationMembers(ClassType ct) {
        try {
            ArrayList<ClassMember> newMembers = new ArrayList<ClassMember>(3);
            ct.memberClasses();
            ct.constructors();
            ct.methods();
            ct.fields();
            ct.interfaces();
            ct.superType();
            if (!ct.isTopLevel() && !ct.isMember()) {
                return Collections.emptyList();
            }
            String suffix = this.ver.name();
            if (ct.fieldNamed("jlc$CompilerVersion$" + suffix) != null || ct.fieldNamed("jlc$SourceLastModified$" + suffix) != null || ct.fieldNamed("jlc$ClassType$" + suffix) != null) {
                this.eq.enqueue(5, "Cannot serialize class information more than once.");
                return Collections.emptyList();
            }
            Flags flags = Flags.PUBLIC.set(Flags.STATIC).set(Flags.FINAL);
            String version = this.ver.major() + "." + this.ver.minor() + "." + this.ver.patch_level();
            Position pos = Position.compilerGenerated();
            FieldInstance fi = this.ts.fieldInstance(pos, ct, flags, this.ts.String(), "jlc$CompilerVersion$" + suffix);
            fi.setConstantValue(version);
            InitializerInstance ii = this.ts.initializerInstance(pos, ct, Flags.STATIC);
            FieldDecl f = this.nf.FieldDecl(fi.position(), fi.flags(), (TypeNode)this.nf.CanonicalTypeNode(fi.position(), fi.type()), this.nf.Id(fi.position(), fi.name()), this.nf.StringLit(pos, version).type(this.ts.String()));
            f = f.fieldInstance(fi);
            f = f.initializerInstance(ii);
            newMembers.add(f);
            fi = this.ts.fieldInstance(pos, ct, flags, this.ts.Long(), "jlc$SourceLastModified$" + suffix);
            fi.setConstantValue(new Long(this.time));
            ii = this.ts.initializerInstance(pos, ct, Flags.STATIC);
            f = this.nf.FieldDecl(fi.position(), fi.flags(), (TypeNode)this.nf.CanonicalTypeNode(fi.position(), fi.type()), this.nf.Id(fi.position(), fi.name()), this.nf.IntLit(pos, IntLit.LONG, this.time).type(this.ts.Long()));
            f = f.fieldInstance(fi);
            f = f.initializerInstance(ii);
            newMembers.add(f);
            String encodedTypeInfo = this.te.encode(ct);
            int etiStart = 0;
            int etiEnd = 0;
            int numberETIFields = 0;
            do {
                if ((etiEnd = encodedTypeInfo.length()) - etiStart > 8192) {
                    etiEnd = etiStart + 8192;
                }
                String additionalFieldSuffix = numberETIFields == 0 ? "" : "$" + numberETIFields;
                String encoded = encodedTypeInfo.substring(etiStart, etiEnd);
                fi = this.ts.fieldInstance(pos, ct, flags, this.ts.String(), "jlc$ClassType$" + suffix + additionalFieldSuffix);
                fi.setConstantValue(encoded);
                ii = this.ts.initializerInstance(pos, ct, Flags.STATIC);
                f = this.nf.FieldDecl(fi.position(), fi.flags(), (TypeNode)this.nf.CanonicalTypeNode(fi.position(), fi.type()), this.nf.Id(fi.position(), fi.name()), this.nf.StringLit(pos, encoded).type(this.ts.String()));
                f = f.fieldInstance(fi);
                f = f.initializerInstance(ii);
                newMembers.add(f);
                ++numberETIFields;
                etiStart = etiEnd;
            } while (etiEnd != encodedTypeInfo.length());
            return newMembers;
        }
        catch (IOException e) {
            if (Report.should_report("serialize", 1)) {
                e.printStackTrace();
            }
            this.eq.enqueue(2, "Unable to serialize class information: " + e.getMessage());
            return Collections.emptyList();
        }
    }
}

