/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Branch;
import polyglot.ast.Catch;
import polyglot.ast.CodeNode;
import polyglot.ast.CompoundStmt;
import polyglot.ast.JLang;
import polyglot.ast.Labeled;
import polyglot.ast.Loop;
import polyglot.ast.Return;
import polyglot.ast.Stmt;
import polyglot.ast.Switch;
import polyglot.ast.Term;
import polyglot.ast.Try;
import polyglot.main.Report;
import polyglot.types.MemberInstance;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CollectionUtil;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;
import polyglot.util.StringUtil;
import polyglot.visit.CFGBuildError;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;

public class CFGBuilder<FlowItem extends DataFlow.Item>
implements Copy<CFGBuilder<FlowItem>> {
    private final JLang lang;
    protected FlowGraph<FlowItem> graph;
    protected TypeSystem ts;
    protected CFGBuilder<FlowItem> outer;
    protected Stmt innermostTarget;
    protected List<Term> path_to_finally;
    protected DataFlow<FlowItem> df;
    protected boolean skipInnermostCatches;
    protected boolean skipDeadIfBranches = false;
    protected boolean skipDeadLoopBodies = false;
    protected boolean errorEdgesToExitNode = false;
    protected boolean trackImplicitErrors = false;
    protected boolean exceptionEdgesToFinally;
    protected static int counter = 0;

    public CFGBuilder(JLang lang, TypeSystem ts, FlowGraph<FlowItem> graph, DataFlow<FlowItem> df) {
        this.lang = lang;
        this.ts = ts;
        this.graph = graph;
        this.df = df;
        this.path_to_finally = Collections.emptyList();
        this.outer = null;
        this.innermostTarget = null;
        this.skipInnermostCatches = false;
        this.errorEdgesToExitNode = false;
        this.exceptionEdgesToFinally = false;
    }

    public JLang lang() {
        return this.lang;
    }

    public FlowGraph<FlowItem> graph() {
        return this.graph;
    }

    public DataFlow<FlowItem> dataflow() {
        return this.df;
    }

    public CFGBuilder<FlowItem> outer() {
        return this.outer;
    }

    public Stmt innermostTarget() {
        return this.innermostTarget;
    }

    public boolean skipInnermostCatches() {
        return this.skipInnermostCatches;
    }

    public TypeSystem typeSystem() {
        return this.ts;
    }

    @Override
    public CFGBuilder<FlowItem> copy() {
        try {
            CFGBuilder clone = (CFGBuilder)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalCompilerError("Java clone() weirdness.");
        }
    }

    public CFGBuilder<FlowItem> push(Stmt n) {
        return this.push(n, false);
    }

    public CFGBuilder<FlowItem> push(Stmt n, boolean skipInnermostCatches) {
        Object v = this.copy();
        ((CFGBuilder)v).outer = this;
        ((CFGBuilder)v).innermostTarget = n;
        ((CFGBuilder)v).skipInnermostCatches = skipInnermostCatches;
        return v;
    }

    public void visitBranchTarget(Branch b) {
        FlowGraph.Peer<FlowItem> last_peer = this.graph.peer(b, this.path_to_finally, 0);
        CFGBuilder<FlowItem> v = this;
        while (v != null) {
            CompoundStmt l;
            Try tr;
            Stmt c = v.innermostTarget;
            if (c instanceof Try && (tr = (Try)c).finallyBlock() != null) {
                last_peer = CFGBuilder.tryFinally(v, last_peer, last_peer.node == b, tr.finallyBlock());
            }
            if (b.label() != null) {
                if (c instanceof Labeled && (l = (Labeled)c).label().equals(b.label())) {
                    if (b.kind() == Branch.BREAK) {
                        this.edge(last_peer, this.graph().peer(l, this.path_to_finally, 0), FlowGraph.EDGE_KEY_OTHER);
                    } else {
                        Stmt s = l.statement();
                        if (s instanceof Loop) {
                            Loop loop = (Loop)s;
                            this.edge(last_peer, this.graph().peer(this.lang().continueTarget(loop), this.path_to_finally, 1), FlowGraph.EDGE_KEY_OTHER);
                        } else {
                            throw new CFGBuildError("Target of continue statement must be a loop.", l.position());
                        }
                    }
                    return;
                }
            } else {
                if (c instanceof Loop) {
                    l = (Loop)c;
                    if (b.kind() == Branch.CONTINUE) {
                        this.edge(last_peer, this.graph().peer(this.lang().continueTarget((Loop)l), this.path_to_finally, 1), FlowGraph.EDGE_KEY_OTHER);
                    } else {
                        this.edge(last_peer, this.graph().peer(l, this.path_to_finally, 0), FlowGraph.EDGE_KEY_OTHER);
                    }
                    return;
                }
                if (c instanceof Switch && b.kind() == Branch.BREAK) {
                    this.edge(last_peer, this.graph().peer(c, this.path_to_finally, 0), FlowGraph.EDGE_KEY_OTHER);
                    return;
                }
            }
            v = v.outer;
        }
        throw new CFGBuildError("Target of branch statement not found.", b.position());
    }

    public void visitReturn(Return r) {
        FlowGraph.Peer<FlowItem> last_peer = this.graph().peer(r, this.path_to_finally, 0);
        CFGBuilder<FlowItem> v = this;
        while (v != null) {
            Try tr;
            Stmt c = v.innermostTarget;
            if (c instanceof Try && (tr = (Try)c).finallyBlock() != null) {
                last_peer = CFGBuilder.tryFinally(v, last_peer, last_peer.node == r, tr.finallyBlock());
            }
            v = v.outer;
        }
        this.edge(last_peer, this.exitPeer(), FlowGraph.EDGE_KEY_OTHER);
    }

    public void visitGraph() {
        String name = StringUtil.getShortNameComponent(this.df.getClass().getName());
        name = name + counter++;
        if (Report.should_report("cfg", 2)) {
            String rootName = "";
            if (this.graph.root() instanceof CodeNode) {
                CodeNode cd = (CodeNode)this.graph.root();
                rootName = cd.codeInstance().toString();
                if (cd.codeInstance() instanceof MemberInstance) {
                    rootName = rootName + " in " + ((MemberInstance)((Object)cd.codeInstance())).container().toString();
                }
            }
            Report.report(2, "digraph CFGBuild" + name + " {");
            Report.report(2, "  label=\"CFGBuilder: " + name + "\\n" + rootName + "\"; fontsize=20; center=true; ratio=auto; size = \"8.5,11\";");
        }
        this.entryPeer();
        this.exitPeer();
        this.visitCFG(this.graph.root(), Collections.emptyList());
        if (Report.should_report("cfg", 2)) {
            Report.report(2, "}");
        }
    }

    protected FlowGraph.Peer<FlowItem> entryPeer() {
        return this.graph.peer(this.graph.root(), Collections.emptyList(), 1);
    }

    protected FlowGraph.Peer<FlowItem> exitPeer() {
        return this.graph.peer(this.graph.root(), Collections.emptyList(), 0);
    }

    public void visitCFGList(List<? extends Term> elements, Term after, int entry) {
        Term prev = null;
        for (Term term : elements) {
            if (prev != null) {
                this.visitCFG(prev, term, 1);
            }
            prev = term;
        }
        if (prev != null) {
            this.visitCFG(prev, after, entry);
        }
    }

    public void visitCFG(Term a, Term succ, int entry) {
        this.visitCFG(a, FlowGraph.EDGE_KEY_OTHER, succ, entry);
    }

    public void visitCFG(Term a, FlowGraph.EdgeKey edgeKey, Term succ, int entry) {
        this.visitCFG(a, CollectionUtil.list(new EdgeKeyTermPair(edgeKey, succ, entry)));
    }

    public void visitCFG(Term a, FlowGraph.EdgeKey edgeKey1, Term succ1, int entry1, FlowGraph.EdgeKey edgeKey2, Term succ2, int entry2) {
        this.visitCFG(a, CollectionUtil.list(new EdgeKeyTermPair(edgeKey1, succ1, entry1), new EdgeKeyTermPair(edgeKey2, succ2, entry2)));
    }

    public void visitCFG(Term a, FlowGraph.EdgeKey edgeKey, List<Term> succ, int entry) {
        ArrayList<EdgeKeyTermPair> l = new ArrayList<EdgeKeyTermPair>(succ.size());
        for (Term t : succ) {
            l.add(new EdgeKeyTermPair(edgeKey, t, entry));
        }
        this.visitCFG(a, l);
    }

    public void visitCFG(Term a, FlowGraph.EdgeKey edgeKey, List<Term> succ, List<Integer> entry) {
        if (succ.size() != entry.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<EdgeKeyTermPair> l = new ArrayList<EdgeKeyTermPair>(succ.size());
        for (int i = 0; i < succ.size(); ++i) {
            Term t = succ.get(i);
            l.add(new EdgeKeyTermPair(edgeKey, t, entry.get(i)));
        }
        this.visitCFG(a, l);
    }

    protected void visitCFG(Term a, List<EdgeKeyTermPair> succs) {
        Term child = this.lang().firstChild(a);
        if (child == null) {
            this.edge(this, a, 1, a, 0, FlowGraph.EDGE_KEY_OTHER);
        } else {
            this.edge(this, a, 1, child, 1, FlowGraph.EDGE_KEY_OTHER);
        }
        if (Report.should_report("cfg", 2)) {
            Report.report(2, "// node " + a + " -> " + succs);
        }
        succs = this.lang().acceptCFG(a, this, succs);
        for (EdgeKeyTermPair s : succs) {
            this.edge(a, s.term, s.entry, s.edgeKey);
        }
        this.visitThrow(a);
    }

    public void visitThrow(Term a) {
        for (Type type : this.lang().throwTypes(a, this.ts)) {
            this.visitThrow(a, 0, type);
        }
        if (this.trackImplicitErrors && (a instanceof Stmt && !(a instanceof CompoundStmt) || a instanceof Block && ((Block)a).statements().isEmpty())) {
            this.visitThrow(a, 0, this.ts.Error());
        }
    }

    public void visitThrow(Term t, int entry, Type type) {
        FlowGraph.Peer<FlowItem> last_peer = this.graph.peer(t, this.path_to_finally, entry);
        CFGBuilder<FlowItem> v = this;
        while (v != null) {
            Stmt c = v.innermostTarget;
            if (c instanceof Try) {
                Try tr = (Try)c;
                if (!v.skipInnermostCatches) {
                    boolean definiteCatch = false;
                    for (Catch cb : tr.catchBlocks()) {
                        if (type.isImplicitCastValid(cb.catchType())) {
                            this.edge(last_peer, this.graph.peer(cb, this.path_to_finally, 1), new FlowGraph.ExceptionEdgeKey(type));
                            definiteCatch = true;
                            continue;
                        }
                        if (!cb.catchType().isImplicitCastValid(type)) continue;
                        this.edge(last_peer, this.graph.peer(cb, this.path_to_finally, 1), new FlowGraph.ExceptionEdgeKey(cb.catchType()));
                    }
                    if (definiteCatch) {
                        return;
                    }
                }
                if (tr.finallyBlock() != null) {
                    last_peer = this.exceptionEdgesToFinally ? CFGBuilder.tryFinally(v, last_peer, last_peer.node == t, new FlowGraph.ExceptionEdgeKey(type), tr.finallyBlock()) : CFGBuilder.tryFinally(v, last_peer, last_peer.node == t, tr.finallyBlock());
                }
            }
            v = v.outer;
        }
        if (this.errorEdgesToExitNode || !type.isSubtype(this.ts.Error())) {
            this.edge(last_peer, this.exitPeer(), new FlowGraph.ExceptionEdgeKey(type));
        }
    }

    protected static <FlowItem extends DataFlow.Item> FlowGraph.Peer<FlowItem> tryFinally(CFGBuilder<FlowItem> v, FlowGraph.Peer<FlowItem> last, boolean abruptCompletion, FlowGraph.EdgeKey edgeKeyToFinally, Block finallyBlock) {
        CFGBuilder<FlowItem> v_ = v.outer.enterFinally(last, abruptCompletion);
        FlowGraph.Peer<FlowItem> finallyBlockEntryPeer = v_.graph.peer(finallyBlock, v_.path_to_finally, 1);
        if (edgeKeyToFinally == null) {
            edgeKeyToFinally = FlowGraph.EDGE_KEY_OTHER;
        }
        v_.edge(last, finallyBlockEntryPeer, edgeKeyToFinally);
        v_.visitCFG(finallyBlock, Collections.emptyList());
        FlowGraph.Peer<FlowItem> finallyBlockExitPeer = v_.graph.peer(finallyBlock, v_.path_to_finally, 0);
        return finallyBlockExitPeer;
    }

    protected static <FlowItem extends DataFlow.Item> FlowGraph.Peer<FlowItem> tryFinally(CFGBuilder<FlowItem> v, FlowGraph.Peer<FlowItem> last, boolean abruptCompletion, Block finallyBlock) {
        return CFGBuilder.tryFinally(v, last, abruptCompletion, FlowGraph.EDGE_KEY_OTHER, finallyBlock);
    }

    protected CFGBuilder<FlowItem> enterFinally(FlowGraph.Peer<FlowItem> from, boolean abruptCompletion) {
        if (abruptCompletion) {
            Object v = this.copy();
            ((CFGBuilder)v).path_to_finally = new ArrayList<Term>(from.path_to_finally.size() + 1);
            ((CFGBuilder)v).path_to_finally.addAll(from.path_to_finally);
            ((CFGBuilder)v).path_to_finally.add(from.node);
            return v;
        }
        if (CollectionUtil.equals(this.path_to_finally, from.path_to_finally)) {
            return this;
        }
        Object v = this.copy();
        ((CFGBuilder)v).path_to_finally = new ArrayList<Term>(from.path_to_finally);
        return v;
    }

    public void edge(Term p, Term q, int qEntry) {
        this.edge(this, p, q, qEntry, FlowGraph.EDGE_KEY_OTHER);
    }

    public void edge(Term p, Term q, int qEntry, FlowGraph.EdgeKey edgeKey) {
        this.edge(this, p, q, qEntry, edgeKey);
    }

    public void edge(CFGBuilder<FlowItem> p_visitor, Term p, Term q, int qEntry, FlowGraph.EdgeKey edgeKey) {
        this.edge(p_visitor, p, 0, q, qEntry, edgeKey);
    }

    public void edge(CFGBuilder<FlowItem> p_visitor, Term p, FlowGraph.Peer<FlowItem> pq, FlowGraph.EdgeKey edgeKey) {
        FlowGraph.Peer<FlowItem> pp = this.graph.peer(p, p_visitor.path_to_finally, 0);
        this.edge(pp, pq, edgeKey);
    }

    public void edge(CFGBuilder<FlowItem> p_visitor, Term p, int pEntry, Term q, int qEntry, FlowGraph.EdgeKey edgeKey) {
        FlowGraph.Peer<FlowItem> pp = this.graph.peer(p, p_visitor.path_to_finally, pEntry);
        FlowGraph.Peer<FlowItem> pq = this.graph.peer(q, this.path_to_finally, qEntry);
        this.edge(pp, pq, edgeKey);
    }

    protected void edge(FlowGraph.Peer<FlowItem> pp, FlowGraph.Peer<FlowItem> pq, FlowGraph.EdgeKey edgeKey) {
        if (Report.should_report("cfg", 2)) {
            Report.report(2, "//     edge " + pp.node() + " -> " + pq.node());
        }
        if (Report.should_report("cfg", 3)) {
            Report.report(2, pp.hashCode() + " [ label = \"" + StringUtil.escape(pp.toString()) + "\" ];");
            Report.report(2, pq.hashCode() + " [ label = \"" + StringUtil.escape(pq.toString()) + "\" ];");
        } else if (Report.should_report("cfg", 2)) {
            Report.report(2, pp.hashCode() + " [ label = \"" + StringUtil.escape(pp.node.toString()) + "\" ];");
            Report.report(2, pq.hashCode() + " [ label = \"" + StringUtil.escape(pq.node.toString()) + "\" ];");
        }
        if (this.graph.forward()) {
            if (Report.should_report("cfg", 2)) {
                Report.report(2, pp.hashCode() + " -> " + pq.hashCode() + " [label=\"" + edgeKey + "\"];");
            }
            pp.succs.add(new FlowGraph.Edge<FlowItem>(edgeKey, pq));
            pq.preds.add(new FlowGraph.Edge<FlowItem>(edgeKey, pp));
        } else {
            if (Report.should_report("cfg", 2)) {
                Report.report(2, pq.hashCode() + " -> " + pp.hashCode() + " [label=\"" + edgeKey + "\"];");
            }
            pq.succs.add(new FlowGraph.Edge<FlowItem>(edgeKey, pp));
            pp.preds.add(new FlowGraph.Edge<FlowItem>(edgeKey, pq));
        }
    }

    public boolean skipDeadIfBranches() {
        return this.skipDeadIfBranches;
    }

    public CFGBuilder<FlowItem> skipDeadIfBranches(boolean b) {
        if (b == this.skipDeadIfBranches) {
            return this;
        }
        Object v = this.copy();
        ((CFGBuilder)v).skipDeadIfBranches = b;
        return v;
    }

    public boolean skipDeadLoopBodies() {
        return this.skipDeadLoopBodies;
    }

    public CFGBuilder<FlowItem> skipDeadLoopBodies(boolean b) {
        if (b == this.skipDeadLoopBodies) {
            return this;
        }
        Object v = this.copy();
        ((CFGBuilder)v).skipDeadLoopBodies = b;
        return v;
    }

    public CFGBuilder<FlowItem> errorEdgesToExitNode(boolean b) {
        if (b == this.errorEdgesToExitNode) {
            return this;
        }
        Object v = this.copy();
        ((CFGBuilder)v).errorEdgesToExitNode = b;
        return v;
    }

    public CFGBuilder<FlowItem> exceptionEdgesToFinally(boolean b) {
        if (b == this.exceptionEdgesToFinally) {
            return this;
        }
        Object v = this.copy();
        ((CFGBuilder)v).exceptionEdgesToFinally = b;
        return v;
    }

    public CFGBuilder<FlowItem> trackImplicitErrors(boolean b) {
        if (b == this.trackImplicitErrors) {
            return this;
        }
        Object v = this.copy();
        ((CFGBuilder)v).trackImplicitErrors = b;
        return v;
    }

    protected static class EdgeKeyTermPair {
        public final FlowGraph.EdgeKey edgeKey;
        public final Term term;
        public final int entry;

        public EdgeKeyTermPair(FlowGraph.EdgeKey edgeKey, Term term, int entry) {
            this.edgeKey = edgeKey;
            this.term = term;
            this.entry = entry;
        }

        public String toString() {
            return "{edgeKey=" + this.edgeKey + ",term=" + this.term + "," + (this.entry == 1 ? "entry" : "exit") + "}";
        }
    }
}

