/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util.typedump;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ext.jl5.types.JL5ClassType;
import polyglot.frontend.ExtensionInfo;
import polyglot.main.Version;
import polyglot.types.ClassType;
import polyglot.types.SemanticException;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.reflect.ClassFile;
import polyglot.util.CodeWriter;
import polyglot.util.Position;

public class TypeDumper {
    static Set<Class<?>> dontExpand;
    TypeObject theType;
    String rawName;
    String compilerVersion;
    Date timestamp;

    public TypeDumper(String rawName, TypeObject t, String compilerVersion, Long timestamp) {
        this.theType = t;
        this.rawName = rawName;
        this.compilerVersion = compilerVersion;
        this.timestamp = timestamp != null ? new Date(timestamp) : null;
        TypeDumper.initializeType(this.theType);
    }

    private static void initializeType(TypeObject t) {
        if (t instanceof ClassType) {
            ClassType ct = (ClassType)t;
            ct.methods();
            ct.fields();
            ct.interfaces();
            ct.superType();
            ct.container();
            if (ct instanceof JL5ClassType) {
                JL5ClassType jct = (JL5ClassType)ct;
                jct.annotationElems();
                jct.annotations();
                jct.enumConstants();
            }
        }
    }

    public static TypeDumper load(String name, TypeSystem ts, Version ver) throws ClassNotFoundException, NoSuchFieldException, SecurityException, IllegalArgumentException, SemanticException {
        Class<?> c = Class.forName(name);
        try {
            String suffix = ver.name();
            Field jlcVersion = c.getDeclaredField("jlc$CompilerVersion$" + suffix);
            Field jlcTimestamp = c.getDeclaredField("jlc$SourceLastModified$" + suffix);
            Field jlcType = c.getDeclaredField("jlc$ClassType$" + suffix);
            jlcVersion.setAccessible(true);
            jlcTimestamp.setAccessible(true);
            jlcType.setAccessible(true);
            return new TypeDumper(name, ts.typeForName(name), (String)jlcVersion.get(null), (Long)jlcTimestamp.get(null));
        }
        catch (IllegalAccessException exn) {
            exn.printStackTrace();
            throw new SecurityException("illegal access: " + exn.getMessage());
        }
    }

    public void dump(CodeWriter w) {
        TypeCache cache = new TypeCache();
        cache.put(this.theType);
        w.write("Type " + this.rawName + " {");
        w.allowBreak(2);
        w.begin(0);
        w.write("Compiled with polyglot version " + this.compilerVersion + ".  ");
        w.allowBreak(0);
        if (this.timestamp != null) {
            w.write("Last modified: " + this.timestamp.toString() + ".  ");
            w.allowBreak(0);
        }
        w.write(this.theType.toString());
        w.allowBreak(2);
        w.write("<" + this.theType.getClass().toString() + ">");
        w.allowBreak(0);
        this.dumpObjectFields(w, this.theType, cache);
        w.allowBreak(0);
        w.end();
        w.allowBreak(0);
        w.write("}");
        w.newline(0);
    }

    protected void dumpObject(CodeWriter w, Object o, TypeCache cache, Field declaredField) {
        if (o instanceof TypeObject) {
            TypeDumper.initializeType((TypeObject)o);
        }
        w.begin(0);
        Class<?> rtType = o.getClass();
        w.write("<" + rtType.toString() + ">:");
        w.allowBreak(0);
        w.write(o.toString());
        if (!(Object.class.equals(rtType) || o instanceof TypeSystem || o instanceof ExtensionInfo || o instanceof ClassFile || TypeDumper.dontDump(rtType) || TypeDumper.dontDump(rtType.getName(), declaredField == null ? null : declaredField.getName()) || rtType.isArray() || cache.containsKey(o) && cache.get(o) == o)) {
            w.allowBreak(2);
            cache.put(o);
            if (o instanceof List || o instanceof Set) {
                Collection list = (Collection)o;
                for (Object elem : list) {
                    this.dumpObject(w, elem, cache, null);
                    w.newline();
                }
            } else if (o instanceof Map) {
                Map map = (Map)o;
                for (Object key : map.keySet()) {
                    this.dumpObject(w, key, cache, null);
                    w.allowBreak(0);
                    w.write(" -> ");
                    w.allowBreak(0);
                    this.dumpObject(w, map.get(key), cache, null);
                }
            } else {
                this.dumpObjectFields(w, o, cache);
            }
        }
        w.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpObjectFields(CodeWriter w, Object obj, TypeCache cache) {
        w.write(" fields {");
        w.newline();
        w.begin(4);
        w.write("    ");
        try {
            ArrayList<Field> allFields = new ArrayList<Field>();
            for (Class<?> objClass = obj.getClass(); objClass != null; objClass = objClass.getSuperclass()) {
                allFields.addAll(Arrays.asList(objClass.getDeclaredFields()));
                AccessibleObject.setAccessible(objClass.getDeclaredFields(), true);
            }
            AccessibleObject.setAccessible(allFields.toArray(new AccessibleObject[0]), true);
            for (Field declaredField : allFields) {
                if (Modifier.isStatic(declaredField.getModifiers())) continue;
                w.begin(2);
                w.write(declaredField.getName() + ": ");
                try {
                    Object o = declaredField.get(obj);
                    if (o != null) {
                        this.dumpObject(w, o, cache, declaredField);
                    } else {
                        w.write("null");
                    }
                }
                catch (IllegalAccessException exn) {
                    w.write("##[" + exn.getMessage() + "]");
                }
                w.end();
                w.newline();
            }
        }
        catch (SecurityException exn) {
        }
        finally {
            w.end();
            w.allowBreak(0);
            w.write("}");
        }
    }

    private static boolean dontDump(String className, String fieldName) {
        return "classFileSource".equals(fieldName);
    }

    static boolean dontDump(Class<?> c) {
        return dontExpand.contains(c);
    }

    static {
        Class[] primitiveLike = new Class[]{Void.class, Boolean.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Class.class, String.class, Character.class};
        dontExpand = new HashSet<Class>(Arrays.asList(primitiveLike));
        dontExpand.add(Position.class);
        dontExpand.add(Compiler.class);
    }

    public static class TypeCache {
        private final Map<TypeSystem, Map<Object, Object>> c = new HashMap<TypeSystem, Map<Object, Object>>();

        public void put(Object o) {
            TypeSystem ts = TypeCache.typeSystemFor(o);
            Map<Object, Object> m = this.c.get(ts);
            if (m == null) {
                m = new HashMap<Object, Object>();
                this.c.put(ts, m);
            }
            m.put(o, o);
        }

        private static TypeSystem typeSystemFor(Object o) {
            if (o instanceof TypeObject) {
                TypeObject to = (TypeObject)o;
                return to.typeSystem();
            }
            return null;
        }

        public Object get(Object o) {
            TypeSystem ts = TypeCache.typeSystemFor(o);
            Map<Object, Object> m = this.c.get(ts);
            if (m != null) {
                return m.get(o);
            }
            return null;
        }

        public boolean containsKey(Object o) {
            TypeSystem ts = TypeCache.typeSystemFor(o);
            Map<Object, Object> m = this.c.get(ts);
            if (m != null) {
                return m.containsKey(o);
            }
            return false;
        }
    }
}

