/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import polyglot.util.FormatResult;
import polyglot.util.Item;
import polyglot.util.MaxLevels;
import polyglot.util.Overrun;

class TextItem
extends Item {
    String s;
    int length;

    TextItem(String s_, int length_) {
        this.s = s_;
        this.length = length_;
    }

    @Override
    FormatResult formatN(int lmargin, int pos, int rmargin, int fin, MaxLevels m, int minLevel, int minLevelUnified) throws Overrun {
        return TextItem.format(this.next, lmargin, pos + this.length, rmargin, fin, m, minLevel, minLevelUnified);
    }

    @Override
    int sendOutput(PrintWriter o, int lm, int pos, int rm, boolean success, Item last) throws IOException {
        o.write(this.s);
        return pos + this.length;
    }

    @Override
    boolean selfContainsBreaks(MaxLevels m) {
        return false;
    }

    @Override
    int selfMinIndent(MaxLevels m) {
        return -9999;
    }

    @Override
    int selfMinWidth(MaxLevels m) {
        return -9999;
    }

    @Override
    int selfMinPosWidth(MaxLevels m) {
        return this.length;
    }

    @Override
    String selfToString() {
        StringWriter sw = new StringWriter();
        for (int i = 0; i < this.s.length(); ++i) {
            char c = this.s.charAt(i);
            if (c == ' ') {
                sw.write("\\ ");
                continue;
            }
            sw.write(c);
        }
        return sw.toString();
    }

    public void appendTextItem(TextItem item) {
        this.s = this.s + item.s;
        this.length += item.length;
    }
}

