/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.StringTokenizer;
import polyglot.util.AbstractErrorQueue;
import polyglot.util.ErrorInfo;
import polyglot.util.Position;

public class StdErrorQueue
extends AbstractErrorQueue {
    private PrintStream err;

    public StdErrorQueue(PrintStream err, int limit, String name) {
        super(limit, name);
        this.err = err;
    }

    @Override
    public void displayError(ErrorInfo e) {
        boolean lineHasContent;
        String prefix;
        String message = e.getErrorKind() != 7 ? e.getMessage() : e.getErrorString() + " -- " + e.getMessage();
        Position position = e.getPosition();
        String string = prefix = position != null ? position.nameAndLineString() : this.name;
        if (prefix == null) {
            prefix = "jlc";
        }
        int lmargin = 4;
        int rmargin = 78;
        StringBuffer sb = new StringBuffer(prefix + ": ");
        sb.ensureCapacity(rmargin);
        int width = 0;
        width += prefix.length() + 2;
        StringTokenizer lines = new StringTokenizer(message, "\n", true);
        boolean needNewline = false;
        boolean isPostCompilerError = e.getErrorKind() == 6;
        boolean bl = lineHasContent = prefix.length() > 0;
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            if (line.charAt(0) != '\n') {
                if (isPostCompilerError) {
                    sb.append(line);
                    lineHasContent = true;
                } else {
                    StringTokenizer st = new StringTokenizer(line, " ", true);
                    while (st.hasMoreTokens()) {
                        String s = st.nextToken();
                        if (width + s.length() + 1 > rmargin) {
                            if (lineHasContent) {
                                this.err.println(sb.toString());
                                lineHasContent = false;
                            }
                            for (int i = 0; i < lmargin; ++i) {
                                sb.setCharAt(i, ' ');
                            }
                            sb.setLength(lmargin);
                            width = lmargin;
                        }
                        if (s.charAt(0) != ' ') {
                            lineHasContent = true;
                        }
                        sb.append(s);
                        width += s.length();
                    }
                }
                needNewline = true;
            } else {
                this.err.print(line);
                needNewline = false;
            }
            if (lines.hasMoreTokens()) {
                if (lineHasContent) {
                    this.err.print(sb.toString());
                    lineHasContent = false;
                }
                for (int i = 0; i < lmargin; ++i) {
                    sb.setCharAt(i, ' ');
                }
                sb.setLength(lmargin);
                width = lmargin;
                continue;
            }
            if (!needNewline) continue;
            this.err.println(sb.toString());
        }
        if (position != null) {
            this.showError(position);
        }
    }

    @Override
    protected void tooManyErrors(ErrorInfo lastError) {
        Position position = lastError.getPosition();
        String prefix = position != null ? position.file() + ": " : "";
        this.err.println(prefix + "Too many errors.  Aborting compilation.");
    }

    protected Reader reader(Position pos) throws IOException {
        if (pos.path() != null && pos.line() != -1) {
            return new FileReader(pos.path());
        }
        return null;
    }

    private void showError(Position pos) {
        try (Reader r = this.reader(pos);){
            if (r == null) {
                return;
            }
            try (LineNumberReader reader = new LineNumberReader(r);){
                String s = reader.readLine();
                while (s != null && reader.getLineNumber() < pos.line()) {
                    s = reader.readLine();
                }
                if (s != null) {
                    this.err.println(s);
                    this.showErrorIndicator(pos, reader.getLineNumber(), s);
                    if (pos.endLine() != pos.line() && pos.endLine() != -1 && pos.endLine() != -2) {
                        if (pos.endLine() - pos.line() > 1) {
                            for (int j = 0; j < s.length() && Character.isWhitespace(s.charAt(j)); ++j) {
                                this.err.print(s.charAt(j));
                            }
                            this.err.println("...");
                        }
                        while (reader.getLineNumber() < pos.endLine()) {
                            s = reader.readLine();
                        }
                        if (s != null) {
                            this.err.println(s);
                            this.showErrorIndicator(pos, reader.getLineNumber(), s);
                        }
                    }
                }
            }
            this.err.println();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void showErrorIndicator(Position pos, int lineNum, String s) {
        if (pos.column() == -1) {
            return;
        }
        int i = 0;
        while (i < s.length() && Character.isWhitespace(s.charAt(i))) {
            this.err.print(s.charAt(i++));
        }
        int startIndAt = i;
        int stopIndAt = s.length() - 1;
        if (pos.line() == lineNum) {
            startIndAt = pos.column();
        }
        if (pos.endLine() == lineNum) {
            stopIndAt = pos.endColumn() - 1;
        }
        if (stopIndAt < startIndAt) {
            stopIndAt = startIndAt;
        }
        if (pos.endColumn() == -1 || pos.endColumn() == -2) {
            stopIndAt = startIndAt;
        }
        while (i <= stopIndAt) {
            int c = 45;
            if (i < startIndAt) {
                c = 32;
            }
            if (i < s.length() && s.charAt(i) == '\t') {
                c = 9;
            }
            if (i == startIndAt && pos.line() == lineNum) {
                c = 94;
            }
            if (i == stopIndAt && pos.endLine() == lineNum) {
                c = 94;
            }
            this.err.print((char)c);
            ++i;
        }
        this.err.println();
    }

    @Override
    public void flush() {
        if (!this.flushed && this.errorCount() > 0) {
            this.err.println(this.errorCount() + " error" + (this.errorCount() > 1 ? "s." : "."));
        }
        super.flush();
    }
}

