/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import polyglot.util.Predicate;

public final class FilteringIterator<T>
implements Iterator<T> {
    protected T next_item;
    protected Iterator<T> backing_iterator;
    protected Predicate<T> predicate;

    public FilteringIterator(Collection<T> coll, Predicate<T> pred) {
        this(coll.iterator(), pred);
    }

    public FilteringIterator(Iterator<T> iter, Predicate<T> pred) {
        this.backing_iterator = iter;
        this.predicate = pred;
        this.findNextItem();
    }

    @Override
    public T next() {
        T res = this.next_item;
        if (res == null) {
            throw new NoSuchElementException();
        }
        this.findNextItem();
        return res;
    }

    @Override
    public boolean hasNext() {
        return this.next_item != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("FilteringIterator.remove");
    }

    private void findNextItem() {
        while (this.backing_iterator.hasNext()) {
            T o = this.backing_iterator.next();
            if (!this.predicate.isTrue(o)) continue;
            this.next_item = o;
            return;
        }
        this.next_item = null;
    }
}

