/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ConcatenatedIterator<T>
implements Iterator<T> {
    protected T next_item;
    protected Iterator<T>[] backing_iterators;
    protected int index;

    @SafeVarargs
    public ConcatenatedIterator(Iterator<T> ... iters) {
        this.backing_iterators = (Iterator[])iters.clone();
        this.findNextItem();
    }

    public ConcatenatedIterator(Collection<Iterator<T>> iters) {
        this.backing_iterators = iters.toArray(new Iterator[iters.size()]);
        this.findNextItem();
    }

    @Override
    public T next() {
        T res = this.next_item;
        if (res == null) {
            throw new NoSuchElementException();
        }
        this.findNextItem();
        return res;
    }

    @Override
    public boolean hasNext() {
        return this.next_item != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("ConcatenatedIterator.remove");
    }

    private void findNextItem() {
        while (this.index < this.backing_iterators.length) {
            Iterator<T> it = this.backing_iterators[this.index];
            if (it.hasNext()) {
                this.next_item = it.next();
                return;
            }
            ++this.index;
        }
        this.next_item = null;
    }
}

