/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.JLang_c;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Source;
import polyglot.main.Report;
import polyglot.types.AccessControlResolver;
import polyglot.types.AccessControlWrapperResolver;
import polyglot.types.ArrayType;
import polyglot.types.ArrayType_c;
import polyglot.types.CachingResolver;
import polyglot.types.ClassContextResolver;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.ConstructorInstance_c;
import polyglot.types.Context;
import polyglot.types.Context_c;
import polyglot.types.Declaration;
import polyglot.types.DeserializedClassInitializer;
import polyglot.types.FieldInstance;
import polyglot.types.FieldInstance_c;
import polyglot.types.Flags;
import polyglot.types.ImportTable;
import polyglot.types.InitializerInstance;
import polyglot.types.InitializerInstance_c;
import polyglot.types.LazyClassInitializer;
import polyglot.types.LocalInstance;
import polyglot.types.LocalInstance_c;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.MethodInstance_c;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.NoMemberException;
import polyglot.types.NullType;
import polyglot.types.NullType_c;
import polyglot.types.Package;
import polyglot.types.PackageContextResolver;
import polyglot.types.Package_c;
import polyglot.types.ParsedClassType;
import polyglot.types.ParsedClassType_c;
import polyglot.types.PlaceHolder_c;
import polyglot.types.PrimitiveType;
import polyglot.types.PrimitiveType_c;
import polyglot.types.ProcedureInstance;
import polyglot.types.ReferenceType;
import polyglot.types.Resolver;
import polyglot.types.SchedulerClassInitializer;
import polyglot.types.SemanticException;
import polyglot.types.SystemResolver;
import polyglot.types.TopLevelResolver;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.UnknownPackage;
import polyglot.types.UnknownPackage_c;
import polyglot.types.UnknownQualifier;
import polyglot.types.UnknownQualifier_c;
import polyglot.types.UnknownType;
import polyglot.types.UnknownType_c;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.ClassFileLazyClassInitializer;
import polyglot.util.Copy;
import polyglot.util.Enum;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.StringUtil;
import polyglot.util.SubtypeSet;

public class TypeSystem_c
implements TypeSystem {
    protected SystemResolver systemResolver;
    protected TopLevelResolver loadedResolver;
    protected Map<String, Flags> flagsForName;
    protected ExtensionInfo extInfo;
    protected ClassType OBJECT_;
    protected ClassType CLASS_;
    protected ClassType STRING_;
    protected ClassType THROWABLE_;
    protected final NullType NULL_ = this.createNull();
    protected final PrimitiveType VOID_ = this.createPrimitive(PrimitiveType.VOID);
    protected final PrimitiveType BOOLEAN_ = this.createPrimitive(PrimitiveType.BOOLEAN);
    protected final PrimitiveType CHAR_ = this.createPrimitive(PrimitiveType.CHAR);
    protected final PrimitiveType BYTE_ = this.createPrimitive(PrimitiveType.BYTE);
    protected final PrimitiveType SHORT_ = this.createPrimitive(PrimitiveType.SHORT);
    protected final PrimitiveType INT_ = this.createPrimitive(PrimitiveType.INT);
    protected final PrimitiveType LONG_ = this.createPrimitive(PrimitiveType.LONG);
    protected final PrimitiveType FLOAT_ = this.createPrimitive(PrimitiveType.FLOAT);
    protected final PrimitiveType DOUBLE_ = this.createPrimitive(PrimitiveType.DOUBLE);
    protected UnknownType unknownType = new UnknownType_c(this);
    protected UnknownPackage unknownPackage = new UnknownPackage_c(this);
    protected UnknownQualifier unknownQualifier = new UnknownQualifier_c(this);
    Map<Type, ArrayType> arrayTypeCache = new HashMap<Type, ArrayType>();
    protected final Flags ACCESS_FLAGS = this.legalAccessFlags();
    protected final Flags LOCAL_FLAGS = this.legalLocalFlags();
    protected final Flags FIELD_FLAGS = this.legalFieldFlags();
    protected final Flags CONSTRUCTOR_FLAGS = this.legalConstructorFlags();
    protected final Flags INITIALIZER_FLAGS = this.legalInitializerFlags();
    protected final Flags METHOD_FLAGS = this.legalMethodFlags();
    protected final Flags ABSTRACT_METHOD_FLAGS = this.legalAbstractMethodFlags();
    protected final Flags TOP_LEVEL_CLASS_FLAGS = this.legalTopLevelClassFlags();
    protected final Flags MEMBER_CLASS_FLAGS = this.legalMemberClassFlags();
    protected final Flags LOCAL_CLASS_FLAGS = this.legalLocalClassFlags();
    protected final Flags INTERFACE_FIELD_FLAGS = this.legalInterfaceFieldFlags();

    @Override
    public void initialize(TopLevelResolver loadedResolver, ExtensionInfo extInfo) throws SemanticException {
        if (Report.should_report("types", 1)) {
            Report.report(1, "Initializing " + this.getClass().getName());
        }
        this.extInfo = extInfo;
        this.loadedResolver = loadedResolver;
        this.systemResolver = new SystemResolver(loadedResolver, extInfo);
        this.initEnums();
        this.initFlags();
        this.initTypes();
    }

    protected void initEnums() {
        Enum o = ClassType.TOP_LEVEL;
        o = PrimitiveType.VOID;
    }

    protected void initTypes() throws SemanticException {
    }

    @Override
    public ExtensionInfo extensionInfo() {
        return this.extInfo;
    }

    @Override
    public SystemResolver systemResolver() {
        return this.systemResolver;
    }

    @Override
    public SystemResolver saveSystemResolver() {
        SystemResolver r = this.systemResolver;
        this.systemResolver = r.copy();
        return r;
    }

    @Override
    public void restoreSystemResolver(SystemResolver r) {
        if (r != this.systemResolver.previous()) {
            throw new InternalCompilerError("Inconsistent systemResolver.previous");
        }
        this.systemResolver = r;
    }

    @Override
    @Deprecated
    public CachingResolver parsedResolver() {
        return this.systemResolver;
    }

    @Override
    public TopLevelResolver loadedResolver() {
        return this.loadedResolver;
    }

    @Override
    public ClassFileLazyClassInitializer classFileLazyClassInitializer(ClassFile clazz) {
        return new ClassFileLazyClassInitializer(clazz, this);
    }

    @Override
    public ImportTable importTable(String sourceName, Package pkg) {
        this.assert_(pkg);
        return new ImportTable(this, pkg, sourceName);
    }

    @Override
    public ImportTable importTable(Package pkg) {
        this.assert_(pkg);
        return new ImportTable(this, pkg);
    }

    @Override
    public boolean packageExists(String name) {
        return this.systemResolver.packageExists(name);
    }

    protected void assert_(Collection<? extends TypeObject> l) {
        for (TypeObject typeObject : l) {
            this.assert_(typeObject);
        }
    }

    protected void assert_(TypeObject o) {
        if (o != null && o.typeSystem() != this) {
            throw new InternalCompilerError("we are " + this + " but " + o + " (" + o.getClass() + ")" + " is from " + o.typeSystem());
        }
    }

    @Override
    public String wrapperTypeString(PrimitiveType t) {
        this.assert_(t);
        if (t.kind() == PrimitiveType.BOOLEAN) {
            return "java.lang.Boolean";
        }
        if (t.kind() == PrimitiveType.CHAR) {
            return "java.lang.Character";
        }
        if (t.kind() == PrimitiveType.BYTE) {
            return "java.lang.Byte";
        }
        if (t.kind() == PrimitiveType.SHORT) {
            return "java.lang.Short";
        }
        if (t.kind() == PrimitiveType.INT) {
            return "java.lang.Integer";
        }
        if (t.kind() == PrimitiveType.LONG) {
            return "java.lang.Long";
        }
        if (t.kind() == PrimitiveType.FLOAT) {
            return "java.lang.Float";
        }
        if (t.kind() == PrimitiveType.DOUBLE) {
            return "java.lang.Double";
        }
        if (t.kind() == PrimitiveType.VOID) {
            return "java.lang.Void";
        }
        throw new InternalCompilerError("Unrecognized primitive type.");
    }

    @Override
    public Context createContext() {
        return new Context_c(JLang_c.instance, this);
    }

    @Override
    @Deprecated
    public Resolver packageContextResolver(Resolver cr, Package p) {
        return this.packageContextResolver(p);
    }

    @Override
    public AccessControlResolver createPackageContextResolver(Package p) {
        this.assert_(p);
        return new PackageContextResolver(this, p);
    }

    @Override
    public Resolver packageContextResolver(Package p, ClassType accessor) {
        if (accessor == null) {
            return p.resolver();
        }
        return new AccessControlWrapperResolver(this.createPackageContextResolver(p), accessor);
    }

    @Override
    public Resolver packageContextResolver(Package p) {
        this.assert_(p);
        return this.packageContextResolver(p, null);
    }

    @Override
    public Resolver classContextResolver(ClassType type, ClassType accessor) {
        this.assert_(type);
        if (accessor == null) {
            return type.resolver();
        }
        return new AccessControlWrapperResolver(this.createClassContextResolver(type), accessor);
    }

    @Override
    public Resolver classContextResolver(ClassType type) {
        return this.classContextResolver(type, null);
    }

    @Override
    public AccessControlResolver createClassContextResolver(ClassType type) {
        this.assert_(type);
        return new ClassContextResolver(this, type);
    }

    @Override
    public FieldInstance fieldInstance(Position pos, ReferenceType container, Flags flags, Type type, String name) {
        this.assert_(container);
        this.assert_(type);
        return new FieldInstance_c(this, pos, container, flags, type, name);
    }

    @Override
    public LocalInstance localInstance(Position pos, Flags flags, Type type, String name) {
        this.assert_(type);
        return new LocalInstance_c(this, pos, flags, type, name);
    }

    @Override
    public ConstructorInstance defaultConstructor(Position pos, ClassType container) {
        this.assert_(container);
        Flags access = Flags.NONE;
        if (container.flags().isPrivate()) {
            access = access.Private();
        }
        if (container.flags().isProtected()) {
            access = access.Protected();
        }
        if (container.flags().isPublic()) {
            access = access.Public();
        }
        return this.constructorInstance(pos, container, access, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public ConstructorInstance constructorInstance(Position pos, ClassType container, Flags flags, List<? extends Type> argTypes, List<? extends Type> excTypes) {
        this.assert_(container);
        this.assert_(argTypes);
        this.assert_(excTypes);
        return new ConstructorInstance_c((TypeSystem)this, pos, container, flags, argTypes, excTypes);
    }

    @Override
    public InitializerInstance initializerInstance(Position pos, ClassType container, Flags flags) {
        this.assert_(container);
        return new InitializerInstance_c(this, pos, container, flags);
    }

    @Override
    public MethodInstance methodInstance(Position pos, ReferenceType container, Flags flags, Type returnType, String name, List<? extends Type> argTypes, List<? extends Type> excTypes) {
        this.assert_(container);
        this.assert_(returnType);
        this.assert_(argTypes);
        this.assert_(excTypes);
        return new MethodInstance_c(this, pos, container, flags, returnType, name, argTypes, excTypes);
    }

    @Override
    public boolean descendsFrom(Type child, Type ancestor) {
        this.assert_(child);
        this.assert_(ancestor);
        return child.descendsFromImpl(ancestor);
    }

    @Override
    public boolean isCastValid(Type fromType, Type toType) {
        this.assert_(fromType);
        this.assert_(toType);
        return fromType.isCastValidImpl(toType);
    }

    @Override
    public boolean isImplicitCastValid(Type fromType, Type toType) {
        this.assert_(fromType);
        this.assert_(toType);
        return fromType.isImplicitCastValidImpl(toType);
    }

    @Override
    public boolean equals(TypeObject type1, TypeObject type2) {
        this.assert_(type1);
        this.assert_(type2);
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        return type1.equalsImpl(type2);
    }

    @Override
    public boolean typeEquals(Type type1, Type type2) {
        this.assert_(type1);
        this.assert_(type2);
        return type1.typeEqualsImpl(type2);
    }

    @Override
    public boolean packageEquals(Package type1, Package type2) {
        this.assert_(type1);
        this.assert_(type2);
        return type1.packageEqualsImpl(type2);
    }

    @Override
    public boolean numericConversionValid(Type t, Object value) {
        this.assert_(t);
        return t.numericConversionValidImpl(value);
    }

    @Override
    @Deprecated
    public boolean numericConversionValid(Type t, long value) {
        return this.numericConversionValid(t, new Long(value));
    }

    @Override
    public boolean isCanonical(Type type) {
        this.assert_(type);
        return type.isCanonical();
    }

    @Override
    public boolean isAccessible(MemberInstance mi, Context context) {
        return this.isAccessible(mi, context.currentClass());
    }

    @Override
    public boolean isAccessible(MemberInstance mi, ClassType contextClass) {
        return this.isAccessible(mi, contextClass, false);
    }

    @Override
    public boolean isAccessible(MemberInstance mi, ClassType contextClass, boolean fromClient) {
        this.assert_(mi);
        ReferenceType target = mi.container();
        return this.isAccessible(mi, target, contextClass, fromClient);
    }

    @Override
    public boolean isAccessible(MemberInstance mi, ReferenceType container, ClassType contextClass) {
        return this.isAccessible(mi, container, contextClass, true);
    }

    @Override
    public boolean isAccessible(MemberInstance mi, ReferenceType container, ReferenceType contextType, boolean fromClient) {
        boolean isAccessibleFromPackage;
        Flags flags = mi.flags();
        ReferenceType target = mi.container();
        if (!target.isClass()) {
            return flags.isPublic();
        }
        ClassType targetClass = (ClassType)target.toClass().declaration();
        if (container.isClass() && contextType.isClass() && !this.classAccessible(container.toClass(), contextType.toClass())) {
            return false;
        }
        if (flags.isPublic()) {
            return true;
        }
        if (flags.isPrivate()) {
            if (contextType.isClass()) {
                ClassType ct = contextType.toClass();
                while (!ct.isTopLevel()) {
                    ct = ct.outer();
                }
                return this.typeEquals(targetClass, ct) || this.isEnclosed(targetClass, ct);
            }
            return this.typeEquals(targetClass, contextType);
        }
        boolean bl = isAccessibleFromPackage = contextType.isClass() && this.accessibleFromPackage(flags, targetClass.package_(), contextType.toClass().package_());
        if (flags.isProtected()) {
            if (isAccessibleFromPackage) {
                return true;
            }
            if (mi instanceof ConstructorInstance) {
                return !fromClient;
            }
            ReferenceType rt = contextType;
            if (contextType.isClass()) {
                ClassType ct = contextType.toClass();
                while (!this.isSubtype(ct, targetClass) && !ct.isTopLevel()) {
                    ct = ct.outer();
                }
                rt = ct;
            }
            if (this.isSubtype(rt, targetClass)) {
                if (mi instanceof ClassType || flags.isStatic()) {
                    return true;
                }
                return !fromClient || this.isSubtype(container, rt);
            }
        }
        return isAccessibleFromPackage;
    }

    @Override
    public boolean classAccessible(ClassType targetClass, Context context) {
        if (context.currentClass() == null) {
            return this.classAccessibleFromPackage(targetClass, context.importTable().package_());
        }
        return this.classAccessible(targetClass, context.currentClass());
    }

    @Override
    public boolean classAccessible(ClassType targetClass, ClassType contextClass) {
        this.assert_(targetClass);
        if (targetClass.isMember()) {
            return this.isAccessible((MemberInstance)targetClass, contextClass);
        }
        if (!targetClass.isTopLevel()) {
            return true;
        }
        if (this.equals(targetClass, contextClass)) {
            return true;
        }
        if (this.isEnclosed(contextClass, targetClass)) {
            return true;
        }
        return this.classAccessibleFromPackage(targetClass, contextClass.package_());
    }

    @Override
    public boolean classAccessibleFromPackage(ClassType targetClass, Package pkg) {
        this.assert_(targetClass);
        if (!targetClass.isTopLevel() && !targetClass.isMember()) {
            return false;
        }
        Flags flags = targetClass.flags();
        if (targetClass.isMember()) {
            if (!targetClass.container().isClass()) {
                return flags.isPublic();
            }
            if (!this.classAccessibleFromPackage(targetClass.container().toClass(), pkg)) {
                return false;
            }
        }
        return this.accessibleFromPackage(flags, targetClass.package_(), pkg);
    }

    protected boolean accessibleFromPackage(Flags flags, Package pkg1, Package pkg2) {
        if (flags.isPublic()) {
            return true;
        }
        if (flags.isPackage() || flags.isProtected()) {
            if (pkg1 == null && pkg2 == null) {
                return true;
            }
            if (pkg1 != null && pkg1.equals(pkg2)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEnclosed(ClassType inner, ClassType outer) {
        return inner.isEnclosedImpl(outer);
    }

    @Override
    public boolean hasEnclosingInstance(ClassType inner, ClassType encl) {
        return inner.hasEnclosingInstanceImpl(encl);
    }

    @Override
    public void checkCycles(ReferenceType goal) throws SemanticException {
        this.checkCycles(goal, goal);
    }

    protected void checkCycles(ReferenceType curr, ReferenceType goal) throws SemanticException {
        this.assert_(curr);
        this.assert_(goal);
        if (curr == null) {
            return;
        }
        ReferenceType superType = null;
        if (curr.superType() != null) {
            superType = curr.superType().toReference();
        }
        if (goal == superType) {
            throw new SemanticException("Circular inheritance involving " + goal, curr.position());
        }
        this.checkCycles(superType, goal);
        for (Type type : curr.interfaces()) {
            if (type == goal) {
                throw new SemanticException("Circular inheritance involving " + goal, curr.position());
            }
            this.checkCycles(type.toReference(), goal);
        }
        if (curr.isClass()) {
            this.checkCycles(curr.toClass().outer(), goal);
        }
    }

    @Override
    public boolean canCoerceToString(Type t, Context c) {
        return !t.isVoid();
    }

    @Override
    public boolean isThrowable(Type type) {
        this.assert_(type);
        return type.isThrowable();
    }

    @Override
    public boolean isUncheckedException(Type type) {
        this.assert_(type);
        return type.isUncheckedException();
    }

    @Override
    public Collection<Type> uncheckedExceptions() {
        ArrayList<Type> l = new ArrayList<Type>(2);
        l.add(this.Error());
        l.add(this.RuntimeException());
        return l;
    }

    @Override
    public boolean isSubtype(Type t1, Type t2) {
        this.assert_(t1);
        this.assert_(t2);
        return t1.isSubtypeImpl(t2);
    }

    @Override
    @Deprecated
    public FieldInstance findField(ReferenceType container, String name, Context c) throws SemanticException {
        ClassType ct = null;
        if (c != null) {
            ct = c.currentClass();
        }
        return this.findField(container, name, ct);
    }

    @Override
    @Deprecated
    public FieldInstance findField(ReferenceType container, String name, ClassType currClass) throws SemanticException {
        return this.findField(container, name, currClass, true);
    }

    @Override
    public FieldInstance findField(ReferenceType container, String name, ClassType currClass, boolean fromClient) throws SemanticException {
        Set<FieldInstance> fields = this.findFields(container, name);
        FieldInstance result = null;
        SemanticException error = null;
        for (FieldInstance fi : fields) {
            ReferenceType fc = fi.container();
            if (currClass != null) {
                Type fiType = fi.type();
                if (fiType.isArray()) {
                    fiType = fiType.toArray().ultimateBase();
                }
                if (fiType.isClass() && !this.classAccessible(fiType.toClass(), currClass)) {
                    if (error != null) continue;
                    error = new SemanticException("The field \"" + fi.name() + "\" has type " + fi.type() + ", which is inaccessible from class " + currClass);
                    continue;
                }
                if (!this.isMember(fi, container.toReference())) {
                    if (error != null) continue;
                    error = new NoMemberException(3, "The " + fi + " is not visible in class " + container + ".");
                    continue;
                }
                if (!this.isAccessible(fi, container, currClass, fromClient)) {
                    if (error != null) continue;
                    error = new SemanticException("Cannot access " + fi + ".");
                    continue;
                }
                if (result != null) {
                    throw new SemanticException("Field \"" + name + "\" is ambiguous; it is defined in both " + result.container() + " and " + fc + ".");
                }
                result = fi;
                continue;
            }
            if (!fi.flags().isPublic()) {
                if (error != null) continue;
                error = new SemanticException("Cannot access " + fi + ".");
                continue;
            }
            if (result != null) {
                throw new SemanticException("Field \"" + name + "\" is ambiguous; it is defined in both " + result.container() + " and " + fc + ".");
            }
            result = fi;
        }
        if (result == null) {
            throw error == null ? new NoMemberException(3, "Field \"" + name + "\" not found in type \"" + container + "\".") : error;
        }
        return result;
    }

    @Override
    public boolean isMember(MemberInstance mi, ReferenceType type) {
        return this.typeEquals(mi.container(), type) || this.isInherited(mi, type);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isInherited(MemberInstance mi, ReferenceType type) {
        MethodInstance mi_;
        if (mi.flags().isPrivate()) {
            return false;
        }
        if (mi instanceof MethodInstance && !type.methods((mi_ = (MethodInstance)mi).name(), mi_.formalTypes()).isEmpty()) {
            return false;
        }
        ReferenceType container = mi.container();
        boolean isInheritedInSuperType = false;
        Type superType = type.superType();
        if (superType != null && this.isMember(mi, superType.toReference())) {
            isInheritedInSuperType = true;
        }
        if (!isInheritedInSuperType) {
            for (ReferenceType referenceType : type.interfaces()) {
                if (!this.isMember(mi, referenceType.toReference())) continue;
                isInheritedInSuperType = true;
                break;
            }
        }
        if (isInheritedInSuperType) {
            void var7_10;
            if (mi.flags().isProtected() || mi.flags().isPublic()) {
                return true;
            }
            Package typePackage = null;
            if (type.isClass()) {
                typePackage = type.toClass().package_();
            }
            Object var7_8 = null;
            if (container.isClass()) {
                Package package_ = container.toClass().package_();
            }
            return typePackage == null ? typePackage == var7_10 : this.packageEquals(typePackage, (Package)var7_10);
        }
        return false;
    }

    @Override
    @Deprecated
    public FieldInstance findField(ReferenceType container, String name) throws SemanticException {
        return this.findField(container, name, container.toClass());
    }

    protected Set<FieldInstance> findFields(ReferenceType container, String name) {
        this.assert_(container);
        if (container == null) {
            throw new InternalCompilerError("Cannot access field \"" + name + "\" within a null container type.");
        }
        FieldInstance fi = container.fieldNamed(name);
        if (fi != null) {
            return Collections.singleton(fi);
        }
        HashSet<FieldInstance> fields = new HashSet<FieldInstance>();
        if (container.superType() != null && container.superType().isReference()) {
            Set<FieldInstance> superFields = this.findFields(container.superType().toReference(), name);
            fields.addAll(superFields);
        }
        if (container.isClass()) {
            ClassType ct = container.toClass();
            for (Type type : ct.interfaces()) {
                Set<FieldInstance> superFields = this.findFields(type.toReference(), name);
                fields.addAll(superFields);
            }
        }
        return fields;
    }

    @Override
    @Deprecated
    public ClassType findMemberClass(ClassType container, String name, Context c) throws SemanticException {
        return this.findMemberClass(container, name, c.currentClass());
    }

    @Override
    public ClassType findMemberClass(ClassType container, String name, ClassType currClass) throws SemanticException {
        this.assert_(container);
        Named n = this.classContextResolver(container, currClass).find(name);
        if (n instanceof ClassType) {
            return (ClassType)n;
        }
        throw new NoClassException(name, container);
    }

    @Override
    public ClassType findMemberClass(ClassType container, String name) throws SemanticException {
        return this.findMemberClass(container, name, (ClassType)null);
    }

    protected static String listToString(List<?> l) {
        StringBuffer sb = new StringBuffer();
        Iterator<?> i = l.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            sb.append(o.toString());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    @Deprecated
    public MethodInstance findMethod(ReferenceType container, String name, List<? extends Type> argTypes, Context c) throws SemanticException {
        return this.findMethod(container, name, argTypes, c.currentClass());
    }

    @Override
    public boolean hasMethodNamed(ReferenceType container, String name) {
        this.assert_(container);
        if (container == null) {
            throw new InternalCompilerError("Cannot access method \"" + name + "\" within a null container type.");
        }
        if (!container.methodsNamed(name).isEmpty()) {
            return true;
        }
        if (container.superType() != null && container.superType().isReference() && this.hasMethodNamed(container.superType().toReference(), name)) {
            return true;
        }
        if (container.isClass()) {
            ClassType ct = container.toClass();
            for (Type type : ct.interfaces()) {
                if (!this.hasMethodNamed(type.toReference(), name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasAccessibleMethodNamed(ReferenceType container, String name, ClassType currClass) {
        this.assert_(container);
        if (container == null) {
            throw new InternalCompilerError("Cannot access method \"" + name + "\" within a null container type.");
        }
        HashSet<Type> visitedTypes = new HashSet<Type>();
        LinkedList<Type> typeQueue = new LinkedList<Type>();
        typeQueue.addLast(container);
        while (!typeQueue.isEmpty()) {
            Type type = (Type)typeQueue.removeFirst();
            if (visitedTypes.contains(type)) continue;
            visitedTypes.add(type);
            if (!type.isReference()) continue;
            for (MethodInstance methodInstance : type.toReference().methodsNamed(name)) {
                if (!this.isMember(methodInstance, container.toReference()) || !this.isAccessible((MemberInstance)methodInstance, container, currClass)) continue;
                return true;
            }
            if (type.toReference().superType() != null) {
                typeQueue.addLast(type.toReference().superType());
            }
            typeQueue.addAll(type.toReference().interfaces());
        }
        return false;
    }

    @Override
    @Deprecated
    public MethodInstance findMethod(ReferenceType container, String name, List<? extends Type> argTypes, ClassType currClass) throws SemanticException {
        return this.findMethod(container, name, argTypes, currClass, true);
    }

    @Override
    public MethodInstance findMethod(ReferenceType container, String name, List<? extends Type> argTypes, ClassType currClass, boolean fromClient) throws SemanticException {
        this.assert_(container);
        this.assert_(argTypes);
        List<? extends MethodInstance> acceptable = this.findAcceptableMethods(container, name, argTypes, currClass, fromClient);
        if (acceptable.size() == 0) {
            throw new NoMemberException(1, "No valid method call found for " + name + "(" + TypeSystem_c.listToString(argTypes) + ")" + " in " + container + ".");
        }
        Collection<? extends MethodInstance> maximal = this.findMostSpecificProcedures(acceptable);
        if (maximal.size() > 1) {
            StringBuffer sb = new StringBuffer();
            Iterator<? extends MethodInstance> i = maximal.iterator();
            while (i.hasNext()) {
                MethodInstance ma = i.next();
                sb.append(ma.returnType());
                sb.append(" ");
                sb.append(ma.container());
                sb.append(".");
                sb.append(ma.signature());
                if (!i.hasNext()) continue;
                if (maximal.size() == 2) {
                    sb.append(" and ");
                    continue;
                }
                sb.append(", ");
            }
            throw new SemanticException("Reference to " + name + " is ambiguous, multiple methods match: " + sb.toString());
        }
        MethodInstance mi = maximal.iterator().next();
        return mi;
    }

    @Override
    @Deprecated
    public ConstructorInstance findConstructor(ClassType container, List<? extends Type> argTypes, Context c) throws SemanticException {
        return this.findConstructor(container, argTypes, c.currentClass());
    }

    @Override
    @Deprecated
    public ConstructorInstance findConstructor(ClassType container, List<? extends Type> argTypes, ClassType currClass) throws SemanticException {
        return this.findConstructor(container, argTypes, currClass, true);
    }

    @Override
    public ConstructorInstance findConstructor(ClassType container, List<? extends Type> argTypes, ClassType currClass, boolean fromClient) throws SemanticException {
        this.assert_(container);
        this.assert_(argTypes);
        List<? extends ConstructorInstance> acceptable = this.findAcceptableConstructors(container, argTypes, currClass, fromClient);
        if (acceptable.size() == 0) {
            throw new NoMemberException(2, "No valid constructor found for " + container + "(" + TypeSystem_c.listToString(argTypes) + ").");
        }
        Collection<? extends ConstructorInstance> maximal = this.findMostSpecificProcedures(acceptable);
        if (maximal.size() > 1) {
            throw new NoMemberException(2, "Reference to " + container + " is ambiguous, multiple " + "constructors match: " + maximal);
        }
        ConstructorInstance ci = maximal.iterator().next();
        return ci;
    }

    protected <I extends ProcedureInstance> I findProcedure(List<I> acceptable, ReferenceType container, List<Type> argTypes, ClassType currClass) throws SemanticException {
        Collection<I> maximal = this.findMostSpecificProcedures(acceptable);
        if (maximal.size() == 1) {
            return (I)((ProcedureInstance)maximal.iterator().next());
        }
        return null;
    }

    protected <Instance extends ProcedureInstance> Collection<Instance> findMostSpecificProcedures(List<Instance> acceptable) throws SemanticException {
        MostSpecificComparator<ProcedureInstance> msc = new MostSpecificComparator<ProcedureInstance>();
        acceptable = new ArrayList<Instance>(acceptable);
        Collections.sort(acceptable, msc);
        List<ProcedureInstance> maximal = new ArrayList<ProcedureInstance>(acceptable.size());
        Iterator<Instance> i = acceptable.iterator();
        ProcedureInstance first = (ProcedureInstance)i.next();
        maximal.add(first);
        while (i.hasNext()) {
            ProcedureInstance p = (ProcedureInstance)i.next();
            if (msc.compare(first, p) < 0) continue;
            maximal.add(p);
        }
        if (maximal.size() > 1) {
            Iterator j = maximal.iterator();
            ProcedureInstance firstDecl = first = (ProcedureInstance)j.next();
            if (first instanceof Declaration) {
                firstDecl = (ProcedureInstance)((Object)((Declaration)((Object)first)).declaration());
            }
            while (j.hasNext()) {
                ProcedureInstance p;
                ProcedureInstance pDecl = p = (ProcedureInstance)j.next();
                if (p instanceof Declaration) {
                    pDecl = (ProcedureInstance)((Object)((Declaration)((Object)p)).declaration());
                }
                if (firstDecl.hasFormals(pDecl.formalTypes())) continue;
                return maximal;
            }
            ArrayList<ProcedureInstance> notAbstract = new ArrayList<ProcedureInstance>(maximal.size());
            for (ProcedureInstance p : maximal) {
                if (p.flags().isAbstract()) continue;
                notAbstract.add(p);
            }
            if (notAbstract.size() == 1) {
                maximal = notAbstract;
            } else if (notAbstract.size() == 0) {
                j = maximal.iterator();
                first = (ProcedureInstance)j.next();
                SubtypeSet throwsSubsetType = new SubtypeSet(this, first.throwTypes());
                while (j.hasNext()) {
                    ProcedureInstance p;
                    p = (ProcedureInstance)j.next();
                    throwsSubsetType.retainAll(p.throwTypes());
                }
                LinkedList<Type> throwTypes = new LinkedList<Type>(throwsSubsetType);
                if (!first.throwTypes().equals(throwTypes)) {
                    first = Copy.Util.copy(first);
                    first.setThrowTypes(throwTypes);
                }
                maximal = Collections.singletonList(first);
            }
        }
        return maximal;
    }

    protected List<? extends MethodInstance> findAcceptableMethods(ReferenceType container, String name, List<? extends Type> argTypes, ClassType currClass, boolean fromClient) throws SemanticException {
        this.assert_(container);
        this.assert_(argTypes);
        NoMemberException error = null;
        ArrayList<MethodInstance> acceptable = new ArrayList<MethodInstance>();
        ArrayList<MethodInstance> unacceptable = new ArrayList<MethodInstance>();
        HashSet<? extends MethodInstance> overridden = new HashSet<MethodInstance>();
        HashSet<Type> visitedTypes = new HashSet<Type>();
        LinkedList<Type> typeQueue = new LinkedList<Type>();
        typeQueue.addLast(container);
        while (!typeQueue.isEmpty()) {
            Type type = (Type)typeQueue.removeFirst();
            if (visitedTypes.contains(type)) continue;
            visitedTypes.add(type);
            if (Report.should_report("types", 2)) {
                Report.report(2, "Searching type " + type + " for method " + name + "(" + TypeSystem_c.listToString(argTypes) + ")");
            }
            if (!type.isReference()) {
                throw new SemanticException("Cannot call method in  non-reference type " + type + ".");
            }
            for (MethodInstance methodInstance : type.toReference().methods()) {
                if (Report.should_report("types", 3)) {
                    Report.report(3, "Trying " + methodInstance);
                }
                if (!methodInstance.name().equals(name)) continue;
                if (this.methodCallValid(methodInstance, name, argTypes)) {
                    if (this.isMember(methodInstance, container.toReference()) && this.isAccessible(methodInstance, container, currClass, fromClient)) {
                        if (Report.should_report("types", 3)) {
                            Report.report(3, "->acceptable: " + methodInstance + " in " + methodInstance.container());
                        }
                        if (overridden.contains(methodInstance)) continue;
                        List<? extends MethodInstance> implemented = methodInstance.implemented();
                        overridden.addAll(implemented);
                        acceptable.removeAll(implemented);
                        acceptable.add(methodInstance);
                        continue;
                    }
                    unacceptable.add(methodInstance);
                    if (error != null) continue;
                    error = new NoMemberException(1, "Method " + methodInstance.signature() + " in " + container + " is inaccessible.");
                    continue;
                }
                if (error != null) continue;
                error = new NoMemberException(1, "Method " + methodInstance.signature() + " in " + container + " cannot be called with arguments " + "(" + TypeSystem_c.listToString(argTypes) + ").");
            }
            if (type.toReference().superType() != null) {
                typeQueue.addLast(type.toReference().superType());
            }
            typeQueue.addAll(type.toReference().interfaces());
        }
        if (error == null) {
            error = new NoMemberException(1, "No valid method call found for " + name + "(" + TypeSystem_c.listToString(argTypes) + ")" + " in " + container + ".");
        }
        if (acceptable.size() == 0) {
            throw error;
        }
        for (MethodInstance mi : unacceptable) {
            acceptable.removeAll(mi.overrides());
        }
        if (acceptable.size() == 0) {
            throw error;
        }
        return acceptable;
    }

    protected List<? extends ConstructorInstance> findAcceptableConstructors(ClassType container, List<? extends Type> argTypes, ClassType currClass, boolean fromClient) throws SemanticException {
        this.assert_(container);
        this.assert_(argTypes);
        NoMemberException error = null;
        ArrayList<ConstructorInstance> acceptable = new ArrayList<ConstructorInstance>();
        if (Report.should_report("types", 2)) {
            Report.report(2, "Searching type " + container + " for constructor " + container + "(" + TypeSystem_c.listToString(argTypes) + ")");
        }
        for (ConstructorInstance constructorInstance : container.constructors()) {
            if (Report.should_report("types", 3)) {
                Report.report(3, "Trying " + constructorInstance);
            }
            if (this.callValid(constructorInstance, argTypes)) {
                if (this.isAccessible((MemberInstance)constructorInstance, currClass, fromClient)) {
                    if (Report.should_report("types", 3)) {
                        Report.report(3, "->acceptable: " + constructorInstance);
                    }
                    acceptable.add(constructorInstance);
                    continue;
                }
                if (error != null) continue;
                error = new NoMemberException(2, "Constructor " + constructorInstance.signature() + " is inaccessible.");
                continue;
            }
            if (error != null) continue;
            error = new NoMemberException(2, "Constructor " + constructorInstance.signature() + " cannot be invoked with arguments " + "(" + TypeSystem_c.listToString(argTypes) + ").");
        }
        if (acceptable.size() == 0) {
            if (error == null) {
                error = new NoMemberException(2, "No valid constructor found for " + container + "(" + TypeSystem_c.listToString(argTypes) + ").");
            }
            throw error;
        }
        return acceptable;
    }

    @Override
    public boolean moreSpecific(ProcedureInstance p1, ProcedureInstance p2) {
        return p1.moreSpecificImpl(p2);
    }

    @Override
    public Type superType(ReferenceType type) {
        this.assert_(type);
        return type.superType();
    }

    @Override
    public List<? extends Type> interfaces(ReferenceType type) {
        this.assert_(type);
        return type.interfaces();
    }

    @Override
    public Type leastCommonAncestor(Type type1, Type type2) throws SemanticException {
        this.assert_(type1);
        this.assert_(type2);
        if (this.typeEquals(type1, type2)) {
            return type1;
        }
        if (type1.isNumeric() && type2.isNumeric()) {
            if (this.isImplicitCastValid(type1, type2)) {
                return type2;
            }
            if (this.isImplicitCastValid(type2, type1)) {
                return type1;
            }
            if (type1.isChar() && type2.isByte() || type1.isByte() && type2.isChar()) {
                return this.Int();
            }
            if (type1.isChar() && type2.isShort() || type1.isShort() && type2.isChar()) {
                return this.Int();
            }
        }
        if (type1.isArray() && type2.isArray()) {
            return this.arrayOf(this.leastCommonAncestor(type1.toArray().base(), type2.toArray().base()));
        }
        if (type1.isReference() && type2.isNull()) {
            return type1;
        }
        if (type2.isReference() && type1.isNull()) {
            return type2;
        }
        if (type1.isReference() && type2.isReference()) {
            Type t2;
            if (type1.isClass() && type1.toClass().flags().isInterface()) {
                return this.Object();
            }
            if (type2.isClass() && type2.toClass().flags().isInterface()) {
                return this.Object();
            }
            if (this.typeEquals(type1, this.Object())) {
                return type1;
            }
            if (this.typeEquals(type2, this.Object())) {
                return type2;
            }
            if (this.isSubtype(type1, type2)) {
                return type2;
            }
            if (this.isSubtype(type2, type1)) {
                return type1;
            }
            Type t1 = this.leastCommonAncestor(type1.toReference().superType(), type2);
            if (this.typeEquals(t1, t2 = this.leastCommonAncestor(type2.toReference().superType(), type1))) {
                return t1;
            }
            return this.Object();
        }
        throw new SemanticException("No least common ancestor found for types \"" + type1 + "\" and \"" + type2 + "\".");
    }

    @Override
    public boolean throwsSubset(ProcedureInstance p1, ProcedureInstance p2) {
        this.assert_(p1);
        this.assert_(p2);
        return p1.throwsSubsetImpl(p2);
    }

    @Override
    public boolean hasFormals(ProcedureInstance pi, List<? extends Type> formalTypes) {
        this.assert_(pi);
        this.assert_(formalTypes);
        return pi.hasFormalsImpl(formalTypes);
    }

    @Override
    public boolean hasMethod(ReferenceType t, MethodInstance mi) {
        this.assert_(t);
        this.assert_(mi);
        return t.hasMethodImpl(mi);
    }

    @Override
    public List<MethodInstance> overrides(MethodInstance mi) {
        return mi.overridesImpl();
    }

    @Override
    public List<MethodInstance> implemented(MethodInstance mi) {
        return mi.implementedImpl(mi.container());
    }

    @Override
    public boolean canOverride(MethodInstance mi, MethodInstance mj) {
        try {
            return mi.canOverrideImpl(mj, true);
        }
        catch (SemanticException e) {
            throw new InternalCompilerError(e);
        }
    }

    @Override
    public void checkOverride(MethodInstance mi, MethodInstance mj) throws SemanticException {
        mi.canOverrideImpl(mj, false);
    }

    @Override
    public boolean isSameMethod(MethodInstance m1, MethodInstance m2) {
        this.assert_(m1);
        this.assert_(m2);
        return m1.isSameMethodImpl(m2);
    }

    @Override
    public boolean methodCallValid(MethodInstance prototype, String name, List<? extends Type> argTypes) {
        this.assert_(prototype);
        this.assert_(argTypes);
        return prototype.methodCallValidImpl(name, argTypes);
    }

    @Override
    public boolean callValid(ProcedureInstance prototype, List<? extends Type> argTypes) {
        this.assert_(prototype);
        this.assert_(argTypes);
        return prototype.callValidImpl(argTypes);
    }

    @Override
    public NullType Null() {
        return this.NULL_;
    }

    @Override
    public PrimitiveType Void() {
        return this.VOID_;
    }

    @Override
    public PrimitiveType Boolean() {
        return this.BOOLEAN_;
    }

    @Override
    public PrimitiveType Char() {
        return this.CHAR_;
    }

    @Override
    public PrimitiveType Byte() {
        return this.BYTE_;
    }

    @Override
    public PrimitiveType Short() {
        return this.SHORT_;
    }

    @Override
    public PrimitiveType Int() {
        return this.INT_;
    }

    @Override
    public PrimitiveType Long() {
        return this.LONG_;
    }

    @Override
    public PrimitiveType Float() {
        return this.FLOAT_;
    }

    @Override
    public PrimitiveType Double() {
        return this.DOUBLE_;
    }

    protected ClassType load(String name) {
        try {
            return (ClassType)this.typeForName(name);
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Cannot find class \"" + name + "\"; " + e.getMessage(), e);
        }
    }

    @Override
    public Named forName(String name) throws SemanticException {
        return this.forName(this.systemResolver, name);
    }

    protected Named forName(Resolver resolver, String name) throws SemanticException {
        try {
            return resolver.find(name);
        }
        catch (SemanticException e) {
            if (!StringUtil.isNameShort(name)) {
                String containerName = StringUtil.getPackageComponent(name);
                String shortName = StringUtil.getShortNameComponent(name);
                try {
                    Named container = this.forName(resolver, containerName);
                    if (container instanceof ClassType) {
                        return this.classContextResolver((ClassType)container).find(shortName);
                    }
                }
                catch (SemanticException e2) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    @Override
    public Type typeForName(String name) throws SemanticException {
        return (Type)((Object)this.forName(name));
    }

    @Override
    public ClassType Object() {
        if (this.OBJECT_ != null) {
            return this.OBJECT_;
        }
        this.OBJECT_ = this.load("java.lang.Object");
        return this.OBJECT_;
    }

    @Override
    public ClassType Class() {
        if (this.CLASS_ != null) {
            return this.CLASS_;
        }
        this.CLASS_ = this.load("java.lang.Class");
        return this.CLASS_;
    }

    @Override
    public ClassType String() {
        if (this.STRING_ != null) {
            return this.STRING_;
        }
        this.STRING_ = this.load("java.lang.String");
        return this.STRING_;
    }

    @Override
    public ClassType Throwable() {
        if (this.THROWABLE_ != null) {
            return this.THROWABLE_;
        }
        this.THROWABLE_ = this.load("java.lang.Throwable");
        return this.THROWABLE_;
    }

    @Override
    public ClassType Error() {
        return this.load("java.lang.Error");
    }

    @Override
    public ClassType Exception() {
        return this.load("java.lang.Exception");
    }

    @Override
    public ClassType RuntimeException() {
        return this.load("java.lang.RuntimeException");
    }

    @Override
    public ClassType Cloneable() {
        return this.load("java.lang.Cloneable");
    }

    @Override
    public ClassType Serializable() {
        return this.load("java.io.Serializable");
    }

    @Override
    public ClassType NullPointerException() {
        return this.load("java.lang.NullPointerException");
    }

    @Override
    public ClassType ClassCastException() {
        return this.load("java.lang.ClassCastException");
    }

    @Override
    public ClassType OutOfBoundsException() {
        return this.load("java.lang.ArrayIndexOutOfBoundsException");
    }

    @Override
    public ClassType ArrayStoreException() {
        return this.load("java.lang.ArrayStoreException");
    }

    @Override
    public ClassType ArithmeticException() {
        return this.load("java.lang.ArithmeticException");
    }

    protected NullType createNull() {
        return new NullType_c(this);
    }

    protected PrimitiveType createPrimitive(PrimitiveType.Kind kind) {
        return new PrimitiveType_c((TypeSystem)this, kind);
    }

    @Override
    public Object placeHolder(TypeObject o) {
        return this.placeHolder(o, Collections.emptySet());
    }

    @Override
    public Object placeHolder(TypeObject o, Set<? extends TypeObject> roots) {
        this.assert_(o);
        if (o instanceof ParsedClassType) {
            ParsedClassType ct = (ParsedClassType)o;
            if (ct.isLocal() || ct.isAnonymous()) {
                throw new InternalCompilerError("Cannot serialize " + o + ".");
            }
            String name = this.getTransformedClassName(ct);
            return new PlaceHolder_c(name);
        }
        return o;
    }

    @Override
    public UnknownType unknownType(Position pos) {
        return this.unknownType;
    }

    @Override
    public UnknownPackage unknownPackage(Position pos) {
        return this.unknownPackage;
    }

    @Override
    public UnknownQualifier unknownQualifier(Position pos) {
        return this.unknownQualifier;
    }

    @Override
    public Package packageForName(Package prefix, String name) throws SemanticException {
        return this.createPackage(prefix, name);
    }

    @Override
    public Package packageForName(String name) throws SemanticException {
        if (name == null || name.equals("")) {
            return null;
        }
        String s = StringUtil.getShortNameComponent(name);
        String p = StringUtil.getPackageComponent(name);
        return this.packageForName(this.packageForName(p), s);
    }

    @Override
    @Deprecated
    public Package createPackage(Package prefix, String name) {
        this.assert_(prefix);
        return new Package_c(this, prefix, name);
    }

    @Override
    @Deprecated
    public Package createPackage(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        String s = StringUtil.getShortNameComponent(name);
        String p = StringUtil.getPackageComponent(name);
        return this.createPackage(this.createPackage(p), s);
    }

    @Override
    public ArrayType arrayOf(Type type) {
        this.assert_(type);
        return this.arrayOf(type.position(), type);
    }

    @Override
    public ArrayType arrayOf(Position pos, Type type) {
        this.assert_(type);
        return this.arrayType(pos, type);
    }

    protected ArrayType createArrayType(Position pos, Type type) {
        return new ArrayType_c(this, pos, type);
    }

    protected ArrayType arrayType(Position pos, Type type) {
        ArrayType t = this.arrayTypeCache.get(type);
        if (t == null) {
            t = this.createArrayType(pos, type);
            this.arrayTypeCache.put(type, t);
        }
        return t;
    }

    @Override
    public ArrayType arrayOf(Type type, int dims) {
        return this.arrayOf(null, type, dims);
    }

    @Override
    public ArrayType arrayOf(Position pos, Type type, int dims) {
        if (dims > 1) {
            return this.arrayOf(pos, this.arrayOf(pos, type, dims - 1));
        }
        if (dims == 1) {
            return this.arrayOf(pos, type);
        }
        throw new InternalCompilerError("Must call arrayOf(type, dims) with dims > 0");
    }

    public Type typeForClass(Class<?> clazz) throws SemanticException {
        return this.typeForClass(this.systemResolver, clazz);
    }

    protected Type typeForClass(Resolver resolver, Class<?> clazz) throws SemanticException {
        if (clazz == Void.TYPE) {
            return this.VOID_;
        }
        if (clazz == Boolean.TYPE) {
            return this.BOOLEAN_;
        }
        if (clazz == Byte.TYPE) {
            return this.BYTE_;
        }
        if (clazz == Character.TYPE) {
            return this.CHAR_;
        }
        if (clazz == Short.TYPE) {
            return this.SHORT_;
        }
        if (clazz == Integer.TYPE) {
            return this.INT_;
        }
        if (clazz == Long.TYPE) {
            return this.LONG_;
        }
        if (clazz == Float.TYPE) {
            return this.FLOAT_;
        }
        if (clazz == Double.TYPE) {
            return this.DOUBLE_;
        }
        if (clazz.isArray()) {
            return this.arrayOf(this.typeForClass(clazz.getComponentType()));
        }
        return (Type)((Object)resolver.find(clazz.getName()));
    }

    public Set<TypeObject> getTypeEncoderRootSet(TypeObject t) {
        return Collections.singleton(t);
    }

    @Override
    public String getTransformedClassName(ClassType ct) {
        StringBuffer sb = new StringBuffer(ct.fullName().length());
        if (!ct.isMember() && !ct.isTopLevel()) {
            return null;
        }
        while (ct.isMember()) {
            sb.insert(0, ct.name());
            sb.insert(0, '$');
            if ((ct = ct.outer()).isMember() || ct.isTopLevel()) continue;
            return null;
        }
        sb.insert(0, ct.fullName());
        return sb.toString();
    }

    @Override
    public String translatePackage(Resolver c, Package p) {
        return p.translate(c);
    }

    @Override
    public String translateArray(Resolver c, ArrayType t) {
        return t.translate(c);
    }

    @Override
    public String translateClass(Resolver c, ClassType t) {
        return t.translate(c);
    }

    @Override
    public String translatePrimitive(Resolver c, PrimitiveType t) {
        return t.translate(c);
    }

    @Override
    public PrimitiveType primitiveForName(String name) throws SemanticException {
        if (name.equals("void")) {
            return this.Void();
        }
        if (name.equals("boolean")) {
            return this.Boolean();
        }
        if (name.equals("char")) {
            return this.Char();
        }
        if (name.equals("byte")) {
            return this.Byte();
        }
        if (name.equals("short")) {
            return this.Short();
        }
        if (name.equals("int")) {
            return this.Int();
        }
        if (name.equals("long")) {
            return this.Long();
        }
        if (name.equals("float")) {
            return this.Float();
        }
        if (name.equals("double")) {
            return this.Double();
        }
        throw new SemanticException("Unrecognized primitive type \"" + name + "\".");
    }

    @Override
    public LazyClassInitializer defaultClassInitializer() {
        return new SchedulerClassInitializer(this);
    }

    @Override
    public LazyClassInitializer deserializedClassInitializer() {
        return new DeserializedClassInitializer(this);
    }

    @Override
    public final ParsedClassType createClassType() {
        return this.createClassType(this.defaultClassInitializer(), null);
    }

    @Override
    public final ParsedClassType createClassType(Source fromSource) {
        return this.createClassType(this.defaultClassInitializer(), fromSource);
    }

    @Override
    public final ParsedClassType createClassType(LazyClassInitializer init) {
        return this.createClassType(init, null);
    }

    @Override
    public ParsedClassType createClassType(LazyClassInitializer init, Source fromSource) {
        return new ParsedClassType_c(this, init, fromSource);
    }

    @Override
    public List<String> defaultPackageImports() {
        ArrayList<String> l = new ArrayList<String>(1);
        l.add("java.lang");
        return l;
    }

    @Override
    public PrimitiveType promote(Type t1, Type t2) throws SemanticException {
        if (!t1.isNumeric()) {
            throw new SemanticException("Cannot promote non-numeric type " + t1);
        }
        if (!t2.isNumeric()) {
            throw new SemanticException("Cannot promote non-numeric type " + t2);
        }
        return this.promoteNumeric(t1.toPrimitive(), t2.toPrimitive());
    }

    protected PrimitiveType promoteNumeric(PrimitiveType t1, PrimitiveType t2) {
        if (t1.isDouble() || t2.isDouble()) {
            return this.Double();
        }
        if (t1.isFloat() || t2.isFloat()) {
            return this.Float();
        }
        if (t1.isLong() || t2.isLong()) {
            return this.Long();
        }
        return this.Int();
    }

    @Override
    public PrimitiveType promote(Type t) throws SemanticException {
        if (!t.isNumeric()) {
            throw new SemanticException("Cannot promote non-numeric type " + t);
        }
        return this.promoteNumeric(t.toPrimitive());
    }

    protected PrimitiveType promoteNumeric(PrimitiveType t) {
        if (t.isByte() || t.isShort() || t.isChar()) {
            return this.Int();
        }
        return t.toPrimitive();
    }

    @Override
    public Flags legalAccessFlags() {
        return this.Public().Protected().Private();
    }

    @Override
    public Flags legalLocalFlags() {
        return this.Final();
    }

    @Override
    public Flags legalFieldFlags() {
        return this.legalAccessFlags().Static().Final().Transient().Volatile();
    }

    @Override
    public Flags legalConstructorFlags() {
        return this.legalAccessFlags();
    }

    @Override
    public Flags legalInitializerFlags() {
        return this.Static();
    }

    @Override
    public Flags legalMethodFlags() {
        return this.legalAccessFlags().Abstract().Static().Final().Native().Synchronized().StrictFP();
    }

    @Override
    public Flags legalAbstractMethodFlags() {
        return this.legalAccessFlags().clear(this.Private()).Abstract();
    }

    @Override
    public Flags legalTopLevelClassFlags() {
        return this.Public().Abstract().Final().StrictFP().Interface();
    }

    @Override
    public Flags legalMemberClassFlags() {
        return this.legalAccessFlags().Static().Abstract().Final().StrictFP().Interface();
    }

    @Override
    public Flags legalLocalClassFlags() {
        return this.Abstract().Final().StrictFP().Interface();
    }

    @Override
    public Flags legalInterfaceFieldFlags() {
        return this.Public().Static().Final();
    }

    @Override
    public void checkMethodFlags(Flags f) throws SemanticException {
        if (!f.clear(this.METHOD_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare method with flags " + f.clear(this.METHOD_FLAGS) + ".");
        }
        if (f.isAbstract() && !f.clear(this.ABSTRACT_METHOD_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare abstract method with flags " + f.clear(this.ABSTRACT_METHOD_FLAGS) + ".");
        }
        if (f.isNative() && f.isStrictFP()) {
            throw new SemanticException("Method cannot be both native and strictfp.");
        }
        this.checkAccessFlags(f);
    }

    @Override
    public void checkLocalFlags(Flags f) throws SemanticException {
        if (!f.clear(this.LOCAL_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare local variable with flags " + f.clear(this.LOCAL_FLAGS) + ".");
        }
    }

    @Override
    public void checkFieldFlags(Flags f) throws SemanticException {
        if (!f.clear(this.FIELD_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare field with flags " + f.clear(this.FIELD_FLAGS) + ".");
        }
        if (f.isFinal() && f.isVolatile()) {
            throw new SemanticException("Field cannot be both final and volatile.");
        }
        this.checkAccessFlags(f);
    }

    @Override
    public void checkConstructorFlags(Flags f) throws SemanticException {
        if (!f.clear(this.CONSTRUCTOR_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare constructor with flags " + f.clear(this.CONSTRUCTOR_FLAGS) + ".");
        }
        this.checkAccessFlags(f);
    }

    @Override
    public void checkInitializerFlags(Flags f) throws SemanticException {
        if (!f.clear(this.INITIALIZER_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare initializer with flags " + f.clear(this.INITIALIZER_FLAGS) + ".");
        }
    }

    @Override
    public void checkTopLevelClassFlags(Flags f) throws SemanticException {
        Flags remainingFlags = f.clear(this.TOP_LEVEL_CLASS_FLAGS);
        if (!remainingFlags.equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare a top-level " + (f.isInterface() ? "interface" : "class") + " with flag(s) " + remainingFlags + ".");
        }
        this.checkClassFlagsConflict(f);
        this.checkAccessFlags(f);
    }

    @Override
    public void checkMemberClassFlags(Flags f) throws SemanticException {
        if (!f.clear(this.MEMBER_CLASS_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare a member class with flag(s) " + f.clear(this.MEMBER_CLASS_FLAGS) + ".");
        }
        this.checkClassFlagsConflict(f);
        this.checkAccessFlags(f);
    }

    @Override
    public void checkLocalClassFlags(Flags f) throws SemanticException {
        if (f.isInterface()) {
            throw new SemanticException("Cannot declare a local interface.");
        }
        if (!f.clear(this.LOCAL_CLASS_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare a local class with flag(s) " + f.clear(this.LOCAL_CLASS_FLAGS) + ".");
        }
        this.checkClassFlagsConflict(f);
        this.checkAccessFlags(f);
    }

    protected void checkClassFlagsConflict(Flags f) throws SemanticException {
        if (f.isAbstract() && f.isFinal()) {
            throw new SemanticException("Class cannot be both abstract and final");
        }
    }

    @Override
    public void checkAccessFlags(Flags f) throws SemanticException {
        int count = 0;
        if (f.isPublic()) {
            ++count;
        }
        if (f.isProtected()) {
            ++count;
        }
        if (f.isPrivate()) {
            ++count;
        }
        if (count > 1) {
            throw new SemanticException("Invalid access flags: " + f.retain(this.ACCESS_FLAGS) + ".");
        }
    }

    protected List<ReferenceType> abstractSuperInterfaces(ReferenceType rt) {
        ClassType c;
        LinkedList<ReferenceType> superInterfaces = new LinkedList<ReferenceType>();
        superInterfaces.add(rt);
        List<? extends ReferenceType> interfaces = rt.interfaces();
        for (ReferenceType referenceType : interfaces) {
            superInterfaces.addAll(this.abstractSuperInterfaces(referenceType));
        }
        if (rt.superType() != null && (c = rt.superType().toClass()).flags().isAbstract()) {
            superInterfaces.addAll(this.abstractSuperInterfaces(c));
        }
        return superInterfaces;
    }

    @Override
    public void checkClassConformance(ClassType ct) throws SemanticException {
        List<ReferenceType> superInterfaces = this.abstractSuperInterfaces(ct);
        HashMap<String, MethodInstance> signatureMap = new HashMap<String, MethodInstance>();
        for (ReferenceType rt : superInterfaces) {
            for (MethodInstance methodInstance : rt.methods()) {
                if (!methodInstance.flags().isAbstract()) continue;
                MethodInstance mj = this.findImplementingMethod(ct, methodInstance);
                if (mj == null) {
                    if (!ct.flags().isAbstract()) {
                        throw new SemanticException(ct.fullName() + " should be " + "declared abstract; it does not define " + methodInstance.signature() + ", which is declared in " + rt.toClass().fullName(), ct.position());
                    }
                    if (!this.isInherited(methodInstance, ct)) continue;
                    String signature = methodInstance.signature();
                    if (signatureMap.containsKey(signature)) {
                        mj = (MethodInstance)signatureMap.get(signature);
                        if (this.returnTypesConsistent(methodInstance, mj)) continue;
                        throw new SemanticException("Types " + mj.container() + " and " + methodInstance.container() + " are incompatible; both define " + signature + ", but with unrelated return types.");
                    }
                    signatureMap.put(signature, methodInstance);
                    continue;
                }
                if (this.equals(ct, mj.container()) || this.equals(ct, methodInstance.container())) continue;
                try {
                    this.checkOverride(mj, methodInstance);
                }
                catch (SemanticException e) {
                    throw new SemanticException(e.getMessage(), ct.position());
                }
            }
        }
    }

    protected boolean returnTypesConsistent(MethodInstance mi, MethodInstance mj) {
        return this.typeEquals(mi.returnType(), mj.returnType());
    }

    @Override
    public void checkInterfaceFieldFlags(ClassType ct) throws SemanticException {
        if (!ct.flags().isInterface()) {
            return;
        }
        for (FieldInstance fieldInstance : ct.fields()) {
            Flags f = fieldInstance.flags();
            if (f.clear(this.INTERFACE_FIELD_FLAGS).equals(Flags.NONE)) continue;
            throw new SemanticException("Cannot declare an interface constant with flag(s) " + f.clear(this.INTERFACE_FIELD_FLAGS) + ".", fieldInstance.position());
        }
    }

    @Override
    public MethodInstance findImplementingMethod(ClassType ct, MethodInstance mi) {
        ClassType curr = ct;
        while (curr != null) {
            List<? extends MethodInstance> possible = curr.methods(mi.name(), mi.formalTypes());
            for (MethodInstance methodInstance : possible) {
                if ((!this.isAccessible((MemberInstance)mi, ct) || !this.isAccessible((MemberInstance)methodInstance, ct)) && !this.isAccessible((MemberInstance)mi, methodInstance.container().toClass())) continue;
                if (!methodInstance.flags().isAbstract()) {
                    return methodInstance;
                }
                if (curr != ct && curr != mi.container()) continue;
                return null;
            }
            curr = curr.superType() == null ? null : curr.superType().toReference();
        }
        return null;
    }

    @Override
    public Type staticTarget(Type t) {
        return t;
    }

    protected void initFlags() {
        this.flagsForName = new HashMap<String, Flags>();
        this.flagsForName.put("public", Flags.PUBLIC);
        this.flagsForName.put("private", Flags.PRIVATE);
        this.flagsForName.put("protected", Flags.PROTECTED);
        this.flagsForName.put("static", Flags.STATIC);
        this.flagsForName.put("final", Flags.FINAL);
        this.flagsForName.put("synchronized", Flags.SYNCHRONIZED);
        this.flagsForName.put("transient", Flags.TRANSIENT);
        this.flagsForName.put("native", Flags.NATIVE);
        this.flagsForName.put("interface", Flags.INTERFACE);
        this.flagsForName.put("abstract", Flags.ABSTRACT);
        this.flagsForName.put("volatile", Flags.VOLATILE);
        this.flagsForName.put("strictfp", Flags.STRICTFP);
    }

    @Override
    public Flags createNewFlag(String name, Flags after) {
        Flags f = Flags.createFlag(name, after);
        this.flagsForName.put(name, f);
        return f;
    }

    @Override
    public Flags NoFlags() {
        return Flags.NONE;
    }

    @Override
    public Flags Public() {
        return Flags.PUBLIC;
    }

    @Override
    public Flags Private() {
        return Flags.PRIVATE;
    }

    @Override
    public Flags Protected() {
        return Flags.PROTECTED;
    }

    @Override
    public Flags Static() {
        return Flags.STATIC;
    }

    @Override
    public Flags Final() {
        return Flags.FINAL;
    }

    @Override
    public Flags Synchronized() {
        return Flags.SYNCHRONIZED;
    }

    @Override
    public Flags Transient() {
        return Flags.TRANSIENT;
    }

    @Override
    public Flags Native() {
        return Flags.NATIVE;
    }

    @Override
    public Flags Interface() {
        return Flags.INTERFACE;
    }

    @Override
    public Flags Abstract() {
        return Flags.ABSTRACT;
    }

    @Override
    public Flags Volatile() {
        return Flags.VOLATILE;
    }

    @Override
    public Flags StrictFP() {
        return Flags.STRICTFP;
    }

    @Override
    public Flags flagsForBits(int bits) {
        Flags f = Flags.NONE;
        if ((bits & 1) != 0) {
            f = f.Public();
        }
        if ((bits & 2) != 0) {
            f = f.Private();
        }
        if ((bits & 4) != 0) {
            f = f.Protected();
        }
        if ((bits & 8) != 0) {
            f = f.Static();
        }
        if ((bits & 0x10) != 0) {
            f = f.Final();
        }
        if ((bits & 0x20) != 0) {
            f = f.Synchronized();
        }
        if ((bits & 0x80) != 0) {
            f = f.Transient();
        }
        if ((bits & 0x100) != 0) {
            f = f.Native();
        }
        if ((bits & 0x200) != 0) {
            f = f.Interface();
        }
        if ((bits & 0x400) != 0) {
            f = f.Abstract();
        }
        if ((bits & 0x40) != 0) {
            f = f.Volatile();
        }
        if ((bits & 0x800) != 0) {
            f = f.StrictFP();
        }
        return f;
    }

    public Flags flagsForName(String name) {
        Flags f = this.flagsForName.get(name);
        if (f == null) {
            throw new InternalCompilerError("No flag named \"" + name + "\".");
        }
        return f;
    }

    public String toString() {
        return StringUtil.getShortNameComponent(this.getClass().getName());
    }

    protected static class MostSpecificComparator<T extends ProcedureInstance>
    implements Comparator<T> {
        protected MostSpecificComparator() {
        }

        @Override
        public int compare(T p1, T p2) {
            boolean p1beatsp2 = p1.moreSpecific((ProcedureInstance)p2);
            boolean p2beatsp1 = p2.moreSpecific((ProcedureInstance)p1);
            if (p1beatsp2 && !p2beatsp1) {
                return -1;
            }
            if (p2beatsp1 && !p1beatsp2) {
                return 1;
            }
            return 0;
        }
    }
}

