/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Source;
import polyglot.types.AccessControlResolver;
import polyglot.types.ArrayType;
import polyglot.types.CachingResolver;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.ImportTable;
import polyglot.types.InitializerInstance;
import polyglot.types.LazyClassInitializer;
import polyglot.types.LocalInstance;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Named;
import polyglot.types.NullType;
import polyglot.types.Package;
import polyglot.types.ParsedClassType;
import polyglot.types.PrimitiveType;
import polyglot.types.ProcedureInstance;
import polyglot.types.ReferenceType;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.SystemResolver;
import polyglot.types.TopLevelResolver;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.UnknownPackage;
import polyglot.types.UnknownQualifier;
import polyglot.types.UnknownType;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.ClassFileLazyClassInitializer;
import polyglot.util.Position;

public interface TypeSystem {
    public static final boolean SERIALIZE_MEMBERS_WITH_CONTAINER = false;

    public void initialize(TopLevelResolver var1, ExtensionInfo var2) throws SemanticException;

    public ExtensionInfo extensionInfo();

    public SystemResolver systemResolver();

    @Deprecated
    public CachingResolver parsedResolver();

    public SystemResolver saveSystemResolver();

    public void restoreSystemResolver(SystemResolver var1);

    public TopLevelResolver loadedResolver();

    public ClassFileLazyClassInitializer classFileLazyClassInitializer(ClassFile var1);

    public ImportTable importTable(String var1, Package var2);

    public ImportTable importTable(Package var1);

    public List<String> defaultPackageImports();

    public boolean packageExists(String var1);

    public Named forName(String var1) throws SemanticException;

    public Type typeForName(String var1) throws SemanticException;

    public InitializerInstance initializerInstance(Position var1, ClassType var2, Flags var3);

    public ConstructorInstance constructorInstance(Position var1, ClassType var2, Flags var3, List<? extends Type> var4, List<? extends Type> var5);

    public MethodInstance methodInstance(Position var1, ReferenceType var2, Flags var3, Type var4, String var5, List<? extends Type> var6, List<? extends Type> var7);

    public FieldInstance fieldInstance(Position var1, ReferenceType var2, Flags var3, Type var4, String var5);

    public LocalInstance localInstance(Position var1, Flags var2, Type var3, String var4);

    public ConstructorInstance defaultConstructor(Position var1, ClassType var2);

    public UnknownType unknownType(Position var1);

    public UnknownPackage unknownPackage(Position var1);

    public UnknownQualifier unknownQualifier(Position var1);

    public boolean isSubtype(Type var1, Type var2);

    public boolean descendsFrom(Type var1, Type var2);

    public boolean isCastValid(Type var1, Type var2);

    public boolean isImplicitCastValid(Type var1, Type var2);

    public boolean equals(TypeObject var1, TypeObject var2);

    public boolean typeEquals(Type var1, Type var2);

    public boolean packageEquals(Package var1, Package var2);

    @Deprecated
    public boolean numericConversionValid(Type var1, long var2);

    public boolean numericConversionValid(Type var1, Object var2);

    public Type leastCommonAncestor(Type var1, Type var2) throws SemanticException;

    public boolean isCanonical(Type var1);

    public boolean isAccessible(MemberInstance var1, Context var2);

    public boolean isAccessible(MemberInstance var1, ClassType var2);

    public boolean isAccessible(MemberInstance var1, ClassType var2, boolean var3);

    public boolean isAccessible(MemberInstance var1, ReferenceType var2, ClassType var3);

    public boolean isAccessible(MemberInstance var1, ReferenceType var2, ReferenceType var3, boolean var4);

    public boolean classAccessible(ClassType var1, Context var2);

    public boolean classAccessible(ClassType var1, ClassType var2);

    public boolean classAccessibleFromPackage(ClassType var1, Package var2);

    public boolean isEnclosed(ClassType var1, ClassType var2);

    public boolean hasEnclosingInstance(ClassType var1, ClassType var2);

    public boolean isMember(MemberInstance var1, ReferenceType var2);

    public boolean isInherited(MemberInstance var1, ReferenceType var2);

    public boolean canCoerceToString(Type var1, Context var2);

    public boolean isThrowable(Type var1);

    public boolean isUncheckedException(Type var1);

    public Collection<Type> uncheckedExceptions();

    public PrimitiveType promote(Type var1) throws SemanticException;

    public PrimitiveType promote(Type var1, Type var2) throws SemanticException;

    @Deprecated
    public FieldInstance findField(ReferenceType var1, String var2, Context var3) throws SemanticException;

    @Deprecated
    public FieldInstance findField(ReferenceType var1, String var2, ClassType var3) throws SemanticException;

    public FieldInstance findField(ReferenceType var1, String var2, ClassType var3, boolean var4) throws SemanticException;

    @Deprecated
    public FieldInstance findField(ReferenceType var1, String var2) throws SemanticException;

    @Deprecated
    public MethodInstance findMethod(ReferenceType var1, String var2, List<? extends Type> var3, Context var4) throws SemanticException;

    @Deprecated
    public MethodInstance findMethod(ReferenceType var1, String var2, List<? extends Type> var3, ClassType var4) throws SemanticException;

    public MethodInstance findMethod(ReferenceType var1, String var2, List<? extends Type> var3, ClassType var4, boolean var5) throws SemanticException;

    @Deprecated
    public ConstructorInstance findConstructor(ClassType var1, List<? extends Type> var2, Context var3) throws SemanticException;

    @Deprecated
    public ConstructorInstance findConstructor(ClassType var1, List<? extends Type> var2, ClassType var3) throws SemanticException;

    public ConstructorInstance findConstructor(ClassType var1, List<? extends Type> var2, ClassType var3, boolean var4) throws SemanticException;

    public ClassType findMemberClass(ClassType var1, String var2, ClassType var3) throws SemanticException;

    @Deprecated
    public ClassType findMemberClass(ClassType var1, String var2, Context var3) throws SemanticException;

    public ClassType findMemberClass(ClassType var1, String var2) throws SemanticException;

    public Type superType(ReferenceType var1);

    public List<? extends Type> interfaces(ReferenceType var1);

    public boolean throwsSubset(ProcedureInstance var1, ProcedureInstance var2);

    public boolean hasMethod(ReferenceType var1, MethodInstance var2);

    public boolean hasMethodNamed(ReferenceType var1, String var2);

    public boolean hasAccessibleMethodNamed(ReferenceType var1, String var2, ClassType var3);

    public boolean isSameMethod(MethodInstance var1, MethodInstance var2);

    public boolean moreSpecific(ProcedureInstance var1, ProcedureInstance var2);

    public boolean hasFormals(ProcedureInstance var1, List<? extends Type> var2);

    public NullType Null();

    public PrimitiveType Void();

    public PrimitiveType Boolean();

    public PrimitiveType Char();

    public PrimitiveType Byte();

    public PrimitiveType Short();

    public PrimitiveType Int();

    public PrimitiveType Long();

    public PrimitiveType Float();

    public PrimitiveType Double();

    public ClassType Object();

    public ClassType String();

    public ClassType Class();

    public ClassType Throwable();

    public ClassType Error();

    public ClassType Exception();

    public ClassType RuntimeException();

    public ClassType Cloneable();

    public ClassType Serializable();

    public ClassType NullPointerException();

    public ClassType ClassCastException();

    public ClassType OutOfBoundsException();

    public ClassType ArrayStoreException();

    public ClassType ArithmeticException();

    public ArrayType arrayOf(Type var1);

    public ArrayType arrayOf(Position var1, Type var2);

    public ArrayType arrayOf(Type var1, int var2);

    public ArrayType arrayOf(Position var1, Type var2, int var3);

    public Package packageForName(String var1) throws SemanticException;

    public Package packageForName(Package var1, String var2) throws SemanticException;

    public Package createPackage(String var1);

    public Package createPackage(Package var1, String var2);

    public Context createContext();

    public Resolver packageContextResolver(Package var1, ClassType var2);

    public Resolver packageContextResolver(Package var1);

    public AccessControlResolver createPackageContextResolver(Package var1);

    @Deprecated
    public Resolver packageContextResolver(Resolver var1, Package var2);

    public Resolver classContextResolver(ClassType var1, ClassType var2);

    public Resolver classContextResolver(ClassType var1);

    public AccessControlResolver createClassContextResolver(ClassType var1);

    public LazyClassInitializer defaultClassInitializer();

    public LazyClassInitializer deserializedClassInitializer();

    public ParsedClassType createClassType(LazyClassInitializer var1);

    public ParsedClassType createClassType();

    public ParsedClassType createClassType(LazyClassInitializer var1, Source var2);

    public ParsedClassType createClassType(Source var1);

    public Set<? extends TypeObject> getTypeEncoderRootSet(TypeObject var1);

    public String getTransformedClassName(ClassType var1);

    public Object placeHolder(TypeObject var1, Set<? extends TypeObject> var2);

    public Object placeHolder(TypeObject var1);

    public String translatePackage(Resolver var1, Package var2);

    public String translatePrimitive(Resolver var1, PrimitiveType var2);

    public String translateArray(Resolver var1, ArrayType var2);

    public String translateClass(Resolver var1, ClassType var2);

    public String wrapperTypeString(PrimitiveType var1);

    public boolean methodCallValid(MethodInstance var1, String var2, List<? extends Type> var3);

    public boolean callValid(ProcedureInstance var1, List<? extends Type> var2);

    public List<MethodInstance> overrides(MethodInstance var1);

    public boolean canOverride(MethodInstance var1, MethodInstance var2);

    public void checkOverride(MethodInstance var1, MethodInstance var2) throws SemanticException;

    public List<MethodInstance> implemented(MethodInstance var1);

    public PrimitiveType primitiveForName(String var1) throws SemanticException;

    public Flags legalAccessFlags();

    public Flags legalLocalFlags();

    public Flags legalFieldFlags();

    public Flags legalConstructorFlags();

    public Flags legalInitializerFlags();

    public Flags legalMethodFlags();

    public Flags legalAbstractMethodFlags();

    public Flags legalTopLevelClassFlags();

    public Flags legalMemberClassFlags();

    public Flags legalLocalClassFlags();

    public Flags legalInterfaceFieldFlags();

    public void checkMethodFlags(Flags var1) throws SemanticException;

    public void checkLocalFlags(Flags var1) throws SemanticException;

    public void checkFieldFlags(Flags var1) throws SemanticException;

    public void checkConstructorFlags(Flags var1) throws SemanticException;

    public void checkInitializerFlags(Flags var1) throws SemanticException;

    public void checkTopLevelClassFlags(Flags var1) throws SemanticException;

    public void checkMemberClassFlags(Flags var1) throws SemanticException;

    public void checkLocalClassFlags(Flags var1) throws SemanticException;

    public void checkAccessFlags(Flags var1) throws SemanticException;

    public void checkCycles(ReferenceType var1) throws SemanticException;

    public void checkClassConformance(ClassType var1) throws SemanticException;

    public void checkInterfaceFieldFlags(ClassType var1) throws SemanticException;

    public MethodInstance findImplementingMethod(ClassType var1, MethodInstance var2);

    public Type staticTarget(Type var1);

    public Flags flagsForBits(int var1);

    public Flags createNewFlag(String var1, Flags var2);

    public Flags NoFlags();

    public Flags Public();

    public Flags Protected();

    public Flags Private();

    public Flags Static();

    public Flags Final();

    public Flags Synchronized();

    public Flags Transient();

    public Flags Native();

    public Flags Interface();

    public Flags Abstract();

    public Flags Volatile();

    public Flags StrictFP();
}

