/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import polyglot.types.CachingResolver;
import polyglot.types.Declaration;
import polyglot.types.Package;
import polyglot.types.Resolver;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeObject_c;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.SerialVersionUID;

public class Package_c
extends TypeObject_c
implements Package {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Package prefix;
    protected String name;
    protected String fullname = null;
    protected transient Resolver memberCache;
    protected Package decl;

    protected Package_c() {
    }

    public Package_c(TypeSystem ts) {
        this(ts, null, null);
    }

    public Package_c(TypeSystem ts, String name) {
        this(ts, null, name);
    }

    public Package_c(TypeSystem ts, Package prefix, String name) {
        super(ts);
        this.prefix = prefix;
        this.name = name;
        this.decl = this;
    }

    @Override
    public Resolver resolver() {
        if (this.memberCache == null) {
            this.memberCache = new CachingResolver(this.ts.createPackageContextResolver(this));
        }
        return this.memberCache;
    }

    @Override
    public Package_c copy() {
        Package_c n = (Package_c)super.copy();
        n.memberCache = null;
        return n;
    }

    @Override
    public Declaration declaration() {
        return this.decl;
    }

    @Override
    public void setDeclaration(Declaration decl) {
        this.decl = (Package)decl;
    }

    @Override
    public boolean equalsImpl(TypeObject o) {
        Package p;
        if (o instanceof Package && this.name.equals((p = (Package)o).name())) {
            if (this.prefix == null) {
                return p.prefix() == null;
            }
            return this.ts.equals(this.prefix, p.prefix());
        }
        return false;
    }

    @Override
    public final boolean packageEquals(Package p) {
        return this.ts.packageEquals(this, p);
    }

    @Override
    public boolean packageEqualsImpl(Package p) {
        if (this.name.equals(p.name())) {
            if (this.prefix == null) {
                return p.prefix() == null;
            }
            return this.ts.packageEquals(this.prefix, p.prefix());
        }
        return false;
    }

    @Override
    public boolean isType() {
        return false;
    }

    @Override
    public boolean isPackage() {
        return true;
    }

    @Override
    public Type toType() {
        return null;
    }

    @Override
    public Package toPackage() {
        return this;
    }

    @Override
    public Package prefix() {
        return this.prefix;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String translate(Resolver c) {
        if (this.prefix() == null) {
            return this.name();
        }
        return this.prefix().translate(c) + "." + this.name();
    }

    @Override
    public String fullName() {
        if (this.fullname == null) {
            this.fullname = this.prefix() == null ? this.name : this.prefix().fullName() + "." + this.name;
        }
        return this.fullname;
    }

    public String toString() {
        return this.prefix() == null ? this.name : this.prefix().toString() + "." + this.name;
    }

    @Override
    public void print(CodeWriter w) {
        if (this.prefix() != null) {
            this.prefix().print(w);
            w.write(".");
            w.allowBreak(2, 3, "", 0);
        }
        w.write(this.name);
    }

    @Override
    public int hashCode() {
        return this.name != null ? this.name.hashCode() : -78642;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }
}

