/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import polyglot.ast.JLangToJLDel;
import polyglot.ast.Lang;
import polyglot.main.Report;
import polyglot.types.ClassType;
import polyglot.types.CodeInstance;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.ImportTable;
import polyglot.types.LocalInstance;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Named;
import polyglot.types.NoMemberException;
import polyglot.types.Package;
import polyglot.types.ParsedClassType;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.CollectionUtil;
import polyglot.util.Enum;
import polyglot.util.InternalCompilerError;
import polyglot.util.SerialVersionUID;

public class Context_c
implements Context {
    protected Context outer;
    private final Lang lang;
    protected TypeSystem ts;
    public static final Kind BLOCK = new Kind("block");
    public static final Kind CLASS = new Kind("class");
    public static final Kind CODE = new Kind("code");
    public static final Kind LABEL = new Kind("label");
    public static final Kind OUTER = new Kind("outer");
    public static final Kind SOURCE = new Kind("source");
    protected ImportTable it;
    protected Kind kind;
    protected ClassType type;
    protected ParsedClassType scope;
    protected CodeInstance code;
    protected String label;
    protected Map<String, Named> types;
    protected Map<String, VarInstance> vars;
    protected boolean inCode;
    protected boolean staticContext;
    private static final Collection<String> TOPICS = CollectionUtil.list("types", "context");

    @Deprecated
    public Context_c(TypeSystem ts) {
        this(JLangToJLDel.instance, ts);
    }

    public Context_c(Lang lang, TypeSystem ts) {
        this.lang = lang;
        this.ts = ts;
        this.outer = null;
        this.kind = OUTER;
    }

    public boolean isBlock() {
        return this.kind == BLOCK;
    }

    public boolean isClass() {
        return this.kind == CLASS;
    }

    public boolean isCode() {
        return this.kind == CODE;
    }

    public boolean isOuter() {
        return this.kind == OUTER;
    }

    public boolean isSource() {
        return this.kind == SOURCE;
    }

    @Override
    public Lang lang() {
        return this.lang;
    }

    @Override
    public TypeSystem typeSystem() {
        return this.ts;
    }

    @Override
    public Context copy() {
        try {
            return (Context)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalCompilerError("Java clone() weirdness.");
        }
    }

    protected Context_c push() {
        Context_c v = (Context_c)this.copy();
        v.outer = this;
        v.types = null;
        v.vars = null;
        v.label = null;
        return v;
    }

    @Override
    @Deprecated
    public Resolver outerResolver() {
        return this.ts.systemResolver();
    }

    @Override
    public ImportTable importTable() {
        return this.it;
    }

    @Override
    public Package package_() {
        return this.importTable().package_();
    }

    @Override
    public CodeInstance definingCodeDef(String name) {
        if ((this.isBlock() || this.isCode()) && (this.findVariableInThisScope(name) != null || this.findInThisScope(name) != null)) {
            return this.currentCode();
        }
        if (this.outer == null) {
            return null;
        }
        return this.outer.definingCodeDef(name);
    }

    @Override
    public boolean isLocal(String name) {
        if (this.isClass()) {
            return false;
        }
        if ((this.isBlock() || this.isCode()) && (this.findVariableInThisScope(name) != null || this.findInThisScope(name) != null)) {
            return true;
        }
        if (this.isCode()) {
            return false;
        }
        if (this.outer == null) {
            return false;
        }
        return this.outer.isLocal(name);
    }

    @Override
    public MethodInstance findMethod(String name, List<? extends Type> argTypes) throws SemanticException {
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "find-method " + name + argTypes + " in " + this);
        }
        if (this.currentClass() != null && this.ts.hasAccessibleMethodNamed(this.currentClass(), name, this.currentClass())) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find-method " + name + argTypes + " -> " + this.currentClass());
            }
            return this.ts.findMethod(this.currentClass(), name, argTypes, this.currentClass(), false);
        }
        if (this.outer != null) {
            return this.outer.findMethod(name, argTypes);
        }
        throw new SemanticException("Method " + name + " not found.");
    }

    @Override
    public LocalInstance findLocal(String name) throws SemanticException {
        LocalInstance vi = this.findLocalSilent(name);
        if (vi == null) {
            throw new SemanticException("Local " + name + " not found.");
        }
        return vi;
    }

    @Override
    public LocalInstance findLocalSilent(String name) {
        VarInstance vi = this.findVariableSilent(name);
        if (vi instanceof LocalInstance) {
            return (LocalInstance)vi;
        }
        return null;
    }

    @Override
    public ClassType findFieldScope(String name) throws SemanticException {
        VarInstance vi;
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "find-field-scope " + name + " in " + this);
        }
        if ((vi = this.findVariableInThisScope(name)) instanceof FieldInstance) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find-field-scope " + name + " in " + vi);
            }
            return this.type;
        }
        if (vi == null && this.outer != null) {
            return this.outer.findFieldScope(name);
        }
        throw new SemanticException("Field " + name + " not found.");
    }

    @Override
    public ClassType findMethodScope(String name) throws SemanticException {
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "find-method-scope " + name + " in " + this);
        }
        if (this.currentClass() != null && this.ts.hasAccessibleMethodNamed(this.currentClass(), name, this.currentClass())) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find-method-scope " + name + " -> " + this.currentClass());
            }
            return this.currentClass();
        }
        if (this.outer != null) {
            return this.outer.findMethodScope(name);
        }
        throw new SemanticException("Method " + name + " not found.");
    }

    @Override
    public FieldInstance findField(String name) throws SemanticException {
        VarInstance vi = this.findVariableSilent(name);
        if (vi instanceof FieldInstance) {
            FieldInstance fi = (FieldInstance)vi;
            if (!this.ts.isAccessible((MemberInstance)fi, this)) {
                throw new SemanticException("Field " + name + " not accessible.");
            }
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find-field " + name + " -> " + fi);
            }
            return fi;
        }
        throw new NoMemberException(3, "Field " + name + " not found.");
    }

    @Override
    public VarInstance findVariable(String name) throws SemanticException {
        VarInstance vi = this.findVariableSilent(name);
        if (vi != null) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find-var " + name + " -> " + vi);
            }
            return vi;
        }
        throw new SemanticException("Variable " + name + " not found.");
    }

    @Override
    public VarInstance findVariableSilent(String name) {
        VarInstance vi;
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "find-var " + name + " in " + this);
        }
        if ((vi = this.findVariableInThisScope(name)) != null) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find-var " + name + " -> " + vi);
            }
            return vi;
        }
        if (this.outer != null) {
            return this.outer.findVariableSilent(name);
        }
        return null;
    }

    @Override
    public String findLabelSilent(String label) {
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "find-label " + label + " in " + this);
        }
        if (this.isCode()) {
            return null;
        }
        if (this.label != null && this.label.equals(label)) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find-label " + label + " -> " + this.label);
            }
            return this.label;
        }
        if (this.outer != null) {
            return this.outer.findLabelSilent(label);
        }
        return null;
    }

    protected String mapsToString() {
        return "types=" + this.types + " vars=" + this.vars;
    }

    public String toString() {
        return "(" + this.kind + " " + this.mapsToString() + " " + this.outer + ")";
    }

    @Override
    public Context pop() {
        return this.outer;
    }

    @Override
    public Named find(String name) throws SemanticException {
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "find-type " + name + " in " + this);
        }
        if (this.isOuter()) {
            return this.ts.systemResolver().find(name);
        }
        if (this.isSource()) {
            return this.it.find(name);
        }
        Named type = this.findInThisScope(name);
        if (type != null) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find " + name + " -> " + type);
            }
            return type;
        }
        if (this.outer != null) {
            return this.outer.find(name);
        }
        throw new SemanticException("Type " + name + " not found.");
    }

    @Override
    public Context pushSource(ImportTable it) {
        Context_c v = this.push();
        v.kind = SOURCE;
        v.it = it;
        v.inCode = false;
        v.staticContext = false;
        return v;
    }

    @Override
    public Context pushClass(ParsedClassType classScope, ClassType type) {
        if (Report.should_report(TOPICS, 4)) {
            Report.report(4, "push class " + classScope + " " + classScope.position());
        }
        Context_c v = this.push();
        v.kind = CLASS;
        v.scope = classScope;
        v.type = type;
        v.inCode = false;
        v.staticContext = false;
        return v;
    }

    @Override
    public Context pushBlock() {
        if (Report.should_report(TOPICS, 4)) {
            Report.report(4, "push block");
        }
        Context_c v = this.push();
        v.kind = BLOCK;
        return v;
    }

    @Override
    public Context pushLabel(String label) {
        if (Report.should_report(TOPICS, 4)) {
            Report.report(4, "push label");
        }
        Context_c v = this.push();
        v.kind = LABEL;
        v.label = label;
        return v;
    }

    @Override
    public Context pushStatic() {
        if (Report.should_report(TOPICS, 4)) {
            Report.report(4, "push static");
        }
        Context_c v = this.push();
        v.staticContext = true;
        return v;
    }

    @Override
    public Context pushCode(CodeInstance ci) {
        if (Report.should_report(TOPICS, 4)) {
            Report.report(4, "push code " + ci + " " + ci.position());
        }
        Context_c v = this.push();
        v.kind = CODE;
        v.code = ci;
        v.inCode = true;
        v.staticContext = ci.flags().isStatic();
        return v;
    }

    @Override
    public CodeInstance currentCode() {
        return this.code;
    }

    @Override
    public boolean inCode() {
        return this.inCode;
    }

    @Override
    public boolean inStaticContext() {
        return this.staticContext;
    }

    @Override
    public ClassType currentClass() {
        return this.type;
    }

    @Override
    public ParsedClassType currentClassScope() {
        return this.scope;
    }

    @Override
    public void addVariable(VarInstance vi) {
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "Adding " + vi + " to context.");
        }
        this.addVariableToThisScope(vi);
    }

    @Override
    @Deprecated
    public void addMethod(MethodInstance mi) {
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "Adding " + mi + " to context.");
        }
    }

    @Override
    public void addNamed(Named t) {
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "Adding type " + t + " to context.");
        }
        this.addNamedToThisScope(t);
    }

    public Named findInThisScope(String name) {
        Named t;
        block4: {
            t = null;
            if (this.types != null) {
                t = this.types.get(name);
            }
            if (t == null && this.isClass()) {
                try {
                    return this.ts.findMemberClass(this.type, name, this.type);
                }
                catch (SemanticException semanticException) {
                    if (this.type.isAnonymous() || !this.type.name().equals(name)) break block4;
                    return this.type;
                }
            }
        }
        return t;
    }

    public void addNamedToThisScope(Named type) {
        if (this.types == null) {
            this.types = new HashMap<String, Named>();
        }
        this.types.put(type.name(), type);
    }

    public ClassType findMethodContainerInThisScope(String name) {
        if (this.isClass() && this.ts.hasMethodNamed(this.currentClass(), name)) {
            return this.type;
        }
        return null;
    }

    public VarInstance findVariableInThisScope(String name) {
        VarInstance vi = null;
        if (this.vars != null) {
            vi = this.vars.get(name);
        }
        if (vi == null && this.isClass()) {
            try {
                return this.ts.findField(this.type, name, this.type, true);
            }
            catch (SemanticException e) {
                return null;
            }
        }
        return vi;
    }

    public void addVariableToThisScope(VarInstance var) {
        if (this.vars == null) {
            this.vars = new HashMap<String, VarInstance>();
        }
        this.vars.put(var.name(), var);
    }

    public static class Kind
    extends Enum {
        private static final long serialVersionUID = SerialVersionUID.generate();

        public Kind(String name) {
            super(name);
        }
    }
}

