/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import polyglot.types.ArrayType;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.MethodInstance;
import polyglot.types.ReferenceType;
import polyglot.types.ReferenceType_c;
import polyglot.types.Resolver;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class ArrayType_c
extends ReferenceType_c
implements ArrayType {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Type base;
    protected List<FieldInstance> fields;
    protected List<MethodInstance> methods;
    protected List<ClassType> interfaces;

    protected ArrayType_c() {
    }

    public ArrayType_c(TypeSystem ts, Position pos, Type base) {
        super(ts, pos);
        this.base = base;
        this.methods = null;
        this.fields = null;
        this.interfaces = null;
    }

    protected void init() {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodInstance>(1);
            this.methods.add(this.createCloneMethodInstance());
        }
        if (this.fields == null) {
            this.fields = new ArrayList<FieldInstance>(1);
            this.fields.add(this.createLengthFieldInstance());
        }
        if (this.interfaces == null) {
            this.interfaces = new ArrayList<ClassType>(2);
            this.interfaces.add(this.ts.Cloneable());
            this.interfaces.add(this.ts.Serializable());
        }
    }

    protected FieldInstance createLengthFieldInstance() {
        FieldInstance fi = this.ts.fieldInstance(this.position(), this, this.ts.Public().Final(), this.ts.Int(), "length");
        fi.setNotConstant();
        return fi;
    }

    protected MethodInstance createCloneMethodInstance() {
        return this.ts.methodInstance(this.position(), this, this.ts.Public(), this.ts.Object(), "clone", Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public Type base() {
        return this.base;
    }

    @Override
    public ArrayType base(Type base) {
        if (base == this.base) {
            return this;
        }
        ArrayType_c n = (ArrayType_c)this.copy();
        n.base = base;
        return n;
    }

    @Override
    public Type ultimateBase() {
        if (this.base().isArray()) {
            return this.base().toArray().ultimateBase();
        }
        return this.base();
    }

    @Override
    public int dims() {
        return 1 + (this.base().isArray() ? this.base().toArray().dims() : 0);
    }

    @Override
    public String toString() {
        return this.base().toString() + "[]";
    }

    @Override
    public void print(CodeWriter w) {
        this.base().print(w);
        w.write("[]");
    }

    @Override
    public String translate(Resolver c) {
        return this.base().translate(c) + "[]";
    }

    @Override
    public boolean isCanonical() {
        return this.base().isCanonical();
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public ArrayType toArray() {
        return this;
    }

    @Override
    public List<? extends MethodInstance> methods() {
        this.init();
        return Collections.unmodifiableList(this.methods);
    }

    @Override
    public List<? extends FieldInstance> fields() {
        this.init();
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public MethodInstance cloneMethod() {
        return this.methods().get(0);
    }

    @Override
    public FieldInstance fieldNamed(String name) {
        FieldInstance fi = this.lengthField();
        return name.equals(fi.name()) ? fi : null;
    }

    @Override
    public FieldInstance lengthField() {
        return this.fields().get(0);
    }

    @Override
    public Type superType() {
        return this.ts.Object();
    }

    @Override
    public List<? extends ReferenceType> interfaces() {
        this.init();
        return Collections.unmodifiableList(this.interfaces);
    }

    @Override
    public int hashCode() {
        return this.base().hashCode() << 1;
    }

    @Override
    public boolean equalsImpl(TypeObject t) {
        if (t instanceof ArrayType) {
            ArrayType a = (ArrayType)t;
            return this.ts.equals(this.base(), a.base());
        }
        return false;
    }

    @Override
    public boolean typeEqualsImpl(Type t) {
        if (t instanceof ArrayType) {
            ArrayType a = (ArrayType)t;
            return this.ts.typeEquals(this.base(), a.base());
        }
        return false;
    }

    @Override
    public boolean isImplicitCastValidImpl(Type toType) {
        if (toType.isArray()) {
            if (this.base().isPrimitive() || toType.toArray().base().isPrimitive()) {
                return this.ts.typeEquals(this.base(), toType.toArray().base());
            }
            return this.ts.isImplicitCastValid(this.base(), toType.toArray().base());
        }
        return this.ts.isSubtype(this, toType);
    }

    @Override
    public boolean isCastValidImpl(Type toType) {
        if (!toType.isReference()) {
            return false;
        }
        if (toType.isArray()) {
            Type fromBase = this.base();
            Type toBase = toType.toArray().base();
            if (fromBase.isPrimitive()) {
                return this.ts.typeEquals(toBase, fromBase);
            }
            if (toBase.isPrimitive()) {
                return false;
            }
            if (fromBase.isNull()) {
                return false;
            }
            if (toBase.isNull()) {
                return false;
            }
            return this.ts.isCastValid(fromBase, toBase);
        }
        return this.ts.isSubtype(this, toType);
    }
}

