/*
 * Decompiled with CFR 0.152.
 */
package polyglot.main;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.JLVersion;
import polyglot.main.Main;
import polyglot.main.OptFlag;
import polyglot.main.Report;
import polyglot.main.UnhandledArgument;
import polyglot.main.UsageError;
import polyglot.util.InternalCompilerError;
import polyglot.util.Pair;

public class Options {
    public static Options global;
    public final ExtensionInfo extension;
    public int error_count;
    private File source_output_directory;
    private File class_output_directory;
    public final List<File> sourcepath_directories = new ArrayList<File>();
    private final List<File> classpath_directories = new ArrayList<File>();
    private final List<File> bootclasspath_directories = new ArrayList<File>();
    public JavaFileManager.Location source_path = StandardLocation.SOURCE_PATH;
    public JavaFileManager.Location source_output = StandardLocation.SOURCE_OUTPUT;
    public JavaFileManager.Location class_output = StandardLocation.CLASS_OUTPUT;
    public JavaFileManager.Location classpath = StandardLocation.CLASS_PATH;
    public JavaFileManager.Location bootclasspath = StandardLocation.PLATFORM_CLASS_PATH;
    public boolean noOutputToFS = false;
    public boolean assertions = false;
    public boolean generate_debugging_info = false;
    public boolean compile_command_line_only = false;
    public String[] source_ext;
    public String output_ext;
    public boolean output_stdout;
    public String post_compiler;
    public String post_compiler_opts;
    public int output_width;
    public boolean fully_qualified_names;
    public boolean serialize_type_info;
    public final Set<String> dump_ast = new HashSet<String>();
    public final Set<String> print_ast = new HashSet<String>();
    public final Set<String> disable_passes = new HashSet<String>();
    public boolean keep_output_files;
    public boolean precise_compiler_generated_positions;
    public boolean use_simple_code_writer;
    public boolean merge_strings;
    public boolean classpath_given;
    public boolean bootclasspath_given;
    protected final Set<OptFlag<?>> flags;
    protected final List<OptFlag.Arg<?>> arguments;
    protected boolean output_source_only;
    protected Boolean print_args;
    protected int USAGE_SCREEN_WIDTH = 76;
    protected int USAGE_FLAG_WIDTH = 27;
    protected int USAGE_SUBSECTION_INDENT = 8;
    public boolean ignore_mod_times;

    public Options(ExtensionInfo extension) {
        this(extension, true);
    }

    public Options(ExtensionInfo extension, boolean checkFlags) {
        this.extension = extension;
        this.flags = new LinkedHashSet();
        this.arguments = new ArrayList();
        this.populateFlags(this.flags);
        if (checkFlags) {
            LinkedHashSet<String> ids = new LinkedHashSet<String>();
            for (OptFlag<?> flag : this.flags) {
                for (String id : flag.ids()) {
                    if (ids.add(id)) continue;
                    throw new InternalCompilerError("Flag " + flag.ids() + " conflicts with " + OptFlag.lookupFlag(id, this.flags).ids());
                }
            }
        }
        this.setDefaultValues();
    }

    public Set<OptFlag<?>> flags() {
        return this.flags;
    }

    public List<OptFlag.Arg<?>> arguments() {
        return this.arguments;
    }

    public List<OptFlag.Arg<?>> filterArgs(Set<OptFlag<?>> flags) {
        ArrayList matches = new ArrayList();
        for (OptFlag.Arg<?> arg : this.arguments) {
            if (arg.flag == null || !flags.contains(arg.flag())) continue;
            matches.add(arg);
        }
        return matches;
    }

    protected void populateFlags(Set<OptFlag<?>> flags) {
        flags.add(new OptFlag<Void>(OptFlag.Kind.HELP, new String[]{"--help", "-h", "-help", "-?"}, null, "print this message"){

            @Override
            public OptFlag.Arg<Void> handle(String[] args, int index) throws UsageError {
                throw new UsageError("", 0);
            }
        });
        flags.add(new OptFlag<Void>(OptFlag.Kind.VERSION, new String[]{"--version", "-version"}, null, "print version info"){

            @Override
            public OptFlag.Arg<Void> handle(String[] args, int index) {
                StringBuffer sb = new StringBuffer();
                if (Options.this.extension != null) {
                    sb.append(Options.this.extension.compilerName() + " version " + Options.this.extension.version() + "\n");
                }
                sb.append("Polyglot compiler toolkit version " + new JLVersion());
                throw new Main.TerminationException(sb.toString(), 0);
            }
        });
        flags.add(new OptFlag<File>("-d", "<directory>", "output directory", "current directory"){

            @Override
            public OptFlag.Arg<File> handle(String[] args, int index) {
                File f = new File(args[index]);
                if (!f.exists()) {
                    f.mkdirs();
                }
                return this.createArg(index + 1, f);
            }

            @Override
            public OptFlag.Arg<File> defaultArg() {
                return this.createDefault(new File(System.getProperty("user.dir")));
            }
        });
        flags.add(new OptFlag<File>("-D", "<directory>", "output directory for .java files", "same as -d"){

            @Override
            public OptFlag.Arg<File> handle(String[] args, int index) {
                File f = new File(args[index]);
                if (!f.exists()) {
                    f.mkdirs();
                }
                return this.createArg(index + 1, f);
            }

            @Override
            public OptFlag.Arg<File> defaultArg(List<OptFlag.Arg<?>> args) {
                List<OptFlag.Arg<?>> outdirs = OptFlag.lookupAll("-d", args);
                if (!outdirs.isEmpty()) {
                    OptFlag.Arg<?> arg = outdirs.get(outdirs.size() - 1);
                    return this.createDefault((File)arg.value());
                }
                return this.createDefault(new File(System.getProperty("user.dir")));
            }

            @Override
            public OptFlag.Arg<File> defaultArg() {
                throw new UnsupportedOperationException("The -D flag requires other arguments to set its default value.");
            }
        });
        flags.add(new OptFlag.PathFlag<File>(new String[]{"-classpath", "-cp"}, "<path>", "where to find user class files", "JVM property: java.class.path"){

            @Override
            public OptFlag.Arg<List<File>> defaultArg() {
                return this.handle(new String[]{System.getProperty("java.class.path")}, 0);
            }

            @Override
            public File handlePathEntry(String entry) {
                File f = new File(entry);
                if (f.exists()) {
                    return f;
                }
                return null;
            }
        });
        flags.add(new OptFlag.PathFlag<File>("-bootclasspath", "<path>", "where to find runtime class files", "JVM property: sun.boot.class.path (or all jars in java.home/lib)"){

            @Override
            public OptFlag.Arg<List<File>> defaultArg() {
                return this.handle(new String[]{Options.this.jvmbootclasspath()}, 0);
            }

            @Override
            public File handlePathEntry(String entry) {
                File f = new File(entry);
                if (f.exists()) {
                    return f;
                }
                return null;
            }
        });
        flags.add(new OptFlag.PathFlag<File>("-addbootcp", "<path>", "prepend <path> to the bootclasspath"){

            @Override
            public File handlePathEntry(String entry) {
                File f = new File(entry);
                if (f.exists()) {
                    return f;
                }
                return null;
            }
        });
        flags.add(new OptFlag.PathFlag<File>("-sourcepath", "<path>", "where to find source files", "current directory"){

            @Override
            public OptFlag.Arg<List<File>> defaultArg() {
                return this.handle(new String[]{System.getProperty("user.dir")}, 0);
            }

            @Override
            public File handlePathEntry(String entry) {
                File f = new File(entry);
                if (f.exists()) {
                    return f;
                }
                return null;
            }
        });
        flags.add(new OptFlag.Switch("-commandlineonly", "only compile files named on the command-line (may also require -c)"));
        flags.add(new OptFlag.Switch("-preferclassfiles", "prefer class files to source files even if the source is newer"));
        flags.add(new OptFlag.Switch("-assert", "recognize the assert keyword"));
        flags.add(new OptFlag.Switch("-fqcn", "output fully-qualified class names"));
        flags.add(new OptFlag.Switch("-g", "generate debugging info in class files"));
        flags.add(new OptFlag.Switch("-c", "compile only to .java"));
        flags.add(new OptFlag.IntFlag("-errors", "<num>", "set the maximum number of errors", 100));
        flags.add(new OptFlag.IntFlag("-w", "<num>", "set the maximum width of the .java output files", 80));
        flags.add(new OptFlag<String>("-postcompiler", "<compiler>", "run javac-like compiler after translation"){

            @Override
            public OptFlag.Arg<String> handle(String[] args, int index) throws UsageError {
                return this.createArg(index + 1, args[index]);
            }
        });
        flags.add(new OptFlag<String>("-postopts", "<options>", "options to pass to the compiler after translation"){

            @Override
            public OptFlag.Arg<String> handle(String[] args, int index) throws UsageError {
                return this.createArg(index + 1, args[index]);
            }
        });
        flags.add(new OptFlag.Switch("-stdout", "output to stdout"));
        flags.add(new OptFlag<String>("-sx", "<ext>", "set source extension"){

            @Override
            public OptFlag.Arg<String> handle(String[] args, int index) throws UsageError {
                return this.createArg(index + 1, args[index]);
            }
        });
        flags.add(new OptFlag<String>("-ox", "<ext>", "set output extension"){

            @Override
            public OptFlag.Arg<String> handle(String[] args, int index) throws UsageError {
                return this.createArg(index + 1, args[index]);
            }

            @Override
            public OptFlag.Arg<String> defaultArg() {
                return this.createDefault("java");
            }
        });
        flags.add(new OptFlag.Switch("-noserial", "disable class serialization"));
        flags.add(new OptFlag<String>("-dump", "<pass>", "dump the ast after pass <pass>"){

            @Override
            public OptFlag.Arg<String> handle(String[] args, int index) throws UsageError {
                return this.createArg(index + 1, args[index]);
            }
        });
        flags.add(new OptFlag<String>("-print", "<pass>", "pretty-print the ast after pass <pass>"){

            @Override
            public OptFlag.Arg<String> handle(String[] args, int index) throws UsageError {
                return this.createArg(index + 1, args[index]);
            }
        });
        flags.add(new OptFlag<String>("-disable", "<pass>", "disable pass <pass>"){

            @Override
            public OptFlag.Arg<String> handle(String[] args, int index) throws UsageError {
                return this.createArg(index + 1, args[index]);
            }
        });
        flags.add(new OptFlag.Switch("-nooutput", "delete output files after compilation"));
        flags.add(new OptFlag.Switch(new String[]{"-v", "-verbose"}, "delete output files after compilation"));
        StringBuffer allowedTopics = new StringBuffer("Allowed topics: ");
        Iterator<String> iter = Report.topics.iterator();
        while (iter.hasNext()) {
            allowedTopics.append(iter.next());
            if (!iter.hasNext()) continue;
            allowedTopics.append(", ");
        }
        flags.add(new OptFlag<Pair<String, Integer>>("-report", "<topic>=<level>", "print verbose debugging information about topic at specified verbosity. " + allowedTopics.toString()){

            @Override
            public OptFlag.Arg<Pair<String, Integer>> handle(String[] args, int index) throws UsageError {
                StringTokenizer st = new StringTokenizer(args[index], "=");
                String topic = "";
                int level = 0;
                if (st.hasMoreTokens()) {
                    topic = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    try {
                        level = Integer.parseInt(st.nextToken());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                return this.createArg(index + 1, new Pair<String, Integer>(topic, level));
            }
        });
        flags.add(new OptFlag.Switch("-debugpositions", "generate position information for compiler-generated code"));
        flags.add(new OptFlag.Switch("-simpleoutput", "use SimpleCodeWriter"));
        flags.add(new OptFlag.Switch("-mergestrings", "parse concatenated string literals as one single string literal"));
        flags.add(new OptFlag.Switch(OptFlag.Kind.SECRET, "-print-arguments", "Check that no options try to handle the same command line flag."));
        flags.add(new OptFlag.Switch("-no-output-to-fs", "keep .java files in memory if possible"));
    }

    @Deprecated
    public void setDefaultValues() {
    }

    public final void parseCommandLine(String[] args, Set<String> source) throws UsageError {
        int i = 0;
        while (i < args.length) {
            try {
                int ni = this.parseCommand(args, i, source);
                if (ni == i) {
                    throw new UsageError("Illegal option: " + args[i]);
                }
                i = ni;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new UsageError("Missing argument");
            }
        }
        this.validateArgs();
        this.applyArgs(source);
        if (this.print_args.booleanValue()) {
            this.printCommandLine(System.out);
        }
        this.postApplyArgs();
    }

    public final void processArguments(List<OptFlag.Arg<?>> arguments, Set<String> source) throws UsageError {
        this.arguments.clear();
        this.arguments.addAll(arguments);
        this.validateArgs();
        this.applyArgs(source);
        if (this.print_args.booleanValue()) {
            this.printCommandLine(System.out);
        }
        this.postApplyArgs();
    }

    protected void postApplyArgs() {
        if (this.post_compiler != null || this.keep_output_files) {
            this.noOutputToFS = false;
        }
    }

    protected void validateArgs() throws UsageError {
        if (this.arguments.size() < 1) {
            throw new UsageError("No command line arguments given");
        }
        if (!OptFlag.hasSourceArg(this.arguments)) {
            throw new UsageError("must specify at least one source file");
        }
    }

    protected final void applyArgs(Set<String> source) throws UsageError {
        LinkedHashSet seen = new LinkedHashSet();
        for (OptFlag.Arg<?> arg : this.arguments) {
            if (arg.flag == null) {
                this.handleSourceArg(arg, source);
                continue;
            }
            seen.add(arg.flag);
            try {
                this.handleArg(arg);
            }
            catch (UsageError e) {
                throw e;
            }
            catch (Throwable e) {
                throw new InternalCompilerError("Error while handling arg " + arg + " created by " + arg.flag().getClass(), e);
            }
        }
        for (OptFlag optFlag : this.flags) {
            OptFlag.Arg arg;
            if (seen.contains(optFlag) || (arg = optFlag.defaultArg(this.arguments)) == null) continue;
            this.handleArg(arg);
        }
    }

    public void printCommandLine(PrintStream out) {
        LinkedHashSet seen = new LinkedHashSet();
        for (OptFlag.Arg<?> arg : this.arguments) {
            if (arg.flag != null) {
                seen.add(arg.flag);
            }
            out.print(" " + arg.toString());
        }
        for (OptFlag optFlag : this.flags) {
            OptFlag.Arg arg;
            if (seen.contains(optFlag) || (arg = optFlag.defaultArg(this.arguments)) == null) continue;
            out.print(" " + arg.toString());
        }
        out.println();
    }

    protected <To extends Collection<Param>, Param> To sccast(Object in, Class<Param> clazz) {
        Collection out = (Collection)in;
        for (Object p : out) {
            if (clazz.isInstance(p)) continue;
            throw new ClassCastException("Expected " + clazz.getName() + " but " + p + " has type " + p.getClass().getName());
        }
        return (To)out;
    }

    protected void handleArg(OptFlag.Arg<?> arg) throws UsageError {
        assert (arg.flag != null);
        Set<String> ids = arg.flag().ids();
        if (ids.contains("-d")) {
            this.setClassOutput((File)arg.value());
        } else if (ids.contains("-D")) {
            this.setSourceOutput((File)arg.value());
        } else if (ids.contains("-classpath")) {
            this.setClasspath((List)this.sccast(arg.value(), File.class));
        } else if (ids.contains("-bootclasspath")) {
            this.setBootclasspath((List)this.sccast(arg.value(), File.class));
        } else if (ids.contains("-addbootcp")) {
            this.addBootCP((List)this.sccast(arg.value(), File.class));
        } else if (ids.contains("-sourcepath")) {
            this.setSourcepath((List)this.sccast(arg.value(), File.class));
        } else if (ids.contains("-commandlineonly")) {
            this.setCommandLineOnly((Boolean)arg.value());
        } else if (ids.contains("-preferclassfiles")) {
            this.setIgnoreModTimes((Boolean)arg.value());
        } else if (ids.contains("-assert")) {
            this.setAssertions((Boolean)arg.value());
        } else if (ids.contains("-fqcn")) {
            this.setFullyQualifiedNames((Boolean)arg.value());
        } else if (ids.contains("-g")) {
            this.setGenerateDebugInfo((Boolean)arg.value());
        } else if (ids.contains("-c")) {
            this.setOutputOnly((Boolean)arg.value());
        } else if (ids.contains("-errors")) {
            this.setErrorCount((Integer)arg.value());
        } else if (ids.contains("-w")) {
            this.setOutputWidth((Integer)arg.value());
        } else if (ids.contains("-postcompiler")) {
            this.setPostCompiler((String)arg.value());
        } else if (ids.contains("-postopts")) {
            this.setPostCompilerOpts((String)arg.value());
        } else if (ids.contains("-stdout")) {
            this.setOutputStdOut((Boolean)arg.value());
        } else if (ids.contains("-sx")) {
            this.addSourceExtension((String)arg.value());
        } else if (ids.contains("-ox")) {
            this.setOutputExtension((String)arg.value());
        } else if (ids.contains("-noserial")) {
            this.setNoSerializedTypes((Boolean)arg.value());
        } else if (ids.contains("-dump")) {
            this.addDumpAST((String)arg.value());
        } else if (ids.contains("-print")) {
            this.addPrintAST((String)arg.value());
        } else if (ids.contains("-disable")) {
            this.addDisablePass((String)arg.value());
        } else if (ids.contains("-nooutput")) {
            this.setNoOutput((Boolean)arg.value());
        } else if (ids.contains("-verbose")) {
            this.setVerbose((Boolean)arg.value());
        } else if (ids.contains("-report")) {
            Pair pair = (Pair)arg.value();
            this.addReportTopic((String)pair.part1(), (Integer)pair.part2());
        } else if (ids.contains("-debugpositions")) {
            this.setDebugPositions((Boolean)arg.value());
        } else if (ids.contains("-simpleoutput")) {
            this.setSimpleOutput((Boolean)arg.value());
        } else if (ids.contains("-mergestrings")) {
            this.setMergeStrings((Boolean)arg.value());
        } else if (ids.contains("-print-arguments")) {
            this.print_args = (Boolean)arg.value();
        } else if (ids.contains("-no-output-to-fs")) {
            this.noOutputToFS = (Boolean)arg.value();
        } else {
            throw new UnhandledArgument(arg);
        }
    }

    protected void handleSourceArg(OptFlag.Arg<?> arg, Set<String> source) {
        String filename = (String)arg.value();
        source.add(filename);
    }

    protected void setClassOutput(File f) {
        this.class_output_directory = f;
    }

    protected void setSourceOutput(File f) {
        this.source_output_directory = f;
    }

    protected void setClasspath(List<File> value) {
        this.classpathDirectories().addAll(value);
    }

    protected void setBootclasspath(List<File> value) {
        this.bootclasspathDirectories().addAll(value);
    }

    protected void addBootCP(List<File> value) {
        this.bootclasspathDirectories().addAll(value);
    }

    protected void setSourcepath(List<File> value) {
        this.sourcepath_directories.addAll(value);
    }

    protected void setCommandLineOnly(boolean value) {
        this.compile_command_line_only = value;
    }

    protected void setIgnoreModTimes(boolean value) {
        this.ignore_mod_times = value;
    }

    protected void setAssertions(boolean value) {
        this.assertions = value;
    }

    protected void setFullyQualifiedNames(boolean value) {
        this.fully_qualified_names = value;
    }

    protected void setGenerateDebugInfo(boolean value) {
        this.generate_debugging_info = value;
    }

    protected void setOutputOnly(boolean value) {
        this.output_source_only = value;
    }

    protected void setErrorCount(Integer value) {
        this.error_count = value;
    }

    protected void setOutputWidth(Integer value) {
        this.output_width = value;
    }

    protected void setPostCompiler(String value) {
        this.post_compiler = value;
    }

    protected void setPostCompilerOpts(String value) {
        this.post_compiler_opts = value;
    }

    protected void setOutputStdOut(boolean value) {
        this.output_stdout = value;
    }

    protected void addSourceExtension(String value) {
        if (this.source_ext == null) {
            this.source_ext = new String[]{value};
        } else {
            String[] s = new String[this.source_ext.length + 1];
            System.arraycopy(this.source_ext, 0, s, 0, this.source_ext.length);
            s[s.length - 1] = value;
            this.source_ext = s;
        }
    }

    protected void setOutputExtension(String value) {
        this.output_ext = value;
    }

    protected void setNoSerializedTypes(boolean value) {
        this.serialize_type_info = !value;
    }

    protected void addDumpAST(String value) {
        this.dump_ast.add(value);
    }

    protected void addPrintAST(String value) {
        this.print_ast.add(value);
    }

    protected void addDisablePass(String value) {
        this.disable_passes.add(value);
    }

    protected void setNoOutput(boolean value) {
        boolean bl = this.keep_output_files = !value;
        if (value) {
            this.output_width = 1000;
        }
    }

    protected void addReportTopic(String topic, Integer level) {
        Report.addTopic(topic, level);
    }

    protected void setVerbose(boolean value) {
        if (value) {
            Report.addTopic("verbose", 1);
        }
    }

    protected void setDebugPositions(boolean value) {
        this.precise_compiler_generated_positions = value;
    }

    protected void setSimpleOutput(boolean value) {
        this.use_simple_code_writer = value;
    }

    protected void setMergeStrings(boolean value) {
        this.merge_strings = value;
    }

    protected int parseCommand(String[] args, int index, Set<String> source) throws UsageError, Main.TerminationException {
        for (OptFlag<?> flag : this.flags) {
            if (!flag.ids.contains(args[index])) continue;
            OptFlag.Arg<?> arg = flag.handle(args, index + 1);
            this.arguments.add(arg);
            return arg.next();
        }
        if (!args[index].startsWith("-")) {
            index = this.parseSourceArg(args, index);
        }
        return index;
    }

    protected int parseSourceArg(String[] args, int index) {
        OptFlag.Arg<String> src = new OptFlag.Arg<String>(index + 1, args[index]);
        this.arguments.add(src);
        return src.next();
    }

    public JavaFileManager.Location outputLocation() {
        return this.source_output;
    }

    public JavaFileManager.Location classOutputLocation() {
        return this.class_output;
    }

    public File classOutputDirectory() {
        return this.class_output_directory;
    }

    public void usageHeader(PrintStream out) {
        out.println("usage: " + this.extension.compilerName() + " [options] " + "<source-file>." + this.extension.fileExtensions()[0] + " ...");
        out.println("where [options] includes:");
    }

    public void usage(PrintStream out, boolean showSecretMenu) {
        this.usageHeader(out);
        boolean firstSecretItem = true;
        ArrayList sorted = new ArrayList(this.flags);
        Collections.sort(sorted, null);
        for (OptFlag optFlag : sorted) {
            boolean isSecret;
            boolean bl = isSecret = optFlag.kind.compareTo(OptFlag.Kind.SECRET) >= 0;
            if (showSecretMenu && isSecret && firstSecretItem) {
                out.println();
                out.println("Secret menu:");
                firstSecretItem = false;
            }
            if (!showSecretMenu && isSecret) continue;
            optFlag.printUsage(out);
        }
    }

    public void usage(PrintStream out) {
        this.usage(out, false);
    }

    protected void usageForFlag(PrintStream out, String flag, String description) {
        out.print("  ");
        out.print(flag);
        int cur = flag.length() + 2;
        if (cur < this.USAGE_FLAG_WIDTH) {
            Options.printSpaces(out, this.USAGE_FLAG_WIDTH - cur);
        } else {
            out.println();
            Options.printSpaces(out, this.USAGE_FLAG_WIDTH);
        }
        cur = this.USAGE_FLAG_WIDTH;
        StringTokenizer st = new StringTokenizer(description);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (cur + s.length() > this.USAGE_SCREEN_WIDTH) {
                out.println();
                Options.printSpaces(out, this.USAGE_FLAG_WIDTH);
                cur = this.USAGE_FLAG_WIDTH;
            }
            out.print(s);
            cur += s.length();
            if (!st.hasMoreTokens()) continue;
            if (cur + 1 > this.USAGE_SCREEN_WIDTH) {
                out.println();
                Options.printSpaces(out, this.USAGE_FLAG_WIDTH);
                cur = this.USAGE_FLAG_WIDTH;
                continue;
            }
            out.print(" ");
            ++cur;
        }
        out.println();
    }

    protected void usageSubsection(PrintStream out, String text) {
        Options.printSpaces(out, this.USAGE_SUBSECTION_INDENT);
        int cur = this.USAGE_SUBSECTION_INDENT;
        StringTokenizer st = new StringTokenizer(text);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (cur + s.length() > this.USAGE_SCREEN_WIDTH) {
                out.println();
                Options.printSpaces(out, this.USAGE_SUBSECTION_INDENT);
                cur = this.USAGE_SUBSECTION_INDENT;
            }
            out.print(s);
            cur += s.length();
            if (!st.hasMoreTokens()) continue;
            if (cur + 1 > this.USAGE_SCREEN_WIDTH) {
                out.println();
                Options.printSpaces(out, this.USAGE_SUBSECTION_INDENT);
                cur = this.USAGE_SUBSECTION_INDENT;
                continue;
            }
            out.print(' ');
            ++cur;
        }
        out.println();
    }

    protected static void printSpaces(PrintStream out, int n) {
        while (n-- > 0) {
            out.print(' ');
        }
    }

    public String constructPostCompilerClasspath() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.sourceOutputDirectory().getAbsolutePath());
        builder.append(File.pathSeparatorChar);
        builder.append('.');
        builder.append(File.pathSeparatorChar);
        for (File f : this.classpathDirectories()) {
            builder.append(f.getAbsolutePath());
            builder.append(File.pathSeparatorChar);
        }
        for (File f : this.bootclasspathDirectories()) {
            builder.append(f.getAbsolutePath());
            builder.append(File.pathSeparatorChar);
        }
        return builder.toString();
    }

    public String jvmbootclasspath() {
        String boot = System.getProperty("sun.boot.class.path");
        if (boot == null) {
            boot = "";
            File java_home_libdir = System.getProperty("os.name").indexOf("Mac") != -1 ? new File(System.getProperty("java.home") + File.separator + ".." + File.separator + "Classes") : new File(System.getProperty("java.home") + File.separator + "lib");
            File[] files = java_home_libdir.listFiles();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().endsWith("jar")) continue;
                sb.append(files[i]);
                if (i + 1 >= files.length) continue;
                sb.append(';');
            }
            boot = sb.toString();
        }
        return boot;
    }

    public List<File> defaultPlatformClasspath() {
        ArrayList<File> path = new ArrayList<File>();
        StringTokenizer st = new StringTokenizer(this.jvmbootclasspath(), File.pathSeparator);
        while (st.hasMoreTokens()) {
            File next = new File(st.nextToken());
            path.add(next);
        }
        return path;
    }

    public List<File> classpathDirectories() {
        return this.classpath_directories;
    }

    public List<File> bootclasspathDirectories() {
        return this.bootclasspath_directories;
    }

    public File sourceOutputDirectory() {
        return this.source_output_directory;
    }
}

