/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend.passes;

import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.TypeExists;
import polyglot.frontend.passes.ClassFilePass;
import polyglot.types.Named;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.ErrorQueue;

public class TypeExistsPass
extends ClassFilePass {
    protected Scheduler scheduler;
    protected TypeExists goal;
    protected TypeSystem ts;

    public TypeExistsPass(Scheduler scheduler, TypeSystem ts, TypeExists goal) {
        super(goal);
        this.scheduler = scheduler;
        this.ts = ts;
        this.goal = goal;
    }

    @Override
    public boolean run() {
        String name = this.goal.typeName();
        try {
            Named n = this.ts.systemResolver().find(name);
            if (n instanceof Type) {
                return true;
            }
        }
        catch (SemanticException e) {
            ErrorQueue eq = this.ts.extensionInfo().compiler().errorQueue();
            eq.enqueue(5, e.getMessage(), e.position());
        }
        return false;
    }
}

