/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend.goals;

import java.util.ArrayList;
import java.util.Collection;
import polyglot.frontend.AbstractPass;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Pass;
import polyglot.frontend.Scheduler;
import polyglot.frontend.SchedulerException;
import polyglot.frontend.goals.ClassTypeGoal;
import polyglot.frontend.goals.Goal;
import polyglot.frontend.passes.AddMembersPass;
import polyglot.types.ParsedClassType;

public class MembersAdded
extends ClassTypeGoal {
    public static Goal create(Scheduler scheduler, ParsedClassType ct) {
        return scheduler.internGoal(new MembersAdded(ct));
    }

    protected MembersAdded(ParsedClassType ct) {
        super(ct);
    }

    @Override
    public Pass createPass(ExtensionInfo extInfo) {
        if (this.job() != null) {
            return new MembersAddedPass(this);
        }
        return new AddMembersPass(extInfo.scheduler(), this);
    }

    @Override
    public Collection<Goal> prerequisiteGoals(Scheduler scheduler) {
        ArrayList<Goal> l = new ArrayList<Goal>();
        if (this.ct.job() != null) {
            l.add(scheduler.Parsed(this.ct.job()));
        }
        l.addAll(super.prerequisiteGoals(scheduler));
        return l;
    }

    @Override
    public Collection<Goal> corequisiteGoals(Scheduler scheduler) {
        ArrayList<Goal> l = new ArrayList<Goal>();
        if (this.ct.job() != null) {
            l.add(scheduler.TypesInitialized(this.ct.job()));
        }
        l.addAll(super.corequisiteGoals(scheduler));
        return l;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof MembersAdded && super.equals(o);
    }

    protected static class MembersAddedPass
    extends AbstractPass {
        MembersAddedPass(Goal goal) {
            super(goal);
        }

        @Override
        public boolean run() {
            MembersAdded goal = (MembersAdded)this.goal;
            if (!goal.type().membersAdded()) {
                throw new SchedulerException();
            }
            return true;
        }
    }
}

